/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.incubator.codec.http3.DefaultHttp3CancelPushFrame;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3CancelPushFrame;
import io.netty.incubator.codec.http3.Http3CodecUtils;
import io.netty.incubator.codec.http3.Http3ErrorCode;
import io.netty.incubator.codec.http3.Http3PushStreamServerInitializer;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamChannelBootstrap;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.UnaryOperator;

public final class Http3ServerPushStreamManager {
    private static final AtomicLongFieldUpdater<Http3ServerPushStreamManager> nextIdUpdater = AtomicLongFieldUpdater.newUpdater(Http3ServerPushStreamManager.class, "nextId");
    private static final Object CANCELLED_STREAM = new Object();
    private static final Object PUSH_ID_GENERATED = new Object();
    private static final Object AWAITING_STREAM_ESTABLISHMENT = new Object();
    private final QuicChannel channel;
    private final ConcurrentMap<Long, Object> pushStreams;
    private final ChannelInboundHandler controlStreamListener;
    private volatile long nextId;

    public Http3ServerPushStreamManager(QuicChannel channel) {
        this(channel, 8);
    }

    public Http3ServerPushStreamManager(QuicChannel channel, int initialPushStreamsCountHint) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.pushStreams = PlatformDependent.newConcurrentHashMap((int)initialPushStreamsCountHint);
        this.controlStreamListener = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof Http3CancelPushFrame) {
                    long pushId = ((Http3CancelPushFrame)msg).id();
                    if (pushId >= Http3ServerPushStreamManager.this.nextId) {
                        Http3CodecUtils.connectionError(ctx, Http3ErrorCode.H3_ID_ERROR, "CANCEL_PUSH id greater than the last known id", true);
                        return;
                    }
                    Http3ServerPushStreamManager.this.pushStreams.computeIfPresent(pushId, (id, existing) -> {
                        if (existing == AWAITING_STREAM_ESTABLISHMENT) {
                            return CANCELLED_STREAM;
                        }
                        if (existing == PUSH_ID_GENERATED) {
                            throw new IllegalStateException("Unexpected push stream state " + existing + " for pushId: " + id);
                        }
                        assert (existing instanceof QuicStreamChannel);
                        ((QuicStreamChannel)existing).close();
                        return null;
                    });
                }
                ReferenceCountUtil.release((Object)msg);
            }
        };
    }

    public boolean isPushAllowed() {
        return this.isPushAllowed(Http3.maxPushIdReceived(this.channel));
    }

    public long reserveNextPushId() {
        long maxPushId = Http3.maxPushIdReceived(this.channel);
        if (this.isPushAllowed(maxPushId)) {
            return this.nextPushId();
        }
        throw new IllegalStateException("MAX allowed push ID: " + maxPushId + ", next push ID: " + this.nextId);
    }

    public Future<QuicStreamChannel> newPushStream(long pushId, ChannelHandler handler) {
        Promise promise = this.channel.eventLoop().newPromise();
        this.newPushStream(pushId, handler, (Promise<QuicStreamChannel>)promise);
        return promise;
    }

    public void newPushStream(long pushId, ChannelHandler handler, Promise<QuicStreamChannel> promise) {
        this.validatePushId(pushId);
        this.channel.createStream(QuicStreamType.UNIDIRECTIONAL, (ChannelHandler)this.pushStreamInitializer(pushId, handler), promise);
        Http3ServerPushStreamManager.setupCancelPushIfStreamCreationFails(pushId, promise, this.channel);
    }

    public void newPushStream(long pushId, ChannelHandler handler, UnaryOperator<QuicStreamChannelBootstrap> bootstrapConfigurator, Promise<QuicStreamChannel> promise) {
        this.validatePushId(pushId);
        QuicStreamChannelBootstrap bootstrap = (QuicStreamChannelBootstrap)bootstrapConfigurator.apply(this.channel.newStreamBootstrap());
        bootstrap.type(QuicStreamType.UNIDIRECTIONAL).handler((ChannelHandler)this.pushStreamInitializer(pushId, handler)).create(promise);
        Http3ServerPushStreamManager.setupCancelPushIfStreamCreationFails(pushId, promise, this.channel);
    }

    public ChannelInboundHandler controlStreamListener() {
        return this.controlStreamListener;
    }

    private boolean isPushAllowed(long maxPushId) {
        return this.nextId <= maxPushId;
    }

    private long nextPushId() {
        long pushId = nextIdUpdater.getAndIncrement(this);
        this.pushStreams.put(pushId, PUSH_ID_GENERATED);
        return pushId;
    }

    private void validatePushId(long pushId) {
        if (!this.pushStreams.replace(pushId, PUSH_ID_GENERATED, AWAITING_STREAM_ESTABLISHMENT)) {
            throw new IllegalArgumentException("Unknown push ID: " + pushId);
        }
    }

    private Http3PushStreamServerInitializer pushStreamInitializer(final long pushId, final ChannelHandler handler) {
        final Http3PushStreamServerInitializer initializer = handler instanceof Http3PushStreamServerInitializer ? (Http3PushStreamServerInitializer)handler : null;
        return new Http3PushStreamServerInitializer(pushId){

            @Override
            protected void initPushStream(final QuicStreamChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                    private boolean stateUpdated;

                    public void channelActive(ChannelHandlerContext ctx) {
                        if (!this.stateUpdated) {
                            this.updatePushStreamsMap();
                        }
                    }

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        if (!this.stateUpdated && ctx.channel().isActive()) {
                            this.updatePushStreamsMap();
                        }
                    }

                    private void updatePushStreamsMap() {
                        assert (!this.stateUpdated);
                        this.stateUpdated = true;
                        Http3ServerPushStreamManager.this.pushStreams.compute(pushId, (id, existing) -> {
                            if (existing == AWAITING_STREAM_ESTABLISHMENT) {
                                return ch;
                            }
                            if (existing == CANCELLED_STREAM) {
                                ch.close();
                                return null;
                            }
                            throw new IllegalStateException("Unexpected push stream state " + existing + " for pushId: " + id);
                        });
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                            Http3ServerPushStreamManager.this.pushStreams.remove(pushId);
                        }
                        ctx.fireUserEventTriggered(evt);
                    }
                }});
                if (initializer != null) {
                    initializer.initPushStream(ch);
                } else if (handler != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }
        };
    }

    private static void setupCancelPushIfStreamCreationFails(long pushId, Future<QuicStreamChannel> future, QuicChannel channel) {
        if (future.isDone()) {
            Http3ServerPushStreamManager.sendCancelPushIfFailed(future, pushId, channel);
        } else {
            future.addListener(f -> Http3ServerPushStreamManager.sendCancelPushIfFailed(future, pushId, channel));
        }
    }

    private static void sendCancelPushIfFailed(Future<QuicStreamChannel> future, long pushId, QuicChannel channel) {
        if (!future.isSuccess()) {
            QuicStreamChannel localControlStream = Http3.getLocalControlStream((Channel)channel);
            assert (localControlStream != null);
            localControlStream.writeAndFlush((Object)new DefaultHttp3CancelPushFrame(pushId));
        }
    }
}

