/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.incubator.codec.http3.Http3CodecUtils;
import io.netty.incubator.codec.http3.Http3ConnectionHandler;
import io.netty.incubator.codec.http3.Http3RequestStreamCodecState;
import io.netty.incubator.codec.http3.Http3RequestStreamDecodeStateValidator;
import io.netty.incubator.codec.quic.QuicStreamChannel;

public abstract class Http3PushStreamClientInitializer
extends ChannelInitializer<QuicStreamChannel> {
    protected final void initChannel(QuicStreamChannel ch) {
        if (Http3CodecUtils.isServerInitiatedQuicStream(ch)) {
            throw new IllegalArgumentException("Using client push stream initializer for server stream: " + ch.streamId());
        }
        Http3CodecUtils.verifyIsUnidirectional(ch);
        Http3ConnectionHandler connectionHandler = Http3CodecUtils.getConnectionHandlerOrClose(ch.parent());
        if (connectionHandler == null) {
            return;
        }
        ChannelPipeline pipeline = ch.pipeline();
        Http3RequestStreamDecodeStateValidator decodeStateValidator = new Http3RequestStreamDecodeStateValidator();
        pipeline.addLast(new ChannelHandler[]{connectionHandler.newCodec(Http3RequestStreamCodecState.NO_STATE, decodeStateValidator)});
        pipeline.addLast(new ChannelHandler[]{decodeStateValidator});
        pipeline.addLast(new ChannelHandler[]{connectionHandler.newPushStreamValidationHandler(ch, decodeStateValidator)});
        this.initPushStream(ch);
    }

    protected abstract void initPushStream(QuicStreamChannel var1);
}

