/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.incubator.codec.http3.Http3ConnectionHandler;
import io.netty.incubator.codec.http3.Http3RequestStreamDecodeStateValidator;
import io.netty.incubator.codec.http3.Http3RequestStreamEncodeStateValidator;
import io.netty.incubator.codec.http3.Http3SettingsFrame;
import io.netty.incubator.codec.http3.Http3UnidirectionalStreamInboundServerHandler;
import io.netty.incubator.codec.http3.QpackDecoderHandler;
import io.netty.incubator.codec.http3.QpackEncoderHandler;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.internal.ObjectUtil;
import java.util.function.LongFunction;
import org.jetbrains.annotations.Nullable;

public final class Http3ServerConnectionHandler
extends Http3ConnectionHandler {
    private final ChannelHandler requestStreamHandler;

    public Http3ServerConnectionHandler(ChannelHandler requestStreamHandler) {
        this(requestStreamHandler, null, null, null, true);
    }

    public Http3ServerConnectionHandler(ChannelHandler requestStreamHandler, @Nullable ChannelHandler inboundControlStreamHandler, @Nullable LongFunction<ChannelHandler> unknownInboundStreamHandlerFactory, @Nullable Http3SettingsFrame localSettings, boolean disableQpackDynamicTable) {
        super(true, inboundControlStreamHandler, unknownInboundStreamHandlerFactory, localSettings, disableQpackDynamicTable);
        this.requestStreamHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)requestStreamHandler, (String)"requestStreamHandler");
    }

    @Override
    void initBidirectionalStream(ChannelHandlerContext ctx, QuicStreamChannel streamChannel) {
        ChannelPipeline pipeline = streamChannel.pipeline();
        Http3RequestStreamEncodeStateValidator encodeStateValidator = new Http3RequestStreamEncodeStateValidator();
        Http3RequestStreamDecodeStateValidator decodeStateValidator = new Http3RequestStreamDecodeStateValidator();
        pipeline.addLast(new ChannelHandler[]{this.newCodec(encodeStateValidator, decodeStateValidator)});
        pipeline.addLast(new ChannelHandler[]{encodeStateValidator});
        pipeline.addLast(new ChannelHandler[]{decodeStateValidator});
        pipeline.addLast(new ChannelHandler[]{this.newRequestStreamValidationHandler(streamChannel, encodeStateValidator, decodeStateValidator)});
        pipeline.addLast(new ChannelHandler[]{this.requestStreamHandler});
    }

    @Override
    void initUnidirectionalStream(ChannelHandlerContext ctx, QuicStreamChannel streamChannel) {
        long maxTableCapacity = this.maxTableCapacity();
        streamChannel.pipeline().addLast(new ChannelHandler[]{new Http3UnidirectionalStreamInboundServerHandler(this.codecFactory, this.localControlStreamHandler, this.remoteControlStreamHandler, this.unknownInboundStreamHandlerFactory, () -> new QpackEncoderHandler(maxTableCapacity, this.qpackDecoder), () -> new QpackDecoderHandler(this.qpackEncoder))});
    }
}

