/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.incubator.codec.quic.QuicChannelBootstrap;
import io.netty.incubator.codec.quic.QuicChannelConfig;
import io.netty.incubator.codec.quic.QuicConnectionStats;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamChannelBootstrap;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;

public interface QuicChannel
extends Channel {
    default public ChannelFuture bind(SocketAddress localAddress) {
        return this.pipeline().bind(localAddress);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.pipeline().connect(remoteAddress);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline().connect(remoteAddress, localAddress);
    }

    default public ChannelFuture disconnect() {
        return this.pipeline().disconnect();
    }

    default public ChannelFuture close() {
        return this.pipeline().close();
    }

    default public ChannelFuture deregister() {
        return this.pipeline().deregister();
    }

    default public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline().bind(localAddress, promise);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.pipeline().connect(remoteAddress, promise);
    }

    default public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline().connect(remoteAddress, localAddress, promise);
    }

    default public ChannelFuture disconnect(ChannelPromise promise) {
        return this.pipeline().disconnect(promise);
    }

    default public ChannelFuture close(ChannelPromise promise) {
        return this.pipeline().close(promise);
    }

    default public ChannelFuture deregister(ChannelPromise promise) {
        return this.pipeline().deregister(promise);
    }

    default public ChannelFuture write(Object msg) {
        return this.pipeline().write(msg);
    }

    default public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.pipeline().write(msg, promise);
    }

    default public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.pipeline().writeAndFlush(msg, promise);
    }

    default public ChannelFuture writeAndFlush(Object msg) {
        return this.pipeline().writeAndFlush(msg);
    }

    default public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    default public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline().newProgressivePromise();
    }

    default public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    default public ChannelFuture newFailedFuture(Throwable cause) {
        return this.pipeline().newFailedFuture(cause);
    }

    default public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public QuicChannel read();

    public QuicChannel flush();

    public QuicChannelConfig config();

    public long peerAllowedStreams(QuicStreamType var1);

    default public Future<QuicStreamChannel> createStream(QuicStreamType type, ChannelHandler handler) {
        return this.createStream(type, handler, (Promise<QuicStreamChannel>)this.eventLoop().newPromise());
    }

    public Future<QuicStreamChannel> createStream(QuicStreamType var1, ChannelHandler var2, Promise<QuicStreamChannel> var3);

    default public QuicStreamChannelBootstrap newStreamBootstrap() {
        return new QuicStreamChannelBootstrap(this);
    }

    default public ChannelFuture close(boolean applicationClose, int error, ByteBuf reason) {
        return this.close(applicationClose, error, reason, this.newPromise());
    }

    public ChannelFuture close(boolean var1, int var2, ByteBuf var3, ChannelPromise var4);

    default public Future<QuicConnectionStats> collectStats() {
        return this.collectStats((Promise<QuicConnectionStats>)this.eventLoop().newPromise());
    }

    public Future<QuicConnectionStats> collectStats(Promise<QuicConnectionStats> var1);

    public static QuicChannelBootstrap newBootstrap(Channel channel) {
        return new QuicChannelBootstrap(channel);
    }
}

