/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelPromise;
import io.netty.incubator.codec.quic.BoringSSL;
import io.netty.incubator.codec.quic.BoringSSLCertificateCallback;
import io.netty.incubator.codec.quic.BoringSSLCertificateVerifyCallback;
import io.netty.incubator.codec.quic.BoringSSLHandshakeCompleteCallback;
import io.netty.incubator.codec.quic.QuicError;
import io.netty.incubator.codec.quic.QuicException;
import io.netty.incubator.codec.quic.QuicheLogger;
import io.netty.incubator.codec.quic.QuicheNativeStaticallyReferencedJniMethods;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class Quiche {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Quiche.class);
    private static final boolean DEBUG_LOGGING_ENABLED = logger.isDebugEnabled();
    static final int QUICHE_PROTOCOL_VERSION;
    static final int QUICHE_MAX_CONN_ID_LEN;
    static final int QUICHE_SHUTDOWN_READ;
    static final int QUICHE_SHUTDOWN_WRITE;
    static final int QUICHE_ERR_DONE;
    static final int QUICHE_ERR_BUFFER_TOO_SHORT;
    static final int QUICHE_ERR_UNKNOWN_VERSION;
    static final int QUICHE_ERR_INVALID_FRAME;
    static final int QUICHE_ERR_INVALID_PACKET;
    static final int QUICHE_ERR_INVALID_STATE;
    static final int QUICHE_ERR_INVALID_STREAM_STATE;
    static final int QUICHE_ERR_INVALID_TRANSPORT_PARAM;
    static final int QUICHE_ERR_CRYPTO_FAIL;
    static final int QUICHE_ERR_TLS_FAIL;
    static final int QUICHE_ERR_FLOW_CONTROL;
    static final int QUICHE_ERR_STREAM_LIMIT;
    static final int QUICHE_ERR_FINAL_SIZE;
    static final int QUICHE_ERR_CONGESTION_CONTROL;
    static final int QUICHE_ERR_STREAM_STOPPED;
    static final int QUICHE_CC_RENO;
    static final int QUICHE_CC_CUBIC;

    private static void tryLoadClasses(Class<?> loadingClass, Class<?> ... classes) {
        ClassLoader loader = PlatformDependent.getClassLoader(loadingClass);
        for (Class<?> clazz : classes) {
            Quiche.tryLoadClass(loader, clazz.getName());
        }
    }

    private static void tryLoadClass(ClassLoader classLoader, String className) {
        try {
            Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadNativeLibrary() {
        String libName = "netty_quiche_" + PlatformDependent.normalizedOs() + '_' + PlatformDependent.normalizedArch();
        ClassLoader cl = PlatformDependent.getClassLoader(Quiche.class);
        try {
            NativeLibraryLoader.load((String)libName, (ClassLoader)cl);
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug("Failed to load {}", (Object)libName, (Object)e);
            throw e;
        }
    }

    static native String quiche_version();

    static native boolean quiche_version_is_supported(int var0);

    static native int quiche_header_info(long var0, int var2, int var3, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18);

    static native int quiche_negotiate_version(long var0, int var2, long var3, int var5, long var6, int var8);

    static native int quiche_retry(long var0, int var2, long var3, int var5, long var6, int var8, long var9, int var11, int var12, long var13, int var15);

    static native long quiche_conn_new_with_tls(long var0, int var2, long var3, int var5, long var6, long var8, boolean var10);

    static native boolean quiche_conn_set_qlog_path(long var0, String var2, String var3, String var4);

    static native int quiche_conn_recv(long var0, long var2, int var4);

    static native int quiche_conn_send(long var0, long var2, int var4);

    static native void quiche_conn_free(long var0);

    static native long quiche_conn_peer_streams_left_bidi(long var0);

    static native long quiche_conn_peer_streams_left_uni(long var0);

    static native int quiche_conn_stream_priority(long var0, long var2, byte var4, boolean var5);

    static native byte[] quiche_conn_trace_id(long var0);

    static native int quiche_conn_stream_recv(long var0, long var2, long var4, int var6, long var7);

    static native int quiche_conn_stream_send(long var0, long var2, long var4, int var6, boolean var7);

    static native int quiche_conn_stream_shutdown(long var0, long var2, int var4, long var5);

    static native int quiche_conn_stream_capacity(long var0, long var2);

    static native boolean quiche_conn_stream_finished(long var0, long var2);

    static native int quiche_conn_close(long var0, boolean var2, long var3, long var5, int var7);

    static native boolean quiche_conn_is_established(long var0);

    static native boolean quiche_conn_is_in_early_data(long var0);

    static native boolean quiche_conn_is_closed(long var0);

    static native long[] quiche_conn_stats(long var0);

    static native long quiche_conn_timeout_as_nanos(long var0);

    static native void quiche_conn_on_timeout(long var0);

    static native long quiche_conn_readable(long var0);

    static native long quiche_conn_writable(long var0);

    static native int quiche_stream_iter_next(long var0, long[] var2);

    static native void quiche_stream_iter_free(long var0);

    static native int quiche_conn_dgram_max_writable_len(long var0);

    static native int quiche_conn_dgram_recv_front_len(long var0);

    static native int quiche_conn_dgram_recv(long var0, long var2, int var4);

    static native int quiche_conn_dgram_send(long var0, long var2, int var4);

    static native long quiche_config_new(int var0);

    static native void quiche_config_grease(long var0, boolean var2);

    static native void quiche_config_set_max_idle_timeout(long var0, long var2);

    static native void quiche_config_set_max_recv_udp_payload_size(long var0, long var2);

    static native void quiche_config_set_max_send_udp_payload_size(long var0, long var2);

    static native void quiche_config_set_initial_max_data(long var0, long var2);

    static native void quiche_config_set_initial_max_stream_data_bidi_local(long var0, long var2);

    static native void quiche_config_set_initial_max_stream_data_bidi_remote(long var0, long var2);

    static native void quiche_config_set_initial_max_stream_data_uni(long var0, long var2);

    static native void quiche_config_set_initial_max_streams_bidi(long var0, long var2);

    static native void quiche_config_set_initial_max_streams_uni(long var0, long var2);

    static native void quiche_config_set_ack_delay_exponent(long var0, long var2);

    static native void quiche_config_set_max_ack_delay(long var0, long var2);

    static native void quiche_config_set_disable_active_migration(long var0, boolean var2);

    static native void quiche_config_set_cc_algorithm(long var0, int var2);

    static native void quiche_config_enable_hystart(long var0, boolean var2);

    static native void quiche_config_enable_dgram(long var0, boolean var2, int var3, int var4);

    static native void quiche_config_free(long var0);

    private static native void quiche_enable_debug_logging(QuicheLogger var0);

    private static native long buffer_memory_address(ByteBuffer var0);

    static long memoryAddress(ByteBuf buf) {
        assert (buf.isDirect());
        return buf.hasMemoryAddress() ? buf.memoryAddress() : Quiche.buffer_memory_address(buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
    }

    static long memoryAddress(ByteBuffer buf) {
        assert (buf.isDirect());
        return Quiche.buffer_memory_address(buf);
    }

    static ByteBuf allocateNativeOrder(int capacity) {
        ByteBuf buffer = Unpooled.directBuffer((int)capacity);
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? buffer : buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    static Exception newException(int err) {
        QuicError error = QuicError.valueOf(err);
        QuicException reason = new QuicException(error);
        if (err == QUICHE_ERR_TLS_FAIL) {
            String lastSslError = BoringSSL.ERR_last_error();
            String message = lastSslError != null ? error.message() + ": " + lastSslError : error.message();
            SSLHandshakeException sslExc = new SSLHandshakeException(message);
            sslExc.initCause(reason);
            return sslExc;
        }
        if (err == QUICHE_ERR_CRYPTO_FAIL) {
            return new SSLException(error.message(), reason);
        }
        return reason;
    }

    static boolean throwIfError(int res) throws Exception {
        if (res < 0) {
            if (res == QUICHE_ERR_DONE) {
                return true;
            }
            throw Quiche.newException(res);
        }
        return false;
    }

    static void notifyPromise(int res, ChannelPromise promise) {
        if (res < 0 && res != QUICHE_ERR_DONE) {
            promise.setFailure((Throwable)Quiche.newException(res));
        } else {
            promise.setSuccess();
        }
    }

    private Quiche() {
    }

    static {
        Quiche.tryLoadClasses(Quiche.class, byte[].class, String.class, BoringSSLCertificateCallback.class, BoringSSLCertificateVerifyCallback.class, BoringSSLHandshakeCompleteCallback.class, QuicheLogger.class);
        try {
            Quiche.quiche_version();
        }
        catch (UnsatisfiedLinkError ignore) {
            Quiche.loadNativeLibrary();
        }
        if (DEBUG_LOGGING_ENABLED) {
            Quiche.quiche_enable_debug_logging(new QuicheLogger(logger));
        }
        QUICHE_PROTOCOL_VERSION = QuicheNativeStaticallyReferencedJniMethods.quiche_protocol_version();
        QUICHE_MAX_CONN_ID_LEN = QuicheNativeStaticallyReferencedJniMethods.quiche_max_conn_id_len();
        QUICHE_SHUTDOWN_READ = QuicheNativeStaticallyReferencedJniMethods.quiche_shutdown_read();
        QUICHE_SHUTDOWN_WRITE = QuicheNativeStaticallyReferencedJniMethods.quiche_shutdown_write();
        QUICHE_ERR_DONE = QuicheNativeStaticallyReferencedJniMethods.quiche_err_done();
        QUICHE_ERR_BUFFER_TOO_SHORT = QuicheNativeStaticallyReferencedJniMethods.quiche_err_buffer_too_short();
        QUICHE_ERR_UNKNOWN_VERSION = QuicheNativeStaticallyReferencedJniMethods.quiche_err_unknown_version();
        QUICHE_ERR_INVALID_FRAME = QuicheNativeStaticallyReferencedJniMethods.quiche_err_invalid_frame();
        QUICHE_ERR_INVALID_PACKET = QuicheNativeStaticallyReferencedJniMethods.quiche_err_invalid_packet();
        QUICHE_ERR_INVALID_STATE = QuicheNativeStaticallyReferencedJniMethods.quiche_err_invalid_state();
        QUICHE_ERR_INVALID_STREAM_STATE = QuicheNativeStaticallyReferencedJniMethods.quiche_err_invalid_stream_state();
        QUICHE_ERR_INVALID_TRANSPORT_PARAM = QuicheNativeStaticallyReferencedJniMethods.quiche_err_invalid_transport_param();
        QUICHE_ERR_CRYPTO_FAIL = QuicheNativeStaticallyReferencedJniMethods.quiche_err_crypto_fail();
        QUICHE_ERR_TLS_FAIL = QuicheNativeStaticallyReferencedJniMethods.quiche_err_tls_fail();
        QUICHE_ERR_FLOW_CONTROL = QuicheNativeStaticallyReferencedJniMethods.quiche_err_flow_control();
        QUICHE_ERR_STREAM_LIMIT = QuicheNativeStaticallyReferencedJniMethods.quiche_err_stream_limit();
        QUICHE_ERR_FINAL_SIZE = QuicheNativeStaticallyReferencedJniMethods.quiche_err_final_size();
        QUICHE_ERR_CONGESTION_CONTROL = QuicheNativeStaticallyReferencedJniMethods.quiche_err_congestion_control();
        QUICHE_ERR_STREAM_STOPPED = QuicheNativeStaticallyReferencedJniMethods.quiche_err_stream_stopped();
        QUICHE_CC_RENO = QuicheNativeStaticallyReferencedJniMethods.quiche_cc_reno();
        QUICHE_CC_CUBIC = QuicheNativeStaticallyReferencedJniMethods.quiche_cc_cubic();
    }
}

