/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.ReferenceCounted;

final class QuicheQuicConnection {
    private final ReferenceCounted refCnt;
    private long connection;

    QuicheQuicConnection(long connection, ReferenceCounted refCnt) {
        this.connection = connection;
        this.refCnt = refCnt;
    }

    void free() {
        if (this.connection != -1L) {
            try {
                Quiche.quiche_conn_free(this.connection);
                this.refCnt.release();
            }
            finally {
                this.connection = -1L;
            }
        }
    }

    long address() {
        assert (this.connection != -1L);
        return this.connection;
    }

    boolean isClosed() {
        assert (this.connection != -1L);
        return Quiche.quiche_conn_is_closed(this.connection);
    }

    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }
}

