/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslHandler;
import io.netty.incubator.codec.quic.BoringSSL;
import io.netty.incubator.codec.quic.BoringSSLCertificateCallback;
import io.netty.incubator.codec.quic.BoringSSLCertificateVerifyCallback;
import io.netty.incubator.codec.quic.BoringSSLHandshakeCompleteCallback;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicheQuicConnection;
import io.netty.incubator.codec.quic.QuicheQuicSslEngine;
import io.netty.incubator.codec.quic.QuicheQuicSslEngineMap;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.function.LongFunction;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

final class QuicheQuicSslContext
extends QuicSslContext {
    final ClientAuth clientAuth;
    private final boolean server;
    private final ApplicationProtocolNegotiator apn;
    private long sessionCacheSize;
    private long sessionTimeout;
    private final QuicheQuicSslSessionContext sessionCtx;
    private final QuicheQuicSslEngineMap engineMap = new QuicheQuicSslEngineMap();
    private final NativeSslContext nativeSslContext;

    QuicheQuicSslContext(boolean server, long sessionTimeout, long sessionCacheSize, ClientAuth clientAuth, TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory, String password, Boolean earlyData, String ... applicationProtocols) {
        X509ExtendedKeyManager keyManager;
        X509TrustManager trustManager;
        Quic.ensureAvailability();
        this.server = server;
        ClientAuth clientAuth2 = this.clientAuth = server ? (ClientAuth)ObjectUtil.checkNotNull((Object)clientAuth, (String)"clientAuth") : ClientAuth.NONE;
        if (trustManagerFactory == null) {
            try {
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                trustManager = QuicheQuicSslContext.chooseTrustManager(trustManagerFactory);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            trustManager = QuicheQuicSslContext.chooseTrustManager(trustManagerFactory);
        }
        if (keyManagerFactory == null) {
            if (server) {
                throw new IllegalArgumentException("No KeyManagerFactory");
            }
            keyManager = null;
        } else {
            keyManager = this.chooseKeyManager(keyManagerFactory);
        }
        int verifyMode = server ? QuicheQuicSslContext.boringSSLVerifyModeForServer(this.clientAuth) : BoringSSL.SSL_VERIFY_PEER;
        this.nativeSslContext = new NativeSslContext(BoringSSL.SSLContext_new(server, applicationProtocols, new BoringSSLHandshakeCompleteCallback(this.engineMap), new BoringSSLCertificateCallback(this.engineMap, keyManager, password), new BoringSSLCertificateVerifyCallback(this.engineMap, trustManager), verifyMode, BoringSSL.subjectNames(trustManager.getAcceptedIssuers())));
        this.apn = new QuicheQuicApplicationProtocolNegotiator(applicationProtocols);
        this.sessionCacheSize = BoringSSL.SSLContext_setSessionCacheSize(this.nativeSslContext.address(), sessionCacheSize);
        this.sessionTimeout = BoringSSL.SSLContext_setSessionCacheTimeout(this.nativeSslContext.address(), sessionTimeout);
        if (earlyData != null) {
            BoringSSL.SSLContext_set_early_data_enabled(this.nativeSslContext.address(), earlyData);
        }
        this.sessionCtx = new QuicheQuicSslSessionContext(this);
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManagerFactory keyManagerFactory) {
        for (KeyManager manager : keyManagerFactory.getKeyManagers()) {
            if (!(manager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)manager;
        }
        throw new IllegalArgumentException("No X509ExtendedKeyManager included");
    }

    private static X509TrustManager chooseTrustManager(TrustManagerFactory trustManagerFactory) {
        for (TrustManager manager : trustManagerFactory.getTrustManagers()) {
            if (!(manager instanceof X509TrustManager)) continue;
            return (X509TrustManager)manager;
        }
        throw new IllegalArgumentException("No X509TrustManager included");
    }

    static X509Certificate[] toX509Certificates0(File file) throws CertificateException {
        return QuicheQuicSslContext.toX509Certificates((File)file);
    }

    static PrivateKey toPrivateKey0(File keyFile, String keyPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        return QuicheQuicSslContext.toPrivateKey((File)keyFile, (String)keyPassword);
    }

    static TrustManagerFactory buildTrustManagerFactory0(X509Certificate[] certCollection) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        return QuicheQuicSslContext.buildTrustManagerFactory((X509Certificate[])certCollection, null, null);
    }

    private static int boringSSLVerifyModeForServer(ClientAuth mode) {
        switch (mode) {
            case NONE: {
                return BoringSSL.SSL_VERIFY_NONE;
            }
            case REQUIRE: {
                return BoringSSL.SSL_VERIFY_PEER | BoringSSL.SSL_VERIFY_FAIL_IF_NO_PEER_CERT;
            }
            case OPTIONAL: {
                return BoringSSL.SSL_VERIFY_PEER;
            }
        }
        throw new Error(mode.toString());
    }

    QuicheQuicConnection createConnection(LongFunction<Long> connectionCreator, QuicheQuicSslEngine engine) {
        this.nativeSslContext.retain();
        long ssl = BoringSSL.SSL_new(this.nativeSslContext.address(), this.isServer(), engine.tlsHostName);
        this.engineMap.put(ssl, engine);
        long connection = connectionCreator.apply(ssl);
        if (connection == -1L) {
            this.engineMap.remove(ssl);
            this.nativeSslContext.release();
            return null;
        }
        return new QuicheQuicConnection(connection, (ReferenceCounted)this.nativeSslContext);
    }

    public boolean isClient() {
        return !this.server;
    }

    public List<String> cipherSuites() {
        return Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384");
    }

    public synchronized long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public synchronized long sessionTimeout() {
        return this.sessionTimeout;
    }

    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public QuicSslEngine newEngine(ByteBufAllocator alloc) {
        return new QuicheQuicSslEngine(this, null, -1);
    }

    @Override
    public QuicSslEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        return new QuicheQuicSslEngine(this, peerHost, peerPort);
    }

    public SSLSessionContext sessionContext() {
        return this.sessionCtx;
    }

    protected SslHandler newHandler(ByteBufAllocator alloc, boolean startTls) {
        throw new UnsupportedOperationException();
    }

    public SslHandler newHandler(ByteBufAllocator alloc, Executor delegatedTaskExecutor) {
        throw new UnsupportedOperationException();
    }

    protected SslHandler newHandler(ByteBufAllocator alloc, boolean startTls, Executor executor) {
        throw new UnsupportedOperationException();
    }

    protected SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls) {
        throw new UnsupportedOperationException();
    }

    public SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, Executor delegatedTaskExecutor) {
        throw new UnsupportedOperationException();
    }

    protected SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls, Executor delegatedTaskExecutor) {
        throw new UnsupportedOperationException();
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeSslContext.release();
        }
        finally {
            super.finalize();
        }
    }

    void setSessionTimeout(int seconds) throws IllegalArgumentException {
        this.sessionTimeout = BoringSSL.SSLContext_setSessionCacheTimeout(this.nativeSslContext.address(), seconds);
    }

    void setSessionCacheSize(int size) throws IllegalArgumentException {
        this.sessionCacheSize = BoringSSL.SSLContext_setSessionCacheSize(this.nativeSslContext.address(), size);
    }

    private static final class NativeSslContext
    extends AbstractReferenceCounted {
        private final long ctx;

        NativeSslContext(long ctx) {
            this.ctx = ctx;
        }

        long address() {
            return this.ctx;
        }

        protected void deallocate() {
            BoringSSL.SSLContext_free(this.ctx);
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }

    private static final class QuicheQuicSslSessionContext
    implements SSLSessionContext {
        private final QuicheQuicSslContext context;

        QuicheQuicSslSessionContext(QuicheQuicSslContext context) {
            this.context = context;
        }

        @Override
        public SSLSession getSession(byte[] sessionId) {
            return null;
        }

        @Override
        public Enumeration<byte[]> getIds() {
            return new Enumeration<byte[]>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public byte[] nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public void setSessionTimeout(int seconds) throws IllegalArgumentException {
            this.context.setSessionTimeout(seconds);
        }

        @Override
        public int getSessionTimeout() {
            return (int)this.context.sessionTimeout();
        }

        @Override
        public void setSessionCacheSize(int size) throws IllegalArgumentException {
            this.context.setSessionCacheSize(size);
        }

        @Override
        public int getSessionCacheSize() {
            return (int)this.context.sessionCacheSize();
        }
    }

    private static final class QuicheQuicApplicationProtocolNegotiator
    implements ApplicationProtocolNegotiator {
        private final List<String> protocols;

        QuicheQuicApplicationProtocolNegotiator(String ... protocols) {
            this.protocols = protocols == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(protocols));
        }

        public List<String> protocols() {
            return this.protocols;
        }
    }
}

