/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.aio.AbstractAioChannel;
import io.netty.channel.aio.AioChannelFinder;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

final class UnsafeAioChannelFinder
implements AioChannelFinder {
    private static volatile Map<Class<?>, Long> offsetCache = new HashMap();

    UnsafeAioChannelFinder() {
    }

    @Override
    public AbstractAioChannel findChannel(Runnable command) throws Exception {
        Long offset;
        while ((offset = UnsafeAioChannelFinder.findFieldOffset(command)) != null) {
            Object next = PlatformDependent.getObject(command, offset);
            if (next instanceof AbstractAioChannel) {
                return (AbstractAioChannel)next;
            }
            command = (Runnable)next;
        }
        return null;
    }

    private static Long findFieldOffset(Object command) throws Exception {
        Map<Class<?>, Long> offsetCache = UnsafeAioChannelFinder.offsetCache;
        Class<?> commandType = command.getClass();
        Long res = offsetCache.get(commandType);
        if (res != null) {
            return res;
        }
        for (Field f : commandType.getDeclaredFields()) {
            if (f.getType() == Runnable.class) {
                res = PlatformDependent.objectFieldOffset(f);
                UnsafeAioChannelFinder.put(offsetCache, commandType, res);
                return res;
            }
            if (f.getType() != Object.class) continue;
            f.setAccessible(true);
            Object candidate = f.get(command);
            if (!(candidate instanceof AbstractAioChannel)) continue;
            res = PlatformDependent.objectFieldOffset(f);
            UnsafeAioChannelFinder.put(offsetCache, commandType, res);
            return res;
        }
        return null;
    }

    private static void put(Map<Class<?>, Long> oldCache, Class<?> key, Long value) {
        HashMap newCache = new HashMap(oldCache.size());
        newCache.putAll(oldCache);
        newCache.put(key, value);
        offsetCache = newCache;
    }
}

