/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.BufType;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;

public class ByteArrayEncoder
extends ChannelOutboundMessageHandlerAdapter<byte[]> {
    private final BufType nextBufferType;

    public ByteArrayEncoder(BufType nextBufferType) {
        if (nextBufferType == null) {
            throw new NullPointerException("nextBufferType");
        }
        this.nextBufferType = nextBufferType;
    }

    @Override
    protected void flush(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (msg.length == 0) {
            return;
        }
        switch (this.nextBufferType) {
            case BYTE: {
                ctx.nextOutboundByteBuffer().writeBytes(msg);
                break;
            }
            case MESSAGE: {
                ctx.nextOutboundMessageBuffer().add(Unpooled.wrappedBuffer(msg));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

