/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import java.util.Comparator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession {
    private final Map<Integer, StreamState> activeStreams = new ConcurrentHashMap<Integer, StreamState>();

    SpdySession() {
    }

    int numActiveStreams() {
        return this.activeStreams.size();
    }

    boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    boolean isActiveStream(int streamID) {
        return this.activeStreams.containsKey(streamID);
    }

    Set<Integer> getActiveStreams() {
        TreeSet<Integer> StreamIDs = new TreeSet<Integer>(new PriorityComparator());
        StreamIDs.addAll(this.activeStreams.keySet());
        return StreamIDs;
    }

    void acceptStream(int streamID, byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize) {
        if (!remoteSideClosed || !localSideClosed) {
            this.activeStreams.put(streamID, new StreamState(priority, remoteSideClosed, localSideClosed, sendWindowSize, receiveWindowSize));
        }
    }

    boolean removeStream(int streamID) {
        Integer StreamID = streamID;
        StreamState state = this.activeStreams.get(StreamID);
        this.activeStreams.remove(StreamID);
        if (state != null) {
            return state.clearPendingWrites();
        }
        return false;
    }

    boolean isRemoteSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state == null || state.isRemoteSideClosed();
    }

    void closeRemoteSide(int streamID) {
        Integer StreamID = streamID;
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeRemoteSide();
            if (state.isLocalSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    boolean isLocalSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state == null || state.isLocalSideClosed();
    }

    void closeLocalSide(int streamID) {
        Integer StreamID = streamID;
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeLocalSide();
            if (state.isRemoteSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    boolean hasReceivedReply(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null && state.hasReceivedReply();
    }

    void receivedReply(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        if (state != null) {
            state.receivedReply();
        }
    }

    int getSendWindowSize(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null ? state.getSendWindowSize() : -1;
    }

    int updateSendWindowSize(int streamID, int deltaWindowSize) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null ? state.updateSendWindowSize(deltaWindowSize) : -1;
    }

    int updateReceiveWindowSize(int streamID, int deltaWindowSize) {
        StreamState state = this.activeStreams.get(streamID);
        if (deltaWindowSize > 0) {
            state.setReceiveWindowSizeLowerBound(0);
        }
        return state != null ? state.updateReceiveWindowSize(deltaWindowSize) : -1;
    }

    int getReceiveWindowSizeLowerBound(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null ? state.getReceiveWindowSizeLowerBound() : 0;
    }

    void updateAllReceiveWindowSizes(int deltaWindowSize) {
        for (StreamState state : this.activeStreams.values()) {
            state.updateReceiveWindowSize(deltaWindowSize);
            if (deltaWindowSize >= 0) continue;
            state.setReceiveWindowSizeLowerBound(deltaWindowSize);
        }
    }

    boolean putPendingWrite(int streamID, Object msg) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null && state.putPendingWrite(msg);
    }

    Object getPendingWrite(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null ? state.getPendingWrite() : null;
    }

    Object removePendingWrite(int streamID) {
        StreamState state = this.activeStreams.get(streamID);
        return state != null ? state.removePendingWrite() : null;
    }

    private final class PriorityComparator
    implements Comparator<Integer> {
        private PriorityComparator() {
        }

        @Override
        public int compare(Integer id1, Integer id2) {
            StreamState state1 = (StreamState)SpdySession.this.activeStreams.get(id1);
            StreamState state2 = (StreamState)SpdySession.this.activeStreams.get(id2);
            return state1.getPriority() - state2.getPriority();
        }
    }

    private static final class StreamState {
        private final byte priority;
        private volatile boolean remoteSideClosed;
        private volatile boolean localSideClosed;
        private boolean receivedReply;
        private final AtomicInteger sendWindowSize;
        private final AtomicInteger receiveWindowSize;
        private volatile int receiveWindowSizeLowerBound;
        private final Queue<Object> pendingWriteQueue = new ConcurrentLinkedQueue<Object>();

        StreamState(byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize) {
            this.priority = priority;
            this.remoteSideClosed = remoteSideClosed;
            this.localSideClosed = localSideClosed;
            this.sendWindowSize = new AtomicInteger(sendWindowSize);
            this.receiveWindowSize = new AtomicInteger(receiveWindowSize);
        }

        byte getPriority() {
            return this.priority;
        }

        boolean isRemoteSideClosed() {
            return this.remoteSideClosed;
        }

        void closeRemoteSide() {
            this.remoteSideClosed = true;
        }

        boolean isLocalSideClosed() {
            return this.localSideClosed;
        }

        void closeLocalSide() {
            this.localSideClosed = true;
        }

        boolean hasReceivedReply() {
            return this.receivedReply;
        }

        void receivedReply() {
            this.receivedReply = true;
        }

        int getSendWindowSize() {
            return this.sendWindowSize.get();
        }

        int updateSendWindowSize(int deltaWindowSize) {
            return this.sendWindowSize.addAndGet(deltaWindowSize);
        }

        int updateReceiveWindowSize(int deltaWindowSize) {
            return this.receiveWindowSize.addAndGet(deltaWindowSize);
        }

        int getReceiveWindowSizeLowerBound() {
            return this.receiveWindowSizeLowerBound;
        }

        void setReceiveWindowSizeLowerBound(int receiveWindowSizeLowerBound) {
            this.receiveWindowSizeLowerBound = receiveWindowSizeLowerBound;
        }

        boolean putPendingWrite(Object msg) {
            return this.pendingWriteQueue.offer(msg);
        }

        Object getPendingWrite() {
            return this.pendingWriteQueue.peek();
        }

        Object removePendingWrite() {
            return this.pendingWriteQueue.poll();
        }

        boolean clearPendingWrites() {
            if (this.pendingWriteQueue.isEmpty()) {
                return false;
            }
            this.pendingWriteQueue.clear();
            return true;
        }
    }
}

