/*
 * Copyright 2013 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.netty.buffer;

/**
 * Abstract base class for {@link ByteBuf} implementations that wrap another
 * {@link ByteBuf}.
 */
public abstract class AbstractDerivedByteBuf extends AbstractByteBuf {

    protected AbstractDerivedByteBuf(int maxCapacity) {
        super(maxCapacity);
    }

    @Override
    public final int refCnt() {
        return unwrap().refCnt();
    }

    @Override
    public final ByteBuf retain() {
        return this;
    }

    @Override
    public final ByteBuf retain(int increment) {
        return this;
    }

    @Override
    public final boolean release() {
        return false;
    }

    @Override
    public final boolean release(int decrement) {
        return false;
    }

    @Override
    public final ByteBuf suspendIntermediaryDeallocations() {
        throw new UnsupportedOperationException("derived");
    }

    @Override
    public final ByteBuf resumeIntermediaryDeallocations() {
        throw new UnsupportedOperationException("derived");
    }
}
