/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    PooledHeapByteBuf(int maxCapacity) {
        super(maxCapacity);
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return ((byte[])this.memory)[this.idx(index)];
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        index = this.idx(index);
        return (short)(((byte[])this.memory)[index] << 8 | ((byte[])this.memory)[index + 1] & 0xFF);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        index = this.idx(index);
        return (((byte[])this.memory)[index] & 0xFF) << 16 | (((byte[])this.memory)[index + 1] & 0xFF) << 8 | ((byte[])this.memory)[index + 2] & 0xFF;
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        index = this.idx(index);
        return (((byte[])this.memory)[index] & 0xFF) << 24 | (((byte[])this.memory)[index + 1] & 0xFF) << 16 | (((byte[])this.memory)[index + 2] & 0xFF) << 8 | ((byte[])this.memory)[index + 3] & 0xFF;
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        index = this.idx(index);
        return ((long)((byte[])this.memory)[index] & 0xFFL) << 56 | ((long)((byte[])this.memory)[index + 1] & 0xFFL) << 48 | ((long)((byte[])this.memory)[index + 2] & 0xFFL) << 40 | ((long)((byte[])this.memory)[index + 3] & 0xFFL) << 32 | ((long)((byte[])this.memory)[index + 4] & 0xFFL) << 24 | ((long)((byte[])this.memory)[index + 5] & 0xFFL) << 16 | ((long)((byte[])this.memory)[index + 6] & 0xFFL) << 8 | (long)((byte[])this.memory)[index + 7] & 0xFFL;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        if (dst.hasArray()) {
            this.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, (byte[])this.memory, this.idx(index), length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        System.arraycopy(this.memory, this.idx(index), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index);
        dst.put((byte[])this.memory, this.idx(index), Math.min(this.capacity() - index, dst.remaining()));
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        out.write((byte[])this.memory, this.idx(index), length);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        index = this.idx(index);
        return out.write((ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length));
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.checkIndex(index);
        ((byte[])this.memory)[this.idx((int)index)] = (byte)value;
        return this;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.checkIndex(index, 2);
        index = this.idx(index);
        ((byte[])this.memory)[index] = (byte)(value >>> 8);
        ((byte[])this.memory)[index + 1] = (byte)value;
        return this;
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.checkIndex(index, 3);
        index = this.idx(index);
        ((byte[])this.memory)[index] = (byte)(value >>> 16);
        ((byte[])this.memory)[index + 1] = (byte)(value >>> 8);
        ((byte[])this.memory)[index + 2] = (byte)value;
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.checkIndex(index, 4);
        index = this.idx(index);
        ((byte[])this.memory)[index] = (byte)(value >>> 24);
        ((byte[])this.memory)[index + 1] = (byte)(value >>> 16);
        ((byte[])this.memory)[index + 2] = (byte)(value >>> 8);
        ((byte[])this.memory)[index + 3] = (byte)value;
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.checkIndex(index, 8);
        index = this.idx(index);
        ((byte[])this.memory)[index] = (byte)(value >>> 56);
        ((byte[])this.memory)[index + 1] = (byte)(value >>> 48);
        ((byte[])this.memory)[index + 2] = (byte)(value >>> 40);
        ((byte[])this.memory)[index + 3] = (byte)(value >>> 32);
        ((byte[])this.memory)[index + 4] = (byte)(value >>> 24);
        ((byte[])this.memory)[index + 5] = (byte)(value >>> 16);
        ((byte[])this.memory)[index + 6] = (byte)(value >>> 8);
        ((byte[])this.memory)[index + 7] = (byte)value;
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkIndex(index, length);
        if (src.hasArray()) {
            this.setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            src.getBytes(srcIndex, (byte[])this.memory, this.idx(index), length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        System.arraycopy(src, srcIndex, this.memory, this.idx(index), length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        int length = src.remaining();
        this.checkIndex(index, length);
        src.get((byte[])this.memory, this.idx(index), length);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        return in.read((byte[])this.memory, this.idx(index), length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        index = this.idx(index);
        try {
            return in.read((ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length));
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        ByteBuf copy = this.alloc().heapBuffer(length, this.maxCapacity());
        copy.writeBytes((byte[])this.memory, this.idx(index), length);
        return copy;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        index = this.idx(index);
        return ((ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return (byte[])this.memory;
    }

    @Override
    public int arrayOffset() {
        return this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(byte[] memory) {
        return ByteBuffer.wrap(memory);
    }
}

