/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.Buf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerType;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundByteHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelStateHandler;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventExecutorGroup;
import io.netty.channel.FileRegion;
import io.netty.channel.NoSuchBufferException;
import io.netty.util.DefaultAttributeMap;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class DefaultChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext {
    private static final EnumSet<ChannelHandlerType> EMPTY_TYPE = EnumSet.noneOf(ChannelHandlerType.class);
    volatile DefaultChannelHandlerContext next;
    volatile DefaultChannelHandlerContext prev;
    private final Channel channel;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final Set<ChannelHandlerType> type;
    private final ChannelHandler handler;
    private boolean needsLazyBufInit;
    final EventExecutor executor;
    private final MessageBuf<Object> inMsgBuf;
    private final ByteBuf inByteBuf;
    private MessageBuf<Object> outMsgBuf;
    private ByteBuf outByteBuf;
    private volatile MessageBridge inMsgBridge;
    private volatile MessageBridge outMsgBridge;
    private volatile ByteBridge inByteBridge;
    private volatile ByteBridge outByteBridge;
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, MessageBridge> IN_MSG_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, MessageBridge.class, "inMsgBridge");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, MessageBridge> OUT_MSG_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, MessageBridge.class, "outMsgBridge");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, ByteBridge> IN_BYTE_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, ByteBridge.class, "inByteBridge");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, ByteBridge> OUT_BYTE_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, ByteBridge.class, "outByteBridge");
    private Runnable invokeInboundBufferUpdatedTask;
    private Runnable fireInboundBufferUpdated0Task;
    private Runnable invokeChannelReadSuspendedTask;
    private Runnable invokeRead0Task;
    boolean removed;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutorGroup group, String name, ChannelHandler handler) {
        Buf buf;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        Object type = EMPTY_TYPE.clone();
        if (handler instanceof ChannelStateHandler) {
            ((AbstractCollection)type).add(ChannelHandlerType.STATE);
            if (handler instanceof ChannelInboundHandler) {
                ((AbstractCollection)type).add(ChannelHandlerType.INBOUND);
            }
        }
        if (handler instanceof ChannelOperationHandler) {
            ((AbstractCollection)type).add(ChannelHandlerType.OPERATION);
            if (handler instanceof ChannelOutboundHandler) {
                ((AbstractCollection)type).add(ChannelHandlerType.OUTBOUND);
            }
        }
        this.type = Collections.unmodifiableSet(type);
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        if (group != null) {
            EventExecutor childExecutor = pipeline.childExecutors.get(group);
            if (childExecutor == null) {
                childExecutor = group.next();
                pipeline.childExecutors.put(group, childExecutor);
            }
            this.executor = childExecutor;
        } else {
            this.executor = null;
        }
        if (handler instanceof ChannelInboundHandler) {
            try {
                buf = ((ChannelInboundHandler)handler).newInboundBuffer(this);
            }
            catch (Exception e) {
                throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newInboundBuffer() raised an exception.", e);
            }
            if (buf instanceof ByteBuf) {
                this.inByteBuf = (ByteBuf)buf;
                this.inMsgBuf = null;
            } else {
                if (!(buf instanceof MessageBuf)) throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newInboundBuffer() returned neither " + ByteBuf.class.getSimpleName() + " nor " + MessageBuf.class.getSimpleName() + ": " + buf);
                this.inMsgBuf = (MessageBuf)buf;
                this.inByteBuf = null;
            }
        } else {
            this.inByteBuf = null;
            this.inMsgBuf = null;
        }
        if (!(handler instanceof ChannelOutboundHandler)) return;
        try {
            buf = ((ChannelOutboundHandler)handler).newOutboundBuffer(this);
        }
        catch (Exception e) {
            throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newOutboundBuffer() raised an exception.", e);
        }
        if (buf instanceof ByteBuf) {
            this.outByteBuf = (ByteBuf)buf;
            return;
        } else {
            MessageBuf msgBuf;
            if (!(buf instanceof MessageBuf)) throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newOutboundBuffer() returned neither " + ByteBuf.class.getSimpleName() + " nor " + MessageBuf.class.getSimpleName() + ": " + buf);
            this.outMsgBuf = msgBuf = (MessageBuf)buf;
        }
    }

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, String name, DefaultChannelPipeline.HeadHandler handler) {
        this.type = null;
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.executor = null;
        this.inByteBuf = null;
        this.inMsgBuf = null;
        this.needsLazyBufInit = true;
    }

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, String name, DefaultChannelPipeline.TailHandler handler) {
        this.type = null;
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.executor = null;
        this.inByteBuf = handler.byteSink;
        this.inMsgBuf = handler.msgSink;
        this.outByteBuf = null;
        this.outMsgBuf = null;
    }

    void forwardBufferContent() {
        if (this.hasOutboundByteBuffer() && this.outboundByteBuffer().isReadable()) {
            this.nextOutboundByteBuffer().writeBytes(this.outboundByteBuffer());
            this.flush();
        }
        if (this.hasOutboundMessageBuffer() && !this.outboundMessageBuffer().isEmpty() && this.outboundMessageBuffer().drainTo(this.nextOutboundMessageBuffer()) > 0) {
            this.flush();
        }
        if (this.hasInboundByteBuffer() && this.inboundByteBuffer().isReadable()) {
            this.nextInboundByteBuffer().writeBytes(this.inboundByteBuffer());
            this.fireInboundBufferUpdated();
        }
        if (this.hasInboundMessageBuffer() && !this.inboundMessageBuffer().isEmpty() && this.inboundMessageBuffer().drainTo(this.nextInboundMessageBuffer()) > 0) {
            this.fireInboundBufferUpdated();
        }
    }

    void clearBuffer() {
        if (this.hasOutboundByteBuffer()) {
            this.outboundByteBuffer().clear();
        }
        if (this.hasOutboundMessageBuffer()) {
            this.outboundMessageBuffer().clear();
        }
        if (this.hasInboundByteBuffer()) {
            this.inboundByteBuffer().clear();
        }
        if (this.hasInboundMessageBuffer()) {
            this.inboundMessageBuffer().clear();
        }
    }

    private void lazyInitHeadHandler() {
        if (this.needsLazyBufInit) {
            EventExecutor exec = this.executor();
            if (exec.inEventLoop()) {
                if (this.needsLazyBufInit) {
                    this.needsLazyBufInit = false;
                    DefaultChannelPipeline.HeadHandler headHandler = (DefaultChannelPipeline.HeadHandler)this.handler;
                    headHandler.init(this);
                    this.outByteBuf = headHandler.byteSink;
                    this.outMsgBuf = headHandler.msgSink;
                }
            } else {
                try {
                    DefaultChannelHandlerContext.getFromFuture(exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            DefaultChannelHandlerContext.this.lazyInitHeadHandler();
                        }
                    }));
                }
                catch (Exception e) {
                    throw new ChannelPipelineException("failed to initialize an outbound buffer lazily", e);
                }
            }
        }
    }

    private void fillInboundBridge() {
        ByteBridge bridge;
        if (!(this.handler instanceof ChannelInboundHandler)) {
            return;
        }
        if (this.inMsgBridge != null) {
            MessageBridge bridge2 = this.inMsgBridge;
            if (bridge2 != null) {
                bridge2.fill();
            }
        } else if (this.inByteBridge != null && (bridge = this.inByteBridge) != null) {
            bridge.fill();
        }
    }

    private void fillOutboundBridge() {
        ByteBridge bridge;
        if (!(this.handler instanceof ChannelOutboundHandler)) {
            return;
        }
        if (this.outMsgBridge != null) {
            MessageBridge bridge2 = this.outMsgBridge;
            if (bridge2 != null) {
                bridge2.fill();
            }
        } else if (this.outByteBridge != null && (bridge = this.outByteBridge) != null) {
            bridge.fill();
        }
    }

    private boolean flushInboundBridge() {
        ByteBridge bridge;
        if (this.inMsgBridge != null) {
            MessageBridge bridge2 = this.inMsgBridge;
            if (bridge2 != null) {
                return bridge2.flush(this.inMsgBuf);
            }
        } else if (this.inByteBridge != null && (bridge = this.inByteBridge) != null) {
            return bridge.flush(this.inByteBuf);
        }
        return true;
    }

    private boolean flushOutboundBridge() {
        ByteBridge bridge;
        if (this.outMsgBridge != null) {
            MessageBridge bridge2 = this.outMsgBridge;
            if (bridge2 != null) {
                return bridge2.flush(this.outMsgBuf);
            }
        } else if (this.outByteBridge != null && (bridge = this.outByteBridge) != null) {
            return bridge.flush(this.outByteBuf);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeHandlerBuffersAfterRemoval() {
        if (!this.removed) {
            return;
        }
        ChannelHandler handler = this.handler();
        if (handler instanceof ChannelInboundHandler) {
            try {
                ((ChannelInboundHandler)handler).freeInboundBuffer(this);
            }
            catch (Exception e) {
                this.pipeline.notifyHandlerException(e);
            }
            finally {
                this.freeInboundBridge();
            }
        }
        if (handler instanceof ChannelOutboundHandler) {
            try {
                ((ChannelOutboundHandler)handler).freeOutboundBuffer(this);
            }
            catch (Exception e) {
                this.pipeline.notifyHandlerException(e);
            }
            finally {
                this.freeOutboundBridge();
            }
        }
    }

    private void freeInboundBridge() {
        MessageBridge inMsgBridge;
        ByteBridge inByteBridge = this.inByteBridge;
        if (inByteBridge != null) {
            inByteBridge.release();
        }
        if ((inMsgBridge = this.inMsgBridge) != null) {
            inMsgBridge.release();
        }
    }

    private void freeOutboundBridge() {
        MessageBridge outMsgBridge;
        ByteBridge outByteBridge = this.outByteBridge;
        if (outByteBridge != null) {
            outByteBridge.release();
        }
        if ((outMsgBridge = this.outMsgBridge) != null) {
            outMsgBridge.release();
        }
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Set<ChannelHandlerType> types() {
        return this.type;
    }

    @Override
    public boolean hasInboundByteBuffer() {
        return this.inByteBuf != null;
    }

    @Override
    public boolean hasInboundMessageBuffer() {
        return this.inMsgBuf != null;
    }

    @Override
    public ByteBuf inboundByteBuffer() {
        if (this.inByteBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound byte buffer; it does not implement %s.", this.name, ChannelInboundByteHandler.class.getSimpleName()));
        }
        return this.inByteBuf;
    }

    @Override
    public <T> MessageBuf<T> inboundMessageBuffer() {
        if (this.inMsgBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound message buffer; it does not implement %s.", this.name, ChannelInboundMessageHandler.class.getSimpleName()));
        }
        return this.inMsgBuf;
    }

    @Override
    public boolean hasOutboundByteBuffer() {
        return this.outByteBuf != null;
    }

    @Override
    public boolean hasOutboundMessageBuffer() {
        return this.outMsgBuf != null;
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        if (this.outByteBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound byte buffer; it does not implement %s.", this.name, ChannelOutboundByteHandler.class.getSimpleName()));
        }
        return this.outByteBuf;
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        if (this.outMsgBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound message buffer; it does not implement %s.", this.name, ChannelOutboundMessageHandler.class.getSimpleName()));
        }
        return this.outMsgBuf;
    }

    void executeOnEventLoop(Runnable r) {
        DefaultChannelHandlerContext.waitForFuture(this.executor().submit(r));
    }

    private static <T> T getFromFuture(Future<T> future) throws Exception {
        try {
            return future.get();
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new ChannelPipelineException(t);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static void waitForFuture(Future<?> future) {
        try {
            future.get();
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ChannelPipelineException(t);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ByteBuf nextInboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (true) {
            if (ctx.hasInboundByteBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inByteBuf;
                }
                if (this.executor().inEventLoop(currentThread)) {
                    ByteBridge bridge = ctx.inByteBridge;
                    if (bridge == null && !IN_BYTE_BRIDGE_UPDATER.compareAndSet(ctx, null, bridge = new ByteBridge(ctx, true))) {
                        bridge.release();
                        bridge = ctx.inByteBridge;
                    }
                    return bridge.byteBuf;
                }
                throw new IllegalStateException("nextInboundByteBuffer() called from outside the eventLoop");
            }
            ctx = ctx.next;
        }
    }

    @Override
    public MessageBuf<Object> nextInboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (true) {
            if (ctx.hasInboundMessageBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inMsgBuf;
                }
                if (this.executor().inEventLoop(currentThread)) {
                    MessageBridge bridge = ctx.inMsgBridge;
                    if (bridge == null && !IN_MSG_BRIDGE_UPDATER.compareAndSet(ctx, null, bridge = new MessageBridge())) {
                        bridge.release();
                        bridge = ctx.inMsgBridge;
                    }
                    return bridge.msgBuf;
                }
                throw new IllegalStateException("nextInboundMessageBuffer() called from outside the eventLoop");
            }
            ctx = ctx.next;
        }
    }

    @Override
    public ByteBuf nextOutboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.prev;
        while (true) {
            if (ctx.hasOutboundByteBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outboundByteBuffer();
                }
                if (this.executor().inEventLoop(currentThread)) {
                    ByteBridge bridge = ctx.outByteBridge;
                    if (bridge == null && !OUT_BYTE_BRIDGE_UPDATER.compareAndSet(ctx, null, bridge = new ByteBridge(ctx, false))) {
                        bridge.release();
                        bridge = ctx.outByteBridge;
                    }
                    return bridge.byteBuf;
                }
                throw new IllegalStateException("nextOutboundByteBuffer() called from outside the eventLoop");
            }
            ctx = ctx.prev;
        }
    }

    @Override
    public MessageBuf<Object> nextOutboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.prev;
        while (true) {
            if (ctx.hasOutboundMessageBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outboundMessageBuffer();
                }
                if (this.executor().inEventLoop(currentThread)) {
                    MessageBridge bridge = ctx.outMsgBridge;
                    if (bridge == null && !OUT_MSG_BRIDGE_UPDATER.compareAndSet(ctx, null, bridge = new MessageBridge())) {
                        bridge.release();
                        bridge = ctx.outMsgBridge;
                    }
                    return bridge.msgBuf;
                }
                throw new IllegalStateException("nextOutboundMessageBuffer() called from outside the eventLoop");
            }
            ctx = ctx.prev;
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        this.lazyInitHeadHandler();
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelRegistered();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelRegistered();
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeChannelRegistered() {
        try {
            ((ChannelStateHandler)this.handler()).channelRegistered(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (this.prev != null && executor.inEventLoop()) {
            next.invokeChannelUnregistered();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelUnregistered();
                }
            });
        }
        return this;
    }

    private void invokeChannelUnregistered() {
        try {
            ((ChannelStateHandler)this.handler()).channelUnregistered(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        this.lazyInitHeadHandler();
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelActive();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelActive();
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeChannelActive() {
        try {
            ((ChannelStateHandler)this.handler()).channelActive(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (this.prev != null && executor.inEventLoop()) {
            next.invokeChannelInactive();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelInactive();
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeChannelInactive() {
        try {
            ((ChannelStateHandler)this.handler()).channelInactive(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(final Throwable cause) {
        block5: {
            if (cause == null) {
                throw new NullPointerException("cause");
            }
            final DefaultChannelHandlerContext next = this.next;
            EventExecutor executor = next.executor();
            if (this.prev != null && executor.inEventLoop()) {
                next.invokeExceptionCaught(cause);
            } else {
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            next.invokeExceptionCaught(cause);
                        }
                    });
                }
                catch (Throwable t) {
                    if (!DefaultChannelPipeline.logger.isWarnEnabled()) break block5;
                    DefaultChannelPipeline.logger.warn("Failed to submit an exceptionCaught() event.", t);
                    DefaultChannelPipeline.logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeExceptionCaught(Throwable cause) {
        try {
            this.handler().exceptionCaught(this, cause);
        }
        catch (Throwable t) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", cause);
            }
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(final Object event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        final DefaultChannelHandlerContext next = this.next;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeUserEventTriggered(event);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeUserEventTriggered(event);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeUserEventTriggered(Object event) {
        try {
            this.handler().userEventTriggered(this, event);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandlerContext fireInboundBufferUpdated() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.fireInboundBufferUpdated0();
        } else {
            Runnable task = this.fireInboundBufferUpdated0Task;
            if (task == null) {
                this.fireInboundBufferUpdated0Task = task = new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.fireInboundBufferUpdated0();
                    }
                };
            }
            executor.execute(task);
        }
        return this;
    }

    private void fireInboundBufferUpdated0() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        if (!this.pipeline.isInboundShutdown()) {
            next.fillInboundBridge();
            if (next.executor == this.executor) {
                next.invokeInboundBufferUpdated();
            } else {
                Runnable task = next.invokeInboundBufferUpdatedTask;
                if (task == null) {
                    next.invokeInboundBufferUpdatedTask = task = new Runnable(){

                        @Override
                        public void run() {
                            if (DefaultChannelHandlerContext.this.pipeline.isInboundShutdown()) {
                                return;
                            }
                            if (DefaultChannelHandlerContext.this.findContextInbound() == next) {
                                next.invokeInboundBufferUpdated();
                            } else {
                                DefaultChannelHandlerContext.this.fireInboundBufferUpdated0();
                            }
                        }
                    };
                }
                next.executor().execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInboundBufferUpdated() {
        block18: {
            ChannelStateHandler handler = (ChannelStateHandler)this.handler();
            if (handler instanceof ChannelInboundHandler) {
                while (true) {
                    try {
                        boolean flushedAll = this.flushInboundBridge();
                        handler.inboundBufferUpdated(this);
                        if (!flushedAll) continue;
                        break block18;
                    }
                    catch (Throwable t) {
                        this.pipeline.notifyHandlerException(t);
                        continue;
                    }
                    finally {
                        if (handler instanceof ChannelInboundByteHandler && !this.pipeline.isInboundShutdown()) {
                            try {
                                ((ChannelInboundByteHandler)handler).discardInboundReadBytes(this);
                            }
                            catch (Throwable t) {
                                this.pipeline.notifyHandlerException(t);
                            }
                        }
                        this.freeHandlerBuffersAfterRemoval();
                        continue;
                    }
                    break;
                }
            }
            try {
                handler.inboundBufferUpdated(this);
            }
            catch (Throwable t) {
                this.pipeline.notifyHandlerException(t);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadSuspended() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelReadSuspended();
        } else {
            Runnable task = next.invokeChannelReadSuspendedTask;
            if (task == null) {
                next.invokeChannelReadSuspendedTask = task = new Runnable(){

                    @Override
                    public void run() {
                        if (DefaultChannelHandlerContext.this.findContextInbound() == next) {
                            next.invokeChannelReadSuspended();
                        } else {
                            DefaultChannelHandlerContext.this.fireChannelReadSuspended();
                        }
                    }
                };
            }
            executor.execute(task);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeChannelReadSuspended() {
        try {
            ((ChannelStateHandler)this.handler()).channelReadSuspended(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture flush() {
        return this.flush(this.newPromise());
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.write(message, this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.validateFuture(promise);
        return this.findContextOutbound().invokeBind(localAddress, promise);
    }

    private ChannelFuture invokeBind(final SocketAddress localAddress, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeBind0(localAddress, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeBind0(localAddress, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBind0(SocketAddress localAddress, ChannelPromise promise) {
        try {
            ((ChannelOperationHandler)this.handler()).bind(this, localAddress, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validateFuture(promise);
        return this.findContextOutbound().invokeConnect(remoteAddress, localAddress, promise);
    }

    private ChannelFuture invokeConnect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeConnect0(remoteAddress, localAddress, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeConnect0(remoteAddress, localAddress, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConnect0(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            ((ChannelOperationHandler)this.handler()).connect(this, remoteAddress, localAddress, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        this.validateFuture(promise);
        if (!this.channel().metadata().hasDisconnect()) {
            return this.findContextOutbound().invokeClose(promise);
        }
        return this.findContextOutbound().invokeDisconnect(promise);
    }

    private ChannelFuture invokeDisconnect(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeDisconnect0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeDisconnect0(promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDisconnect0(ChannelPromise promise) {
        try {
            ((ChannelOperationHandler)this.handler()).disconnect(this, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        this.validateFuture(promise);
        return this.findContextOutbound().invokeClose(promise);
    }

    private ChannelFuture invokeClose(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeClose0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeClose0(promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeClose0(ChannelPromise promise) {
        try {
            ((ChannelOperationHandler)this.handler()).close(this, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        this.validateFuture(promise);
        return this.findContextOutbound().invokeDeregister(promise);
    }

    private ChannelFuture invokeDeregister(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeDeregister0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeDeregister0(promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDeregister0(ChannelPromise promise) {
        try {
            ((ChannelOperationHandler)this.handler()).deregister(this, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public void read() {
        this.findContextOutbound().invokeRead();
    }

    private void invokeRead() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeRead0();
        } else {
            Runnable task = this.invokeRead0Task;
            if (task == null) {
                this.invokeRead0Task = task = new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.invokeRead0();
                    }
                };
            }
            executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRead0() {
        try {
            ((ChannelOperationHandler)this.handler()).read(this);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture flush(final ChannelPromise promise) {
        this.validateFuture(promise);
        EventExecutor executor = this.executor();
        Thread currentThread = Thread.currentThread();
        if (executor.inEventLoop(currentThread)) {
            this.invokePrevFlush(promise, currentThread);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokePrevFlush(promise, Thread.currentThread());
                }
            });
        }
        return promise;
    }

    private void invokePrevFlush(ChannelPromise promise, Thread currentThread) {
        DefaultChannelHandlerContext prev = this.findContextOutbound();
        if (this.pipeline.isOutboundShutdown()) {
            promise.setFailure(new ChannelPipelineException("Unable to flush as outbound buffer of next handler was freed already"));
            return;
        }
        prev.fillOutboundBridge();
        prev.invokeFlush(promise, currentThread);
    }

    private ChannelFuture invokeFlush(final ChannelPromise promise, Thread currentThread) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop(currentThread)) {
            this.invokeFlush0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeFlush0(promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFlush0(ChannelPromise promise) {
        Channel channel = this.channel();
        if (!channel.isRegistered() && !channel.isActive()) {
            promise.setFailure(new ClosedChannelException());
            return;
        }
        ChannelOperationHandler handler = (ChannelOperationHandler)this.handler();
        if (handler instanceof ChannelOutboundHandler) {
            this.flushOutboundBridge();
        }
        try {
            handler.flush(this, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            if (handler instanceof ChannelOutboundByteHandler && !this.pipeline.isOutboundShutdown()) {
                try {
                    ((ChannelOutboundByteHandler)handler).discardOutboundReadBytes(this);
                }
                catch (Throwable t) {
                    this.pipeline.notifyHandlerException(t);
                }
            }
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture sendFile(FileRegion region) {
        return this.sendFile(region, this.newPromise());
    }

    @Override
    public ChannelFuture sendFile(FileRegion region, ChannelPromise promise) {
        if (region == null) {
            throw new NullPointerException("region");
        }
        this.validateFuture(promise);
        return this.findContextOutbound().invokeSendFile(region, promise);
    }

    private ChannelFuture invokeSendFile(final FileRegion region, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeSendFile0(region, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeSendFile0(region, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSendFile0(FileRegion region, ChannelPromise promise) {
        ChannelOperationHandler handler = (ChannelOperationHandler)this.handler();
        if (handler instanceof ChannelOutboundHandler) {
            this.flushOutboundBridge();
        }
        try {
            handler.sendFile(this, region, promise);
        }
        catch (Throwable t) {
            this.pipeline.notifyHandlerException(t);
        }
        finally {
            this.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelFuture write(final Object message, final ChannelPromise promise) {
        EventExecutor executor;
        boolean msgBuf;
        DefaultChannelHandlerContext ctx;
        block9: {
            if (message instanceof FileRegion) {
                return this.sendFile((FileRegion)message, promise);
            }
            if (message == null) {
                throw new NullPointerException("message");
            }
            this.validateFuture(promise);
            ctx = this.prev;
            if (message instanceof ByteBuf) {
                while (true) {
                    if (ctx.hasOutboundByteBuffer()) {
                        msgBuf = false;
                        executor = ctx.executor();
                        break block9;
                    }
                    if (ctx.hasOutboundMessageBuffer()) {
                        msgBuf = true;
                        executor = ctx.executor();
                        break block9;
                    }
                    ctx = ctx.prev;
                }
            }
            msgBuf = true;
            while (true) {
                if (ctx.hasOutboundMessageBuffer()) {
                    executor = ctx.executor();
                    break;
                }
                ctx = ctx.prev;
            }
        }
        if (executor.inEventLoop()) {
            ctx.write0(message, promise, msgBuf);
            return promise;
        }
        final DefaultChannelHandlerContext ctx0 = ctx;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ctx0.write0(message, promise, msgBuf);
            }
        });
        return promise;
    }

    private void write0(Object message, ChannelPromise promise, boolean msgBuf) {
        Channel channel = this.channel();
        if (!channel.isRegistered() && !channel.isActive()) {
            promise.setFailure(new ClosedChannelException());
            return;
        }
        if (this.pipeline.isOutboundShutdown()) {
            promise.setFailure(new ChannelPipelineException("Unable to write as outbound buffer of next handler was freed already"));
            return;
        }
        if (msgBuf) {
            this.outboundMessageBuffer().add(message);
        } else {
            ByteBuf buf = (ByteBuf)message;
            this.outboundByteBuffer().writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        }
        this.invokeFlush0(promise);
    }

    void invokeFreeInboundBuffer() {
        EventExecutor executor = this.executor();
        if (this.prev != null && executor.inEventLoop()) {
            this.invokeFreeInboundBuffer0();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.pipeline.shutdownInbound();
                    DefaultChannelHandlerContext.this.invokeFreeInboundBuffer0();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFreeInboundBuffer0() {
        ChannelHandler handler = this.handler();
        if (handler instanceof ChannelInboundHandler) {
            ChannelInboundHandler h = (ChannelInboundHandler)handler;
            try {
                h.freeInboundBuffer(this);
            }
            catch (Throwable t) {
                this.pipeline.notifyHandlerException(t);
            }
            finally {
                this.freeInboundBridge();
            }
        }
        if (this.next != null) {
            DefaultChannelHandlerContext nextCtx = this.findContextInbound();
            nextCtx.invokeFreeInboundBuffer();
        } else {
            this.findContextOutbound().invokeFreeOutboundBuffer();
        }
    }

    private void invokeFreeOutboundBuffer() {
        EventExecutor executor = this.executor();
        if (this.next == null) {
            if (executor.inEventLoop()) {
                this.pipeline.shutdownOutbound();
                this.invokeFreeOutboundBuffer0();
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.pipeline.shutdownOutbound();
                        DefaultChannelHandlerContext.this.invokeFreeOutboundBuffer0();
                    }
                });
            }
        } else if (executor.inEventLoop()) {
            this.invokeFreeOutboundBuffer0();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeFreeOutboundBuffer0();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFreeOutboundBuffer0() {
        ChannelHandler handler = this.handler();
        if (handler instanceof ChannelOutboundHandler) {
            ChannelOutboundHandler h = (ChannelOutboundHandler)handler;
            try {
                h.freeOutboundBuffer(this);
            }
            catch (Throwable t) {
                this.pipeline.notifyHandlerException(t);
            }
            finally {
                this.freeOutboundBridge();
            }
        }
        if (this.prev != null) {
            this.findContextOutbound().invokeFreeOutboundBuffer();
        }
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.channel().newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel().newFailedFuture(cause);
    }

    private void validateFuture(ChannelFuture future) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (future.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("future.channel does not match: %s (expected: %s)", future.channel(), this.channel()));
        }
        if (future.isDone()) {
            throw new IllegalArgumentException("future already done");
        }
        if (future instanceof ChannelFuture.Unsafe) {
            throw new IllegalArgumentException("internal use only future not allowed");
        }
    }

    private DefaultChannelHandlerContext findContextInbound() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.next).handler() instanceof ChannelStateHandler)) {
        }
        return ctx;
    }

    private DefaultChannelHandlerContext findContextOutbound() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.prev).handler() instanceof ChannelOperationHandler)) {
        }
        return ctx;
    }

    private static final class ByteBridge {
        private final ByteBuf byteBuf;
        private final Queue<ByteBuf> exchangeBuf = new ConcurrentLinkedQueue<ByteBuf>();
        private final ChannelHandlerContext ctx;

        ByteBridge(ChannelHandlerContext ctx, boolean inbound) {
            this.ctx = ctx;
            this.byteBuf = inbound ? (ctx.inboundByteBuffer().isDirect() ? ctx.alloc().directBuffer() : ctx.alloc().heapBuffer()) : (ctx.outboundByteBuffer().isDirect() ? ctx.alloc().directBuffer() : ctx.alloc().heapBuffer());
        }

        private void fill() {
            if (!this.byteBuf.isReadable()) {
                return;
            }
            int dataLen = this.byteBuf.readableBytes();
            ByteBuf data = this.byteBuf.isDirect() ? this.ctx.alloc().directBuffer(dataLen, dataLen) : this.ctx.alloc().buffer(dataLen, dataLen);
            this.byteBuf.readBytes(data).discardSomeReadBytes();
            this.exchangeBuf.add(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flush(ByteBuf out) {
            ByteBuf data;
            while ((data = this.exchangeBuf.peek()) != null) {
                if (out.writerIndex() > out.maxCapacity() - data.readableBytes()) {
                    out.capacity(out.maxCapacity());
                    out.writeBytes(data, out.writableBytes());
                    return false;
                }
                this.exchangeBuf.remove();
                try {
                    out.writeBytes(data);
                    continue;
                }
                finally {
                    data.release();
                    continue;
                }
                break;
            }
            return true;
        }

        private void release() {
            this.byteBuf.release();
        }
    }

    private static final class MessageBridge {
        private final MessageBuf<Object> msgBuf = Unpooled.messageBuffer();
        private final Queue<Object[]> exchangeBuf = new ConcurrentLinkedQueue<Object[]>();

        private MessageBridge() {
        }

        private void fill() {
            if (this.msgBuf.isEmpty()) {
                return;
            }
            Object[] data = this.msgBuf.toArray();
            this.msgBuf.clear();
            this.exchangeBuf.add(data);
        }

        private boolean flush(MessageBuf<Object> out) {
            Object[] data;
            while ((data = this.exchangeBuf.peek()) != null) {
                Object m;
                for (int i = 0; i < data.length && (m = data[i]) != null; ++i) {
                    if (!out.offer(m)) {
                        System.arraycopy(data, i, data, 0, data.length - i);
                        for (int j = i + 1; j < data.length; ++j) {
                            data[j] = null;
                        }
                        return false;
                    }
                    data[i] = null;
                }
                this.exchangeBuf.remove();
            }
            return true;
        }

        private void release() {
            this.msgBuf.release();
        }
    }
}

