/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends ChannelOutboundMessageHandlerAdapter<CharSequence> {
    private final BufType nextBufferType;
    private final Charset charset;

    public StringEncoder(BufType nextBufferType) {
        this(nextBufferType, Charset.defaultCharset());
    }

    public StringEncoder(BufType nextBufferType, Charset charset) {
        if (nextBufferType == null) {
            throw new NullPointerException("nextBufferType");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.nextBufferType = nextBufferType;
        this.charset = charset;
    }

    @Override
    protected void flush(ChannelHandlerContext ctx, CharSequence msg) throws Exception {
        ByteBuf encoded = Unpooled.copiedBuffer(msg, this.charset);
        switch (this.nextBufferType) {
            case BYTE: {
                ctx.nextOutboundByteBuffer().writeBytes(encoded);
                break;
            }
            case MESSAGE: {
                ctx.nextOutboundMessageBuffer().add(encoded);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

