/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.BufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFlushPromiseNotifier;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelOutboundByteHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.ssl.ImmediateExecutor;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslHandler
extends ChannelDuplexHandler
implements ChannelInboundByteHandler,
ChannelOutboundByteHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final Executor delegatedTaskExecutor;
    private final ChannelFlushPromiseNotifier flushFutureNotifier = new ChannelFlushPromiseNotifier(true);
    private final boolean startTls;
    private boolean sentFirstMessage;
    private final Queue<ChannelPromise> handshakePromises = new ArrayDeque<ChannelPromise>();
    private final SSLEngineInboundCloseFuture sslCloseFuture = new SSLEngineInboundCloseFuture();
    private final CloseNotifyListener closeNotifyWriteListener = new CloseNotifyListener();
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyTimeoutMillis = 3000L;

    public SslHandler(SSLEngine engine) {
        this(engine, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, startTls, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (delegatedTaskExecutor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = engine;
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.setHandshakeTimeoutMillis(unit.toMillis(handshakeTimeout));
    }

    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        if (handshakeTimeoutMillis < 0L) {
            throw new IllegalArgumentException("handshakeTimeoutMillis: " + handshakeTimeoutMillis + " (expected: >= 0)");
        }
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    public long getCloseNotifyTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setCloseNotifyTimeout(long closeNotifyTimeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.setCloseNotifyTimeoutMillis(unit.toMillis(closeNotifyTimeout));
    }

    public void setCloseNotifyTimeoutMillis(long closeNotifyTimeoutMillis) {
        if (closeNotifyTimeoutMillis < 0L) {
            throw new IllegalArgumentException("closeNotifyTimeoutMillis: " + closeNotifyTimeoutMillis + " (expected: >= 0)");
        }
        this.closeNotifyTimeoutMillis = closeNotifyTimeoutMillis;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public ChannelFuture handshake() {
        return this.handshake(this.ctx.newPromise());
    }

    public ChannelFuture handshake(final ChannelPromise promise) {
        final ChannelHandlerContext ctx = this.ctx;
        final ScheduledFuture<?> timeoutFuture = this.handshakeTimeoutMillis > 0L ? ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (promise.isDone()) {
                    return;
                }
                SSLException e = new SSLException("handshake timed out");
                if (promise.tryFailure(e)) {
                    ctx.fireExceptionCaught(e);
                    ctx.close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        ctx.executor().execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        if (timeoutFuture != null) {
                            timeoutFuture.cancel(false);
                        }
                        SslHandler.this.engine.beginHandshake();
                        SslHandler.this.handshakePromises.add(promise);
                        SslHandler.this.flush0(ctx, ctx.newPromise(), true);
                    }
                    catch (Exception e) {
                        if (!promise.tryFailure(e)) break block3;
                        ctx.fireExceptionCaught(e);
                        ctx.close();
                    }
                }
            }
        });
        return promise;
    }

    public ChannelFuture close() {
        return this.close(this.ctx.newPromise());
    }

    public ChannelFuture close(final ChannelPromise future) {
        final ChannelHandlerContext ctx = this.ctx;
        ctx.executor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    SslHandler.this.engine.closeOutbound();
                    future.addListener(SslHandler.this.closeNotifyWriteListener);
                    try {
                        SslHandler.this.flush(ctx, future);
                    }
                    catch (Exception e) {
                        if (future.tryFailure(e)) break block2;
                        logger.warn("flush() raised a masked exception.", e);
                    }
                }
            }
        });
        return future;
    }

    public ChannelFuture sslCloseFuture() {
        return this.sslCloseFuture;
    }

    @Override
    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().buffer();
    }

    @Override
    public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        ctx.inboundByteBuffer().discardSomeReadBytes();
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        ctx.inboundByteBuffer().release();
    }

    @Override
    public ByteBuf newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().buffer();
    }

    @Override
    public void discardOutboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        ctx.outboundByteBuffer().discardSomeReadBytes();
    }

    @Override
    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        ctx.outboundByteBuffer().release();
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, true);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, false);
    }

    @Override
    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flush0(ctx, promise, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush0(ChannelHandlerContext ctx, ChannelPromise promise, boolean internal) throws Exception {
        ByteBuf in = ctx.outboundByteBuffer();
        ByteBuf out = ctx.nextOutboundByteBuffer();
        if (!internal && this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            out.writeBytes(in);
            ctx.flush(promise);
            return;
        }
        if (ctx.executor() == ctx.channel().eventLoop()) {
            this.flushFutureNotifier.add(promise, in.readableBytes());
        } else {
            ChannelFlushPromiseNotifier channelFlushPromiseNotifier = this.flushFutureNotifier;
            synchronized (channelFlushPromiseNotifier) {
                this.flushFutureNotifier.add(promise, in.readableBytes());
            }
        }
        boolean unwrapLater = false;
        int bytesConsumed = 0;
        try {
            block15: while (true) {
                SSLEngineResult result = SslHandler.wrap(this.engine, in, out);
                bytesConsumed += result.bytesConsumed();
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    if (in.isReadable()) {
                        in.clear();
                        SSLException e = new SSLException("SSLEngine already closed");
                        promise.setFailure(e);
                        ctx.fireExceptionCaught(e);
                        this.flush0(ctx, bytesConsumed, e);
                        bytesConsumed = 0;
                    }
                    break;
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        ctx.flush();
                        continue block15;
                    }
                    case NEED_UNWRAP: {
                        if (!ctx.inboundByteBuffer().isReadable()) break;
                        unwrapLater = true;
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        continue block15;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        continue block15;
                    }
                    case NOT_HANDSHAKING: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
                if (result.bytesConsumed() == 0 && result.bytesProduced() == 0) break;
            }
            if (unwrapLater) {
                this.inboundBufferUpdated(ctx);
            }
        }
        catch (SSLException e) {
            this.setHandshakeFailure(e);
            throw e;
        }
        finally {
            this.flush0(ctx, bytesConsumed);
        }
    }

    private void flush0(final ChannelHandlerContext ctx, final int bytesConsumed) {
        ctx.flush(ctx.newPromise().addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (ctx.executor() == ctx.channel().eventLoop()) {
                    this.notifyFlushFutures(bytesConsumed, future);
                } else {
                    ChannelFlushPromiseNotifier channelFlushPromiseNotifier = SslHandler.this.flushFutureNotifier;
                    synchronized (channelFlushPromiseNotifier) {
                        this.notifyFlushFutures(bytesConsumed, future);
                    }
                }
            }

            private void notifyFlushFutures(int bytesConsumed2, ChannelFuture future) {
                if (future.isSuccess()) {
                    SslHandler.this.flushFutureNotifier.increaseWriteCounter(bytesConsumed2);
                    SslHandler.this.flushFutureNotifier.notifyFlushFutures();
                } else {
                    SslHandler.this.flushFutureNotifier.notifyFlushFutures(future.cause());
                }
            }
        }));
    }

    private void flush0(final ChannelHandlerContext ctx, final int bytesConsumed, final Throwable cause) {
        ChannelFuture flushFuture = ctx.flush(ctx.newPromise().addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (ctx.executor() == ctx.channel().eventLoop()) {
                    this.notifyFlushFutures(bytesConsumed, cause, future);
                } else {
                    ChannelFlushPromiseNotifier channelFlushPromiseNotifier = SslHandler.this.flushFutureNotifier;
                    synchronized (channelFlushPromiseNotifier) {
                        this.notifyFlushFutures(bytesConsumed, cause, future);
                    }
                }
            }

            private void notifyFlushFutures(int bytesConsumed2, Throwable cause2, ChannelFuture future) {
                SslHandler.this.flushFutureNotifier.increaseWriteCounter(bytesConsumed2);
                if (future.isSuccess()) {
                    SslHandler.this.flushFutureNotifier.notifyFlushFutures(cause2);
                } else {
                    SslHandler.this.flushFutureNotifier.notifyFlushFutures(cause2, future.cause());
                }
            }
        }));
        this.safeClose(ctx, flushFuture, ctx.newPromise());
    }

    private static SSLEngineResult wrap(SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        SSLEngineResult result;
        ByteBuffer in0 = in.nioBuffer();
        while (true) {
            ByteBuffer out0 = out.nioBuffer(out.writerIndex(), out.writableBytes());
            result = engine.wrap(in0, out0);
            in.skipBytes(result.bytesConsumed());
            out.writerIndex(out.writerIndex() + result.bytesProduced());
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            out.ensureWritable(engine.getSession().getPacketBufferSize());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.setHandshakeFailure(null);
        try {
            this.inboundBufferUpdated(ctx);
        }
        finally {
            ctx.fireChannelInactive();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.ignoreException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", cause);
            }
            if (ctx.channel().isActive()) {
                ctx.close();
            }
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.sslCloseFuture.isDone()) {
            StackTraceElement[] elements;
            String message = String.valueOf(t.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("io.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf buffer) {
        return SslHandler.getEncryptedPacketLength(buffer) != -1;
    }

    private static int getEncryptedPacketLength(ByteBuf buffer) {
        boolean tls;
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        int packetLength = 0;
        switch (buffer.getUnsignedByte(buffer.readerIndex())) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                tls = true;
                break;
            }
            default: {
                tls = false;
            }
        }
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (majorVersion == 3) {
                packetLength = (SslHandler.getShort(buffer, buffer.readerIndex() + 3) & 0xFFFF) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        if (!tls) {
            boolean sslv2 = true;
            int headerLength = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0 ? 2 : 3;
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + headerLength + 1);
            if (majorVersion == 2 || majorVersion == 3) {
                packetLength = headerLength == 2 ? (SslHandler.getShort(buffer, buffer.readerIndex()) & Short.MAX_VALUE) + 2 : (SslHandler.getShort(buffer, buffer.readerIndex()) & 0x3FFF) + 3;
                if (packetLength <= headerLength) {
                    sslv2 = false;
                }
            } else {
                sslv2 = false;
            }
            if (!sslv2) {
                return -1;
            }
        }
        return packetLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        if (in.readableBytes() < 5) {
            return;
        }
        int packetLength = SslHandler.getEncryptedPacketLength(in);
        if (packetLength == -1) {
            NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + BufUtil.hexDump(in));
            in.skipBytes(in.readableBytes());
            ctx.fireExceptionCaught(e);
            this.setHandshakeFailure(e);
            return;
        }
        assert (packetLength > 0);
        ByteBuf out = ctx.nextInboundByteBuffer();
        boolean wrapLater = false;
        int bytesProduced = 0;
        try {
            block16: while (true) {
                SSLEngineResult result = SslHandler.unwrap(this.engine, in, out);
                bytesProduced += result.bytesProduced();
                switch (result.getStatus()) {
                    case CLOSED: {
                        this.sslCloseFuture.setClosed();
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        break block16;
                    }
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_UNWRAP: {
                        break;
                    }
                    case NEED_WRAP: {
                        wrapLater = true;
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        wrapLater = true;
                        continue block16;
                    }
                    case NOT_HANDSHAKING: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
                if (result.bytesConsumed() == 0 && result.bytesProduced() == 0) break;
            }
            if (!wrapLater) return;
            this.flush0(ctx, ctx.newPromise(), true);
            return;
        }
        catch (SSLException e) {
            this.setHandshakeFailure(e);
            throw e;
        }
        finally {
            if (bytesProduced > 0) {
                ctx.fireInboundBufferUpdated();
            }
        }
    }

    private static short getShort(ByteBuf buf, int offset) {
        return (short)(buf.getByte(offset) << 8 | buf.getByte(offset + 1) & 0xFF);
    }

    private static SSLEngineResult unwrap(SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        SSLEngineResult result;
        ByteBuffer in0 = in.nioBuffer();
        block3: while (true) {
            ByteBuffer out0 = out.nioBuffer(out.writerIndex(), out.writableBytes());
            result = engine.unwrap(in0, out0);
            in.skipBytes(result.bytesConsumed());
            out.writerIndex(out.writerIndex() + result.bytesProduced());
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    out.ensureWritable(engine.getSession().getApplicationBufferSize());
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    private void runDelegatedTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            this.delegatedTaskExecutor.execute(task);
        }
    }

    private void setHandshakeSuccess() {
        ChannelPromise p;
        while ((p = this.handshakePromises.poll()) != null) {
            p.setSuccess();
        }
    }

    private void setHandshakeFailure(Throwable cause) {
        block6: {
            this.engine.closeOutbound();
            boolean disconnected = cause == null || cause instanceof ClosedChannelException;
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                if (!disconnected) {
                    logger.warn("SSLEngine.closeInbound() raised an exception after a handshake failure.", e);
                }
                if (this.closeNotifyWriteListener.done) break block6;
                logger.warn("SSLEngine.closeInbound() raised an exception due to closed connection.", e);
            }
        }
        if (!this.handshakePromises.isEmpty()) {
            ChannelPromise p;
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            while ((p = this.handshakePromises.poll()) != null) {
                p.setFailure(cause);
            }
        }
        this.flush0(this.ctx, 0, cause);
    }

    private void closeOutboundAndChannel(ChannelHandlerContext ctx, ChannelPromise promise, boolean disconnect) throws Exception {
        if (!ctx.channel().isActive()) {
            if (disconnect) {
                ctx.disconnect(promise);
            } else {
                ctx.close(promise);
            }
            return;
        }
        this.engine.closeOutbound();
        ChannelPromise closeNotifyFuture = ctx.newPromise().addListener(this.closeNotifyWriteListener);
        this.flush0(ctx, closeNotifyFuture, true);
        this.safeClose(ctx, closeNotifyFuture, promise);
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.handshake();
        }
    }

    @Override
    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        if (!this.startTls && this.engine.getUseClientMode()) {
            this.handshake().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ctx.pipeline().fireExceptionCaught(future.cause());
                        ctx.close();
                    }
                }
            });
        }
        ctx.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext ctx, ChannelFuture flushFuture, final ChannelPromise promise) {
        if (!ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        final ScheduledFuture<?> timeoutFuture = this.closeNotifyTimeoutMillis > 0L ? ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                logger.warn(ctx.channel() + " last write attempt timed out." + " Force-closing the connection.");
                ctx.close(promise);
            }
        }, this.closeNotifyTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        flushFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture f) throws Exception {
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (ctx.channel().isActive()) {
                    ctx.close(promise);
                }
            }
        });
    }

    private final class SSLEngineInboundCloseFuture
    extends DefaultChannelPromise {
        public SSLEngineInboundCloseFuture() {
            super(null);
        }

        void setClosed() {
            super.trySuccess();
        }

        @Override
        public Channel channel() {
            if (SslHandler.this.ctx == null) {
                return null;
            }
            return SslHandler.this.ctx.channel();
        }

        @Override
        public boolean trySuccess() {
            return false;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            return false;
        }

        @Override
        public ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            throw new IllegalStateException();
        }
    }

    private static final class CloseNotifyListener
    implements ChannelFutureListener {
        volatile boolean done;

        private CloseNotifyListener() {
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (this.done) {
                    throw new IllegalStateException("notified twice");
                }
                this.done = true;
            }
        }
    }
}

