/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;

public class MessageLoggingHandler
extends LoggingHandler {
    public MessageLoggingHandler() {
    }

    public MessageLoggingHandler(Class<?> clazz, LogLevel level) {
        super(clazz, level);
    }

    public MessageLoggingHandler(Class<?> clazz) {
        super(clazz);
    }

    public MessageLoggingHandler(LogLevel level) {
        super(level);
    }

    public MessageLoggingHandler(String name, LogLevel level) {
        super(name, level);
    }

    public MessageLoggingHandler(String name) {
        super(name);
    }

    @Override
    public void write(ChannelHandlerContext ctx, MessageList<Object> msgs, ChannelPromise promise) throws Exception {
        this.log("WRITE", msgs);
        ctx.write(msgs);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        this.log("RECEIVED", msgs);
        ctx.fireMessageReceived(msgs);
    }

    private void log(String message, MessageList<Object> msgs) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.formatBuffer(message, msgs));
        }
    }

    protected String formatBuffer(String message, MessageList<Object> msgs) {
        return message + '(' + msgs.size() + "): " + MessageLoggingHandler.contentToString(msgs);
    }

    private static String contentToString(MessageList<Object> msgs) {
        if (msgs.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int size = msgs.size();
        for (int i = 0; i < size; ++i) {
            Object msg = msgs.get(i);
            sb.append(msg);
            if (i + 1 >= size) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }
}

