/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsHeader;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResource;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class DnsMessage
extends AbstractReferenceCounted {
    private List<DnsQuestion> questions;
    private List<DnsResource> answers;
    private List<DnsResource> authority;
    private List<DnsResource> additional;
    private final DnsHeader header;

    DnsMessage(int id) {
        this.header = this.newHeader(id);
    }

    public DnsHeader header() {
        return this.header;
    }

    public List<DnsQuestion> questions() {
        if (this.questions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.questions);
    }

    public List<DnsResource> answers() {
        if (this.answers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.answers);
    }

    public List<DnsResource> authorityResources() {
        if (this.authority == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.authority);
    }

    public List<DnsResource> additionalResources() {
        if (this.additional == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additional);
    }

    public DnsMessage addAnswer(DnsResource answer) {
        if (this.answers == null) {
            this.answers = new LinkedList<DnsResource>();
        }
        this.answers.add(answer);
        return this;
    }

    public DnsMessage addQuestion(DnsQuestion question) {
        if (this.questions == null) {
            this.questions = new LinkedList<DnsQuestion>();
        }
        this.questions.add(question);
        return this;
    }

    public DnsMessage addAuthorityResource(DnsResource resource) {
        if (this.authority == null) {
            this.authority = new LinkedList<DnsResource>();
        }
        this.authority.add(resource);
        return this;
    }

    public DnsMessage addAdditionalResource(DnsResource resource) {
        if (this.additional == null) {
            this.additional = new LinkedList<DnsResource>();
        }
        this.additional.add(resource);
        return this;
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean release() {
        DnsMessage.release(this.questions());
        DnsMessage.release(this.answers());
        DnsMessage.release(this.additionalResources());
        DnsMessage.release(this.authorityResources());
        return super.release();
    }

    private static void release(List<?> resources) {
        for (Object resource : resources) {
            ReferenceCountUtil.release(resource);
        }
    }

    @Override
    public boolean release(int decrement) {
        DnsMessage.release(this.questions(), decrement);
        DnsMessage.release(this.answers(), decrement);
        DnsMessage.release(this.additionalResources(), decrement);
        DnsMessage.release(this.authorityResources(), decrement);
        return super.release(decrement);
    }

    private static void release(List<?> resources, int decrement) {
        for (Object resource : resources) {
            ReferenceCountUtil.release(resource, decrement);
        }
    }

    @Override
    public DnsMessage touch(Object hint) {
        DnsMessage.touch(this.questions(), hint);
        DnsMessage.touch(this.answers(), hint);
        DnsMessage.touch(this.additionalResources(), hint);
        DnsMessage.touch(this.authorityResources(), hint);
        return this;
    }

    private static void touch(List<?> resources, Object hint) {
        for (Object resource : resources) {
            ReferenceCountUtil.touch(resource, hint);
        }
    }

    @Override
    public DnsMessage retain() {
        DnsMessage.retain(this.questions());
        DnsMessage.retain(this.answers());
        DnsMessage.retain(this.additionalResources());
        DnsMessage.retain(this.authorityResources());
        super.retain();
        return this;
    }

    private static void retain(List<?> resources) {
        for (Object resource : resources) {
            ReferenceCountUtil.retain(resource);
        }
    }

    @Override
    public DnsMessage retain(int increment) {
        DnsMessage.retain(this.questions(), increment);
        DnsMessage.retain(this.answers(), increment);
        DnsMessage.retain(this.additionalResources(), increment);
        DnsMessage.retain(this.authorityResources(), increment);
        super.retain(increment);
        return this;
    }

    private static void retain(List<?> resources, int increment) {
        for (Object resource : resources) {
            ReferenceCountUtil.retain(resource, increment);
        }
    }

    @Override
    public DnsMessage touch() {
        super.touch();
        return this;
    }

    protected abstract DnsHeader newHeader(int var1);
}

