/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsHeader;
import io.netty.handler.codec.dns.DnsMessage;
import io.netty.handler.codec.dns.DnsResponseCode;

public final class DnsResponseHeader
extends DnsHeader {
    private boolean authoritativeAnswer;
    private boolean truncated;
    private boolean recursionAvailable;
    private DnsResponseCode responseCode;

    public DnsResponseHeader(DnsMessage parent, int id) {
        super(parent);
        this.setId(id);
    }

    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public DnsResponseCode responseCode() {
        return this.responseCode;
    }

    @Override
    public int type() {
        return 1;
    }

    public DnsResponseHeader setAuthoritativeAnswer(boolean authoritativeAnswer) {
        this.authoritativeAnswer = authoritativeAnswer;
        return this;
    }

    public DnsResponseHeader setTruncated(boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public DnsResponseHeader setRecursionAvailable(boolean recursionAvailable) {
        this.recursionAvailable = recursionAvailable;
        return this;
    }

    public DnsResponseHeader setResponseCode(DnsResponseCode responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    @Override
    public DnsResponseHeader setType(int type) {
        if (type != 1) {
            throw new IllegalArgumentException("type cannot be anything but TYPE_RESPONSE (1) for a response header.");
        }
        super.setType(type);
        return this;
    }

    @Override
    public DnsResponseHeader setId(int id) {
        super.setId(id);
        return this;
    }

    @Override
    public DnsHeader setRecursionDesired(boolean recursionDesired) {
        return super.setRecursionDesired(recursionDesired);
    }

    @Override
    public DnsResponseHeader setOpcode(int opcode) {
        super.setOpcode(opcode);
        return this;
    }

    @Override
    public DnsResponseHeader setZ(int z) {
        super.setZ(z);
        return this;
    }
}

