/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.FastLz;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private final Checksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    public FastLzFrameDecoder() {
        this(false);
    }

    public FastLzFrameDecoder(boolean validateChecksums) {
        this(validateChecksums ? new Adler32() : null);
    }

    public FastLzFrameDecoder(Checksum checksum) {
        this.checksum = checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        block11: while (true) {
            try {
                block12: while (true) {
                    switch (this.currentState) {
                        case INIT_BLOCK: {
                            if (in.readableBytes() < 4) {
                                return;
                            }
                            int magic = in.readUnsignedMedium();
                            if (magic != 4607066) {
                                throw new DecompressionException("unexpected block identifier");
                            }
                            byte options = in.readByte();
                            this.isCompressed = (options & 1) == 1;
                            this.hasChecksum = (options & 0x10) == 16;
                            this.currentState = State.INIT_BLOCK_PARAMS;
                        }
                        case INIT_BLOCK_PARAMS: {
                            if (in.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) {
                                return;
                            }
                            this.currentChecksum = this.hasChecksum ? in.readInt() : 0;
                            this.chunkLength = in.readUnsignedShort();
                            this.originalLength = this.isCompressed ? in.readUnsignedShort() : this.chunkLength;
                            this.currentState = State.DECOMPRESS_DATA;
                        }
                        case DECOMPRESS_DATA: {
                            int chunkLength = this.chunkLength;
                            if (in.readableBytes() < chunkLength) {
                                return;
                            }
                            int idx = in.readerIndex();
                            int originalLength = this.originalLength;
                            ByteBuf uncompressed = ctx.alloc().heapBuffer(originalLength, originalLength);
                            byte[] output = uncompressed.array();
                            int outputPtr = uncompressed.arrayOffset() + uncompressed.writerIndex();
                            boolean success = false;
                            try {
                                if (this.isCompressed) {
                                    int inputPtr;
                                    byte[] input;
                                    if (in.hasArray()) {
                                        input = in.array();
                                        inputPtr = in.arrayOffset() + idx;
                                    } else {
                                        input = new byte[chunkLength];
                                        in.getBytes(idx, input);
                                        inputPtr = 0;
                                    }
                                    int decompressedBytes = FastLz.decompress(input, inputPtr, chunkLength, output, outputPtr, originalLength);
                                    if (originalLength != decompressedBytes) {
                                        throw new DecompressionException(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", originalLength, decompressedBytes));
                                    }
                                } else {
                                    in.getBytes(idx, output, outputPtr, chunkLength);
                                }
                                Checksum checksum = this.checksum;
                                if (this.hasChecksum && checksum != null) {
                                    checksum.reset();
                                    checksum.update(output, outputPtr, originalLength);
                                    int checksumResult = (int)checksum.getValue();
                                    if (checksumResult != this.currentChecksum) {
                                        throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", checksumResult, this.currentChecksum));
                                    }
                                }
                                uncompressed.writerIndex(uncompressed.writerIndex() + originalLength);
                                out.add(uncompressed);
                                in.skipBytes(chunkLength);
                                this.currentState = State.INIT_BLOCK;
                                success = true;
                                continue block12;
                            }
                            finally {
                                if (success) continue block11;
                                uncompressed.release();
                                continue block12;
                            }
                        }
                        case CORRUPTED: {
                            in.skipBytes(in.readableBytes());
                            return;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.currentState = State.CORRUPTED;
                throw e;
            }
            break;
        }
    }

    private static enum State {
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

