/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieEncoderUtil;
import io.netty.handler.codec.http.DefaultCookie;

public final class ClientCookieEncoder {
    public static String encode(String name, String value) {
        return ClientCookieEncoder.encode((Cookie)new DefaultCookie(name, value));
    }

    public static String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder buf = CookieEncoderUtil.stringBuilder();
        ClientCookieEncoder.encode(buf, cookie);
        return CookieEncoderUtil.stripTrailingSeparator(buf);
    }

    public static String encode(Cookie ... cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies.length == 0) {
            return null;
        }
        StringBuilder buf = CookieEncoderUtil.stringBuilder();
        for (Cookie c : cookies) {
            if (c == null) break;
            ClientCookieEncoder.encode(buf, c);
        }
        return CookieEncoderUtil.stripTrailingSeparatorOrNull(buf);
    }

    public static String encode(Iterable<Cookie> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        if (!cookies.iterator().hasNext()) {
            return null;
        }
        StringBuilder buf = CookieEncoderUtil.stringBuilder();
        for (Cookie c : cookies) {
            if (c == null) break;
            ClientCookieEncoder.encode(buf, c);
        }
        return CookieEncoderUtil.stripTrailingSeparatorOrNull(buf);
    }

    private static void encode(StringBuilder buf, Cookie c) {
        String value = c.rawValue() != null ? c.rawValue() : (c.value() != null ? c.value() : "");
        CookieEncoderUtil.addUnquoted(buf, c.name(), value);
    }

    private ClientCookieEncoder() {
    }
}

