/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class DefaultHeaders<T>
implements Headers<T> {
    private static final int HASH_CODE_PRIME = 31;
    private static final int DEFAULT_BUCKET_SIZE = 17;
    private static final int DEFAULT_MAP_SIZE = 4;
    private static final NameConverter<Object> DEFAULT_NAME_CONVERTER = new IdentityNameConverter<Object>();
    private final IntObjectMap<HeaderEntry> entries;
    private final IntObjectMap<HeaderEntry> tailEntries;
    private final HeaderEntry head;
    private final Comparator<? super T> keyComparator;
    private final Comparator<? super T> valueComparator;
    private final HashCodeGenerator<T> hashCodeGenerator;
    private final Headers.ValueConverter<T> valueConverter;
    private final NameConverter<T> nameConverter;
    private final int bucketSize;
    int size;

    public DefaultHeaders(Comparator<? super T> keyComparator, Comparator<? super T> valueComparator, HashCodeGenerator<T> hashCodeGenerator, Headers.ValueConverter<T> typeConverter) {
        this(keyComparator, valueComparator, hashCodeGenerator, typeConverter, DEFAULT_NAME_CONVERTER);
    }

    public DefaultHeaders(Comparator<? super T> keyComparator, Comparator<? super T> valueComparator, HashCodeGenerator<T> hashCodeGenerator, Headers.ValueConverter<T> typeConverter, NameConverter<T> nameConverter) {
        this(keyComparator, valueComparator, hashCodeGenerator, typeConverter, nameConverter, 17, 4);
    }

    public DefaultHeaders(Comparator<? super T> keyComparator, Comparator<? super T> valueComparator, HashCodeGenerator<T> hashCodeGenerator, Headers.ValueConverter<T> valueConverter, NameConverter<T> nameConverter, int bucketSize, int initialMapSize) {
        if (keyComparator == null) {
            throw new NullPointerException("keyComparator");
        }
        if (valueComparator == null) {
            throw new NullPointerException("valueComparator");
        }
        if (hashCodeGenerator == null) {
            throw new NullPointerException("hashCodeGenerator");
        }
        if (valueConverter == null) {
            throw new NullPointerException("valueConverter");
        }
        if (nameConverter == null) {
            throw new NullPointerException("nameConverter");
        }
        if (bucketSize < 1) {
            throw new IllegalArgumentException("bucketSize must be a positive integer");
        }
        this.head.before = this.head.after = (this.head = new HeaderEntry());
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
        this.hashCodeGenerator = hashCodeGenerator;
        this.valueConverter = valueConverter;
        this.nameConverter = nameConverter;
        this.bucketSize = bucketSize;
        this.entries = new IntObjectHashMap<HeaderEntry>(initialMapSize);
        this.tailEntries = new IntObjectHashMap<HeaderEntry>(initialMapSize);
    }

    @Override
    public T get(T name) {
        ObjectUtil.checkNotNull(name, "name");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.entries.get(i);
        while (e != null) {
            if (e.hash == h && this.keyComparator.compare(e.name, name) == 0) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public T get(T name, T defaultValue) {
        T value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public T getAndRemove(T name) {
        HeaderEntry next;
        ObjectUtil.checkNotNull(name, "name");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.entries.get(i);
        if (e == null) {
            return null;
        }
        T value = null;
        while (e.hash == h && this.keyComparator.compare(e.name, name) == 0) {
            if (value == null) {
                value = e.value;
            }
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries.put(i, next);
                e = next;
                continue;
            }
            this.entries.remove(i);
            this.tailEntries.remove(i);
            return value;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.keyComparator.compare(e.name, name) == 0) {
                if (value == null) {
                    value = next.value;
                }
                e.next = next.next;
                if (e.next == null) {
                    this.tailEntries.put(i, e);
                }
                next.remove();
                continue;
            }
            e = next;
        }
        return value;
    }

    @Override
    public T getAndRemove(T name, T defaultValue) {
        T value = this.getAndRemove(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public List<T> getAll(T name) {
        ObjectUtil.checkNotNull(name, "name");
        ArrayList values = new ArrayList(4);
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.entries.get(i);
        while (e != null) {
            if (e.hash == h && this.keyComparator.compare(e.name, name) == 0) {
                values.add(e.value);
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public List<T> getAllAndRemove(T name) {
        HeaderEntry next;
        ObjectUtil.checkNotNull(name, "name");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.entries.get(i);
        if (e == null) {
            return null;
        }
        ArrayList values = new ArrayList(4);
        while (e.hash == h && this.keyComparator.compare(e.name, name) == 0) {
            values.add(e.value);
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries.put(i, next);
                e = next;
                continue;
            }
            this.entries.remove(i);
            this.tailEntries.remove(i);
            return values;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.keyComparator.compare(next.name, name) == 0) {
                values.add(next.value);
                e.next = next.next;
                if (e.next == null) {
                    this.tailEntries.put(i, e);
                }
                next.remove();
                continue;
            }
            e = next;
        }
        return values;
    }

    @Override
    public List<Map.Entry<T, T>> entries() {
        int size = this.size();
        ArrayList<Map.Entry<T, T>> localEntries = new ArrayList<Map.Entry<T, T>>(size);
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            localEntries.add(e);
            e = e.after;
        }
        assert (size == localEntries.size());
        return localEntries;
    }

    @Override
    public boolean contains(T name) {
        return this.get(name) != null;
    }

    @Override
    public boolean contains(T name, T value) {
        return this.contains(name, value, this.keyComparator, this.valueComparator);
    }

    @Override
    public boolean containsObject(T name, Object value) {
        return this.contains(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsBoolean(T name, boolean value) {
        return this.contains(name, this.valueConverter.convertBoolean(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsByte(T name, byte value) {
        return this.contains(name, this.valueConverter.convertByte(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsChar(T name, char value) {
        return this.contains(name, this.valueConverter.convertChar(ObjectUtil.checkNotNull(Character.valueOf(value), "value").charValue()));
    }

    @Override
    public boolean containsShort(T name, short value) {
        return this.contains(name, this.valueConverter.convertShort(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsInt(T name, int value) {
        return this.contains(name, this.valueConverter.convertInt(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsLong(T name, long value) {
        return this.contains(name, this.valueConverter.convertLong(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsFloat(T name, float value) {
        return this.contains(name, this.valueConverter.convertFloat(ObjectUtil.checkNotNull(Float.valueOf(value), "value").floatValue()));
    }

    @Override
    public boolean containsDouble(T name, double value) {
        return this.contains(name, this.valueConverter.convertDouble(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean containsTimeMillis(T name, long value) {
        return this.contains(name, this.valueConverter.convertTimeMillis(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public boolean contains(T name, T value, Comparator<? super T> comparator) {
        return this.contains(name, value, comparator, comparator);
    }

    @Override
    public boolean contains(T name, T value, Comparator<? super T> keyComparator, Comparator<? super T> valueComparator) {
        ObjectUtil.checkNotNull(name, "name");
        ObjectUtil.checkNotNull(value, "value");
        ObjectUtil.checkNotNull(keyComparator, "keyComparator");
        ObjectUtil.checkNotNull(valueComparator, "valueComparator");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.entries.get(i);
        while (e != null) {
            if (e.hash == h && keyComparator.compare(e.name, name) == 0 && valueComparator.compare(e.value, value) == 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean containsObject(T name, Object value, Comparator<? super T> comparator) {
        return this.containsObject(name, value, comparator, comparator);
    }

    @Override
    public boolean containsObject(T name, Object value, Comparator<? super T> keyComparator, Comparator<? super T> valueComparator) {
        return this.contains(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value, "value")), keyComparator, valueComparator);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<T> names() {
        TreeSet<T> names = new TreeSet<T>(this.keyComparator);
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.name);
            e = e.after;
        }
        return names;
    }

    @Override
    public List<T> namesList() {
        ArrayList names = new ArrayList(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.name);
            e = e.after;
        }
        return names;
    }

    @Override
    public Headers<T> add(T name, T value) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(value, "value");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public Headers<T> add(T name, Iterable<? extends T> values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> add(T name, T ... values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> addObject(T name, Object value) {
        return this.add(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public Headers<T> addObject(T name, Iterable<?> values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        for (Object o : values) {
            if (o == null) break;
            T converted = this.valueConverter.convertObject(o);
            ObjectUtil.checkNotNull(converted, "converted");
            this.add0(h, i, name, converted);
        }
        return this;
    }

    @Override
    public Headers<T> addObject(T name, Object ... values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        for (Object o : values) {
            if (o == null) break;
            T converted = this.valueConverter.convertObject(o);
            ObjectUtil.checkNotNull(converted, "converted");
            this.add0(h, i, name, converted);
        }
        return this;
    }

    @Override
    public Headers<T> addInt(T name, int value) {
        return this.add(name, this.valueConverter.convertInt(value));
    }

    @Override
    public Headers<T> addLong(T name, long value) {
        return this.add(name, this.valueConverter.convertLong(value));
    }

    @Override
    public Headers<T> addDouble(T name, double value) {
        return this.add(name, this.valueConverter.convertDouble(value));
    }

    @Override
    public Headers<T> addTimeMillis(T name, long value) {
        return this.add(name, this.valueConverter.convertTimeMillis(value));
    }

    @Override
    public Headers<T> addChar(T name, char value) {
        return this.add(name, this.valueConverter.convertChar(value));
    }

    @Override
    public Headers<T> addBoolean(T name, boolean value) {
        return this.add(name, this.valueConverter.convertBoolean(value));
    }

    @Override
    public Headers<T> addFloat(T name, float value) {
        return this.add(name, this.valueConverter.convertFloat(value));
    }

    @Override
    public Headers<T> addByte(T name, byte value) {
        return this.add(name, this.valueConverter.convertByte(value));
    }

    @Override
    public Headers<T> addShort(T name, short value) {
        return this.add(name, this.valueConverter.convertShort(value));
    }

    @Override
    public Headers<T> add(Headers<T> headers) {
        ObjectUtil.checkNotNull(headers, "headers");
        this.add0(headers);
        return this;
    }

    @Override
    public Headers<T> set(T name, T value) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(value, "value");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public Headers<T> set(T name, Iterable<? extends T> values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> set(T name, T ... values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> setObject(T name, Object value) {
        return this.set(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value, "value")));
    }

    @Override
    public Headers<T> setObject(T name, Iterable<?> values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (Object o : values) {
            if (o == null) break;
            T converted = this.valueConverter.convertObject(o);
            ObjectUtil.checkNotNull(converted, "converted");
            this.add0(h, i, name, converted);
        }
        return this;
    }

    @Override
    public Headers<T> setObject(T name, Object ... values) {
        name = this.convertName(name);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (Object o : values) {
            if (o == null) break;
            T converted = this.valueConverter.convertObject(o);
            ObjectUtil.checkNotNull(converted, "converted");
            this.add0(h, i, name, converted);
        }
        return this;
    }

    @Override
    public Headers<T> setInt(T name, int value) {
        return this.set(name, this.valueConverter.convertInt(value));
    }

    @Override
    public Headers<T> setLong(T name, long value) {
        return this.set(name, this.valueConverter.convertLong(value));
    }

    @Override
    public Headers<T> setDouble(T name, double value) {
        return this.set(name, this.valueConverter.convertDouble(value));
    }

    @Override
    public Headers<T> setTimeMillis(T name, long value) {
        return this.set(name, this.valueConverter.convertTimeMillis(value));
    }

    @Override
    public Headers<T> setFloat(T name, float value) {
        return this.set(name, this.valueConverter.convertFloat(value));
    }

    @Override
    public Headers<T> setChar(T name, char value) {
        return this.set(name, this.valueConverter.convertChar(value));
    }

    @Override
    public Headers<T> setBoolean(T name, boolean value) {
        return this.set(name, this.valueConverter.convertBoolean(value));
    }

    @Override
    public Headers<T> setByte(T name, byte value) {
        return this.set(name, this.valueConverter.convertByte(value));
    }

    @Override
    public Headers<T> setShort(T name, short value) {
        return this.set(name, this.valueConverter.convertShort(value));
    }

    @Override
    public Headers<T> set(Headers<T> headers) {
        ObjectUtil.checkNotNull(headers, "headers");
        this.clear();
        this.add0(headers);
        return this;
    }

    @Override
    public Headers<T> setAll(Headers<T> headers) {
        ObjectUtil.checkNotNull(headers, "headers");
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders m = (DefaultHeaders)headers;
            HeaderEntry e = m.head.after;
            while (e != m.head) {
                this.set((T)e.name, (T)e.value);
                e = e.after;
            }
        } else {
            try {
                headers.forEachEntry(this.setAllVisitor());
            }
            catch (Exception ex) {
                PlatformDependent.throwException(ex);
            }
        }
        return this;
    }

    @Override
    public boolean remove(T name) {
        ObjectUtil.checkNotNull(name, "name");
        int h = this.hashCodeGenerator.generateHashCode(name);
        int i = this.index(h);
        return this.remove0(h, i, name);
    }

    @Override
    public Headers<T> clear() {
        this.entries.clear();
        this.tailEntries.clear();
        this.head.before = this.head.after = this.head;
        this.size = 0;
        return this;
    }

    @Override
    public Iterator<Map.Entry<T, T>> iterator() {
        return new KeyValueHeaderIterator();
    }

    @Override
    public Map.Entry<T, T> forEachEntry(Headers.EntryVisitor<T> visitor) throws Exception {
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            if (!visitor.visit(e)) {
                return e;
            }
            e = e.after;
        }
        return null;
    }

    @Override
    public T forEachName(Headers.NameVisitor<T> visitor) throws Exception {
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            if (!visitor.visit(e.name)) {
                return e.name;
            }
            e = e.after;
        }
        return null;
    }

    @Override
    public Boolean getBoolean(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToBoolean(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(T name, boolean defaultValue) {
        Boolean v = this.getBoolean(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Byte getByte(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToByte(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public byte getByte(T name, byte defaultValue) {
        Byte v = this.getByte(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Character getChar(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return Character.valueOf(this.valueConverter.convertToChar(v));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public char getChar(T name, char defaultValue) {
        Character v = this.getChar(name);
        return v == null ? defaultValue : v.charValue();
    }

    @Override
    public Short getShort(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToShort(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public short getInt(T name, short defaultValue) {
        Short v = this.getShort(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Integer getInt(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToInt(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public int getInt(T name, int defaultValue) {
        Integer v = this.getInt(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Long getLong(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToLong(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public long getLong(T name, long defaultValue) {
        Long v = this.getLong(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Float getFloat(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return Float.valueOf(this.valueConverter.convertToFloat(v));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public float getFloat(T name, float defaultValue) {
        Float v = this.getFloat(name);
        return v == null ? defaultValue : v.floatValue();
    }

    @Override
    public Double getDouble(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToDouble(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public double getDouble(T name, double defaultValue) {
        Double v = this.getDouble(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Long getTimeMillis(T name) {
        T v = this.get(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToTimeMillis(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(T name, long defaultValue) {
        Long v = this.getTimeMillis(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Boolean getBooleanAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToBoolean(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public boolean getBooleanAndRemove(T name, boolean defaultValue) {
        Boolean v = this.getBooleanAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Byte getByteAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToByte(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public byte getByteAndRemove(T name, byte defaultValue) {
        Byte v = this.getByteAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Character getCharAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return Character.valueOf(this.valueConverter.convertToChar(v));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(T name, char defaultValue) {
        Character v = this.getCharAndRemove(name);
        return v == null ? defaultValue : v.charValue();
    }

    @Override
    public Short getShortAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToShort(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public short getShortAndRemove(T name, short defaultValue) {
        Short v = this.getShortAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Integer getIntAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToInt(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(T name, int defaultValue) {
        Integer v = this.getIntAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Long getLongAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToLong(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(T name, long defaultValue) {
        Long v = this.getLongAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Float getFloatAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return Float.valueOf(this.valueConverter.convertToFloat(v));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public float getFloatAndRemove(T name, float defaultValue) {
        Float v = this.getFloatAndRemove(name);
        return v == null ? defaultValue : v.floatValue();
    }

    @Override
    public Double getDoubleAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToDouble(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public double getDoubleAndRemove(T name, double defaultValue) {
        Double v = this.getDoubleAndRemove(name);
        return v == null ? defaultValue : v;
    }

    @Override
    public Long getTimeMillisAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return this.valueConverter.convertToTimeMillis(v);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(T name, long defaultValue) {
        Long v = this.getTimeMillisAndRemove(name);
        return v == null ? defaultValue : v;
    }

    public boolean equals(Object o) {
        List<T> otherNamesList;
        if (!(o instanceof DefaultHeaders)) {
            return false;
        }
        DefaultHeaders h2 = (DefaultHeaders)o;
        List<T> namesList = this.namesList();
        if (!DefaultHeaders.equals(namesList, otherNamesList = h2.namesList(), this.keyComparator)) {
            return false;
        }
        TreeSet<T> names = new TreeSet<T>(this.keyComparator);
        names.addAll(namesList);
        for (Object name : names) {
            if (DefaultHeaders.equals(this.getAll(name), h2.getAll(name), this.valueComparator)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean equals(List<T> lhs, List<T> rhs, Comparator<? super T> comparator) {
        int lhsSize = lhs.size();
        if (lhsSize != rhs.size()) {
            return false;
        }
        Collections.sort(lhs, comparator);
        Collections.sort(rhs, comparator);
        for (int i = 0; i < lhsSize; ++i) {
            if (comparator.compare(lhs.get(i), rhs.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (T name : this.names()) {
            result = 31 * result + name.hashCode();
            List<T> values = this.getAll(name);
            Collections.sort(values, this.valueComparator);
            for (int i = 0; i < values.size(); ++i) {
                result = 31 * result + this.hashCodeGenerator.generateHashCode(values.get(i));
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        for (T name : this.names()) {
            List<T> values = this.getAll(name);
            Collections.sort(values, this.valueComparator);
            for (int i = 0; i < values.size(); ++i) {
                builder.append(name).append(": ").append(values.get(i)).append(", ");
            }
        }
        if (builder.length() > 2) {
            builder.setLength(builder.length() - 2);
        }
        return builder.append(']').toString();
    }

    protected Headers.ValueConverter<T> valueConverter() {
        return this.valueConverter;
    }

    private T convertName(T name) {
        return this.nameConverter.convertName(ObjectUtil.checkNotNull(name, "name"));
    }

    private int index(int hash) {
        return Math.abs(hash % this.bucketSize);
    }

    private void add0(Headers<T> headers) {
        if (headers.isEmpty()) {
            return;
        }
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders m = (DefaultHeaders)headers;
            HeaderEntry e = m.head.after;
            while (e != m.head) {
                this.add((T)e.name, (T)e.value);
                e = e.after;
            }
        } else {
            try {
                headers.forEachEntry(this.addAllVisitor());
            }
            catch (Exception ex) {
                PlatformDependent.throwException(ex);
            }
        }
    }

    private void add0(int h, int i, T name, T value) {
        HeaderEntry newEntry = new HeaderEntry(h, name, value);
        HeaderEntry oldTail = this.tailEntries.get(i);
        if (oldTail == null) {
            this.entries.put(i, newEntry);
        } else {
            oldTail.next = newEntry;
        }
        this.tailEntries.put(i, newEntry);
        newEntry.addBefore(this.head);
    }

    private boolean remove0(int h, int i, T name) {
        HeaderEntry next;
        HeaderEntry e = this.entries.get(i);
        if (e == null) {
            return false;
        }
        boolean removed = false;
        while (e.hash == h && this.keyComparator.compare(e.name, name) == 0) {
            e.remove();
            next = e.next;
            if (next == null) {
                this.entries.remove(i);
                this.tailEntries.remove(i);
                return true;
            }
            this.entries.put(i, next);
            e = next;
            removed = true;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.keyComparator.compare(next.name, name) == 0) {
                e.next = next.next;
                if (e.next == null) {
                    this.tailEntries.put(i, e);
                }
                next.remove();
                removed = true;
                continue;
            }
            e = next;
        }
        return removed;
    }

    private Headers.EntryVisitor<T> setAllVisitor() {
        return new Headers.EntryVisitor<T>(){

            @Override
            public boolean visit(Map.Entry<T, T> entry) {
                DefaultHeaders.this.set(entry.getKey(), entry.getValue());
                return true;
            }
        };
    }

    private Headers.EntryVisitor<T> addAllVisitor() {
        return new Headers.EntryVisitor<T>(){

            @Override
            public boolean visit(Map.Entry<T, T> entry) {
                DefaultHeaders.this.add(entry.getKey(), entry.getValue());
                return true;
            }
        };
    }

    static final class HeaderDateFormat {
        private static final ParsePosition parsePos = new ParsePosition(0);
        private static final FastThreadLocal<HeaderDateFormat> dateFormatThreadLocal = new FastThreadLocal<HeaderDateFormat>(){

            @Override
            protected HeaderDateFormat initialValue() {
                return new HeaderDateFormat();
            }
        };
        private final DateFormat dateFormat1 = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat2 = new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat3 = new SimpleDateFormat("E MMM d HH:mm:ss yyyy", Locale.ENGLISH);

        static HeaderDateFormat get() {
            return dateFormatThreadLocal.get();
        }

        private HeaderDateFormat() {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            this.dateFormat1.setTimeZone(tz);
            this.dateFormat2.setTimeZone(tz);
            this.dateFormat3.setTimeZone(tz);
        }

        long parse(String text) throws ParseException {
            Date date = this.dateFormat1.parse(text, parsePos);
            if (date == null) {
                date = this.dateFormat2.parse(text, parsePos);
            }
            if (date == null) {
                date = this.dateFormat3.parse(text, parsePos);
            }
            if (date == null) {
                throw new ParseException(text, 0);
            }
            return date.getTime();
        }

        long parse(String text, long defaultValue) {
            Date date = this.dateFormat1.parse(text, parsePos);
            if (date == null) {
                date = this.dateFormat2.parse(text, parsePos);
            }
            if (date == null) {
                date = this.dateFormat3.parse(text, parsePos);
            }
            if (date == null) {
                return defaultValue;
            }
            return date.getTime();
        }
    }

    protected final class KeyValueHeaderIterator
    implements Iterator<Map.Entry<T, T>> {
        private HeaderEntry current;

        protected KeyValueHeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<T, T> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class HeaderEntry
    implements Map.Entry<T, T> {
        final int hash;
        final T name;
        T value;
        HeaderEntry next;
        HeaderEntry before;
        HeaderEntry after;

        HeaderEntry(int hash, T name, T value) {
            this.hash = hash;
            this.name = name;
            this.value = value;
        }

        HeaderEntry() {
            this.hash = -1;
            this.name = null;
            this.value = null;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            --DefaultHeaders.this.size;
        }

        void addBefore(HeaderEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
            ++DefaultHeaders.this.size;
        }

        @Override
        public T getKey() {
            return this.name;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            ObjectUtil.checkNotNull(value, "value");
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return "" + this.name + '=' + this.value;
        }
    }

    public static final class IdentityNameConverter<T>
    implements NameConverter<T> {
        @Override
        public T convertName(T name) {
            return name;
        }
    }

    public static final class JavaHashCodeGenerator<T>
    implements HashCodeGenerator<T> {
        @Override
        public int generateHashCode(T name) {
            return name.hashCode();
        }
    }

    public static interface NameConverter<T> {
        public T convertName(T var1);
    }

    public static interface HashCodeGenerator<T> {
        public int generateHashCode(T var1);
    }
}

