/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseAggregator;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.ByteString;

public class CompressorHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int DEFAULT_WINDOW_BITS = 15;
    public static final int DEFAULT_MEM_LEVEL = 8;
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private final Http2Connection.PropertyKey propertyKey;

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate) {
        this(delegate, 6, 15, 8);
    }

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate, int compressionLevel, int windowBits, int memLevel) {
        super(delegate);
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (windowBits < 9 || windowBits > 15) {
            throw new IllegalArgumentException("windowBits: " + windowBits + " (expected: 9-15)");
        }
        if (memLevel < 1 || memLevel > 9) {
            throw new IllegalArgumentException("memLevel: " + memLevel + " (expected: 1-9)");
        }
        this.compressionLevel = compressionLevel;
        this.windowBits = windowBits;
        this.memLevel = memLevel;
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream stream) {
                EmbeddedChannel compressor = (EmbeddedChannel)stream.getProperty(CompressorHttp2ConnectionEncoder.this.propertyKey);
                if (compressor != null) {
                    CompressorHttp2ConnectionEncoder.this.cleanup(stream, compressor);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        EmbeddedChannel channel;
        Http2Stream stream = this.connection().stream(streamId);
        EmbeddedChannel embeddedChannel = channel = stream == null ? null : (EmbeddedChannel)stream.getProperty(this.propertyKey);
        if (channel == null) {
            return super.writeData(ctx, streamId, data, padding, endOfStream, promise);
        }
        try {
            channel.writeOutbound(data);
            ByteBuf buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
            if (buf == null) {
                if (endOfStream) {
                    if (channel.finish()) {
                        buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    }
                    ChannelFuture channelFuture = super.writeData(ctx, streamId, buf == null ? Unpooled.EMPTY_BUFFER : buf, padding, true, promise);
                    return channelFuture;
                }
                promise.setSuccess();
                ChannelPromise channelPromise = promise;
                return channelPromise;
            }
            ChannelPromiseAggregator aggregator = new ChannelPromiseAggregator(promise);
            ChannelPromise bufPromise = ctx.newPromise();
            aggregator.add(bufPromise);
            while (true) {
                ChannelPromise nextPromise;
                ByteBuf nextBuf;
                boolean compressedEndOfStream;
                boolean bl = compressedEndOfStream = (nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel)) == null && endOfStream;
                if (compressedEndOfStream && channel.finish()) {
                    nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    boolean bl2 = compressedEndOfStream = nextBuf == null;
                }
                if (nextBuf != null) {
                    nextPromise = ctx.newPromise();
                    aggregator.add(nextPromise);
                } else {
                    nextPromise = null;
                }
                super.writeData(ctx, streamId, buf, padding, compressedEndOfStream, bufPromise);
                if (nextBuf == null) break;
                padding = 0;
                buf = nextBuf;
                bufPromise = nextPromise;
            }
            ChannelPromise channelPromise = promise;
            return channelPromise;
        }
        finally {
            if (endOfStream) {
                this.cleanup(stream, channel);
            }
        }
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        this.initCompressor(streamId, headers, endStream);
        return super.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        this.initCompressor(streamId, headers, endOfStream);
        return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
    }

    protected EmbeddedChannel newContentCompressor(ByteString contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.equals(contentEncoding) || HttpHeaderValues.X_GZIP.equals(contentEncoding)) {
            return this.newCompressionChannel(ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.equals(contentEncoding) || HttpHeaderValues.X_DEFLATE.equals(contentEncoding)) {
            return this.newCompressionChannel(ZlibWrapper.ZLIB);
        }
        return null;
    }

    protected ByteString getTargetContentEncoding(ByteString contentEncoding) throws Http2Exception {
        return contentEncoding;
    }

    private EmbeddedChannel newCompressionChannel(ZlibWrapper wrapper) {
        return new EmbeddedChannel(ZlibCodecFactory.newZlibEncoder(wrapper, this.compressionLevel, this.windowBits, this.memLevel));
    }

    private void initCompressor(int streamId, Http2Headers headers, boolean endOfStream) {
        EmbeddedChannel compressor;
        block10: {
            Http2Stream stream = this.connection().stream(streamId);
            if (stream == null) {
                return;
            }
            compressor = (EmbeddedChannel)stream.getProperty(this.propertyKey);
            if (compressor == null) {
                if (!endOfStream) {
                    ByteString encoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
                    if (encoding == null) {
                        encoding = HttpHeaderValues.IDENTITY;
                    }
                    try {
                        compressor = this.newContentCompressor(encoding);
                        if (compressor == null) break block10;
                        stream.setProperty(this.propertyKey, compressor);
                        ByteString targetContentEncoding = this.getTargetContentEncoding(encoding);
                        if (HttpHeaderValues.IDENTITY.equals(targetContentEncoding)) {
                            headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                            break block10;
                        }
                        headers.set((ByteString)HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
                    }
                    catch (Throwable ignored) {}
                }
            } else if (endOfStream) {
                this.cleanup(stream, compressor);
            }
        }
        if (compressor != null) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    void cleanup(Http2Stream stream, EmbeddedChannel compressor) {
        if (compressor.finish()) {
            ByteBuf buf;
            while ((buf = (ByteBuf)compressor.readOutbound()) != null) {
                buf.release();
            }
        }
        stream.removeProperty(this.propertyKey);
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel compressor) {
        ByteBuf buf;
        while (true) {
            if ((buf = (ByteBuf)compressor.readOutbound()) == null) {
                return null;
            }
            if (buf.isReadable()) break;
            buf.release();
        }
        return buf;
    }
}

