/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import com.twitter.hpack.Encoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.BinaryHeaders;
import io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.ByteString;
import io.netty.util.internal.ObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder.Configuration {
    private final Encoder encoder;
    private final ByteArrayOutputStream tableSizeChangeOutput = new ByteArrayOutputStream();
    private final Http2HeadersEncoder.SensitivityDetector sensitivityDetector;
    private final Http2HeaderTable headerTable;

    public DefaultHttp2HeadersEncoder() {
        this(4096, NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(int maxHeaderTableSize, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(sensitivityDetector, "sensitiveDetector");
        this.encoder = new Encoder(maxHeaderTableSize);
        this.headerTable = new Http2HeaderTableEncoder();
    }

    @Override
    public void encodeHeaders(Http2Headers headers, ByteBuf buffer) throws Http2Exception {
        final ByteBufOutputStream stream = new ByteBufOutputStream(buffer);
        try {
            if (headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", headers.size(), this.headerTable.maxHeaderListSize());
            }
            if (this.tableSizeChangeOutput.size() > 0) {
                buffer.writeBytes(this.tableSizeChangeOutput.toByteArray());
                this.tableSizeChangeOutput.reset();
            }
            for (Http2Headers.PseudoHeaderName pseudoHeader : Http2Headers.PseudoHeaderName.values()) {
                ByteString name = pseudoHeader.value();
                ByteString value = headers.get(name);
                if (value == null) continue;
                this.encodeHeader(name, value, stream);
            }
            headers.forEachEntry(new BinaryHeaders.EntryVisitor(){

                @Override
                public boolean visit(Map.Entry<ByteString, ByteString> entry) throws Exception {
                    ByteString name = entry.getKey();
                    ByteString value = entry.getValue();
                    if (!Http2Headers.PseudoHeaderName.isPseudoHeader(name)) {
                        DefaultHttp2HeadersEncoder.this.encodeHeader(name, value, stream);
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, t, "Failed encoding headers block: %s", t.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, e, e.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersEncoder.Configuration configuration() {
        return this;
    }

    private void encodeHeader(ByteString key, ByteString value, OutputStream stream) throws IOException {
        this.encoder.encodeHeader(stream, key.isEntireArrayUsed() ? key.array() : new ByteString(key, true).array(), value.isEntireArrayUsed() ? value.array() : new ByteString(value, true).array(), this.sensitivityDetector.isSensitive(key, value));
    }

    private final class Http2HeaderTableEncoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableEncoder() {
        }

        @Override
        public void maxHeaderTableSize(int max) throws Http2Exception {
            if (max < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", max);
            }
            try {
                DefaultHttp2HeadersEncoder.this.encoder.setMaxHeaderTableSize((OutputStream)DefaultHttp2HeadersEncoder.this.tableSizeChangeOutput, max);
            }
            catch (IOException e) {
                throw new Http2Exception(Http2Error.COMPRESSION_ERROR, e.getMessage(), e);
            }
            catch (Throwable t) {
                throw new Http2Exception(Http2Error.PROTOCOL_ERROR, t.getMessage(), t);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersEncoder.this.encoder.getMaxHeaderTableSize();
        }
    }
}

