/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SucceededChannelFuture;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.WeakHashMap;

final class DefaultChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext {
    static final int MASK_HANDLER_ADDED = 1;
    static final int MASK_HANDLER_REMOVED = 2;
    private static final int MASK_EXCEPTION_CAUGHT = 4;
    private static final int MASK_CHANNEL_REGISTERED = 8;
    private static final int MASK_CHANNEL_ACTIVE = 16;
    private static final int MASK_CHANNEL_INACTIVE = 32;
    private static final int MASK_CHANNEL_READ = 64;
    private static final int MASK_CHANNEL_READ_COMPLETE = 128;
    private static final int MASK_CHANNEL_WRITABILITY_CHANGED = 256;
    private static final int MASK_USER_EVENT_TRIGGERED = 512;
    private static final int MASK_BIND = 1024;
    private static final int MASK_CONNECT = 2048;
    private static final int MASK_DISCONNECT = 4096;
    private static final int MASK_CLOSE = 8192;
    private static final int MASK_READ = 16384;
    private static final int MASK_WRITE = 32768;
    private static final int MASK_FLUSH = 65536;
    private static final WeakHashMap<Class<?>, Integer>[] skipFlagsCache = new WeakHashMap[Runtime.getRuntime().availableProcessors()];
    volatile DefaultChannelHandlerContext next;
    volatile DefaultChannelHandlerContext prev;
    private final AbstractChannel channel;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final ChannelHandler handler;
    private boolean removed;
    final int skipFlags;
    final ChannelHandlerInvoker invoker;
    private ChannelFuture succeededFuture;
    Runnable invokeChannelReadCompleteTask;
    Runnable invokeReadTask;
    Runnable invokeFlushTask;
    Runnable invokeChannelWritableStateChangedTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int skipFlags(ChannelHandler handler) {
        int flagsVal;
        WeakHashMap<Class<?>, Integer> cache = skipFlagsCache[(int)(Thread.currentThread().getId() % (long)skipFlagsCache.length)];
        Class<?> handlerType = handler.getClass();
        WeakHashMap<Class<?>, Integer> weakHashMap = cache;
        synchronized (weakHashMap) {
            Integer flags = cache.get(handlerType);
            if (flags != null) {
                flagsVal = flags;
            } else {
                flagsVal = DefaultChannelHandlerContext.skipFlags0(handlerType);
                cache.put(handlerType, flagsVal);
            }
        }
        return flagsVal;
    }

    private static int skipFlags0(Class<? extends ChannelHandler> handlerType) {
        int flags = 0;
        try {
            if (handlerType.getMethod("handlerAdded", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 1;
            }
            if (handlerType.getMethod("handlerRemoved", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 2;
            }
            if (handlerType.getMethod("exceptionCaught", ChannelHandlerContext.class, Throwable.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 4;
            }
            if (handlerType.getMethod("channelRegistered", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 8;
            }
            if (handlerType.getMethod("channelActive", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x10;
            }
            if (handlerType.getMethod("channelInactive", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x20;
            }
            if (handlerType.getMethod("channelRead", ChannelHandlerContext.class, Object.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x40;
            }
            if (handlerType.getMethod("channelReadComplete", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x80;
            }
            if (handlerType.getMethod("channelWritabilityChanged", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x100;
            }
            if (handlerType.getMethod("userEventTriggered", ChannelHandlerContext.class, Object.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x200;
            }
            if (handlerType.getMethod("bind", ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x400;
            }
            if (handlerType.getMethod("connect", ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x800;
            }
            if (handlerType.getMethod("disconnect", ChannelHandlerContext.class, ChannelPromise.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x1000;
            }
            if (handlerType.getMethod("close", ChannelHandlerContext.class, ChannelPromise.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x2000;
            }
            if (handlerType.getMethod("read", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x4000;
            }
            if (handlerType.getMethod("write", ChannelHandlerContext.class, Object.class, ChannelPromise.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                flags |= 0x8000;
                if (handlerType.getMethod("flush", ChannelHandlerContext.class).isAnnotationPresent(ChannelHandler.Skip.class)) {
                    flags |= 0x10000;
                }
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
        }
        return flags;
    }

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, ChannelHandlerInvoker invoker, String name, ChannelHandler handler) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.skipFlags = DefaultChannelHandlerContext.skipFlags(handler);
        this.invoker = invoker == null ? this.channel.unsafe().invoker() : invoker;
    }

    void teardown() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.teardown0();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.teardown0();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardown0() {
        DefaultChannelHandlerContext prev = this.prev;
        if (prev != null) {
            DefaultChannelPipeline defaultChannelPipeline = this.pipeline;
            synchronized (defaultChannelPipeline) {
                this.pipeline.remove0(this);
            }
            prev.teardown();
        }
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        return this.invoker.executor();
    }

    @Override
    public ChannelHandlerInvoker invoker() {
        return this.invoker;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        DefaultChannelHandlerContext next = this.findContextInbound(8);
        next.invoker.invokeChannelRegistered(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        DefaultChannelHandlerContext next = this.findContextInbound(16);
        next.invoker.invokeChannelActive(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        DefaultChannelHandlerContext next = this.findContextInbound(32);
        next.invoker.invokeChannelInactive(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        DefaultChannelHandlerContext next = this.findContextInbound(4);
        next.invoker.invokeExceptionCaught(next, cause);
        return this;
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        DefaultChannelHandlerContext next = this.findContextInbound(512);
        next.invoker.invokeUserEventTriggered(next, event);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        DefaultChannelHandlerContext next = this.findContextInbound(64);
        next.invoker.invokeChannelRead(next, msg);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        DefaultChannelHandlerContext next = this.findContextInbound(128);
        next.invoker.invokeChannelReadComplete(next);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        DefaultChannelHandlerContext next = this.findContextInbound(256);
        next.invoker.invokeChannelWritabilityChanged(next);
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        DefaultChannelHandlerContext next = this.findContextOutbound(1024);
        next.invoker.invokeBind(next, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        DefaultChannelHandlerContext next = this.findContextOutbound(2048);
        next.invoker.invokeConnect(next, remoteAddress, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        DefaultChannelHandlerContext next = this.findContextOutbound(4096);
        next.invoker.invokeDisconnect(next, promise);
        return promise;
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        DefaultChannelHandlerContext next = this.findContextOutbound(8192);
        next.invoker.invokeClose(next, promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext read() {
        DefaultChannelHandlerContext next = this.findContextOutbound(16384);
        next.invoker.invokeRead(next);
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        DefaultChannelHandlerContext next = this.findContextOutbound(32768);
        next.invoker.invokeWrite(next, msg, promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext flush() {
        DefaultChannelHandlerContext next = this.findContextOutbound(65536);
        next.invoker.invokeFlush(next);
        return this;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        DefaultChannelHandlerContext next = this.findContextOutbound(32768);
        next.invoker.invokeWrite(next, msg, promise);
        next = this.findContextOutbound(65536);
        next.invoker.invokeFlush(next);
        return promise;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private DefaultChannelHandlerContext findContextInbound(int mask) {
        DefaultChannelHandlerContext ctx = this;
        do {
            ctx = ctx.next;
        } while ((ctx.skipFlags & mask) != 0);
        return ctx;
    }

    private DefaultChannelHandlerContext findContextOutbound(int mask) {
        DefaultChannelHandlerContext ctx = this;
        do {
            ctx = ctx.prev;
        } while ((ctx.skipFlags & mask) != 0);
        return ctx;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel.voidPromise();
    }

    void setRemoved() {
        this.removed = true;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    static {
        for (int i = 0; i < skipFlagsCache.length; ++i) {
            DefaultChannelHandlerContext.skipFlagsCache[i] = new WeakHashMap();
        }
    }
}

