/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DirectByteBufFactory
extends AbstractByteBufFactory {
    private static final DirectByteBufFactory INSTANCE_BE = new DirectByteBufFactory(ByteOrder.BIG_ENDIAN);
    private static final DirectByteBufFactory INSTANCE_LE = new DirectByteBufFactory(ByteOrder.LITTLE_ENDIAN);
    private final Object bigEndianLock = new Object();
    private final Object littleEndianLock = new Object();
    private final int preallocatedBufCapacity;
    private ByteBuf preallocatedBEBuf;
    private int preallocatedBEBufPos;
    private ByteBuf preallocatedLEBuf;
    private int preallocatedLEBufPos;

    public static ByteBufFactory getInstance() {
        return INSTANCE_BE;
    }

    public static ByteBufFactory getInstance(ByteOrder defaultEndianness) {
        if (defaultEndianness == ByteOrder.BIG_ENDIAN) {
            return INSTANCE_BE;
        }
        if (defaultEndianness == ByteOrder.LITTLE_ENDIAN) {
            return INSTANCE_LE;
        }
        if (defaultEndianness == null) {
            throw new NullPointerException("defaultEndianness");
        }
        throw new IllegalStateException("Should not reach here");
    }

    public DirectByteBufFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    public DirectByteBufFactory(int preallocatedBufferCapacity) {
        this(ByteOrder.BIG_ENDIAN, preallocatedBufferCapacity);
    }

    public DirectByteBufFactory(ByteOrder defaultOrder) {
        this(defaultOrder, 0x100000);
    }

    public DirectByteBufFactory(ByteOrder defaultOrder, int preallocatedBufferCapacity) {
        super(defaultOrder);
        if (preallocatedBufferCapacity <= 0) {
            throw new IllegalArgumentException("preallocatedBufCapacity must be greater than 0: " + preallocatedBufferCapacity);
        }
        this.preallocatedBufCapacity = preallocatedBufferCapacity;
    }

    @Override
    public ByteBuf getBuffer(ByteOrder order, int capacity) {
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        if (capacity == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (capacity >= this.preallocatedBufCapacity) {
            return Unpooled.directBuffer(capacity).order(order);
        }
        ByteBuf slice = order == ByteOrder.BIG_ENDIAN ? this.allocateBigEndianBuffer(capacity) : this.allocateLittleEndianBuffer(capacity);
        slice.clear();
        return slice;
    }

    @Override
    public ByteBuf getBuffer(ByteOrder order, byte[] array, int offset, int length) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (offset + length > array.length) {
            throw new IndexOutOfBoundsException("length: " + length);
        }
        ByteBuf buf = this.getBuffer(order, length);
        buf.writeBytes(array, offset, length);
        return buf;
    }

    @Override
    public ByteBuf getBuffer(ByteBuffer nioBuffer) {
        if (!nioBuffer.isReadOnly() && nioBuffer.isDirect()) {
            return Unpooled.wrappedBuffer(nioBuffer);
        }
        ByteBuf buf = this.getBuffer(nioBuffer.order(), nioBuffer.remaining());
        int pos = nioBuffer.position();
        buf.writeBytes(nioBuffer);
        nioBuffer.position(pos);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf allocateBigEndianBuffer(int capacity) {
        ByteBuf slice;
        Object object = this.bigEndianLock;
        synchronized (object) {
            if (this.preallocatedBEBuf == null) {
                this.preallocatedBEBuf = Unpooled.directBuffer(this.preallocatedBufCapacity);
                slice = this.preallocatedBEBuf.slice(0, capacity);
                this.preallocatedBEBufPos = capacity;
            } else if (this.preallocatedBEBuf.capacity() - this.preallocatedBEBufPos >= capacity) {
                slice = this.preallocatedBEBuf.slice(this.preallocatedBEBufPos, capacity);
                this.preallocatedBEBufPos += capacity;
            } else {
                this.preallocatedBEBuf = Unpooled.directBuffer(this.preallocatedBufCapacity);
                slice = this.preallocatedBEBuf.slice(0, capacity);
                this.preallocatedBEBufPos = capacity;
            }
        }
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf allocateLittleEndianBuffer(int capacity) {
        ByteBuf slice;
        Object object = this.littleEndianLock;
        synchronized (object) {
            if (this.preallocatedLEBuf == null) {
                this.preallocatedLEBuf = Unpooled.directBuffer(this.preallocatedBufCapacity).order(ByteOrder.LITTLE_ENDIAN);
                slice = this.preallocatedLEBuf.slice(0, capacity);
                this.preallocatedLEBufPos = capacity;
            } else if (this.preallocatedLEBuf.capacity() - this.preallocatedLEBufPos >= capacity) {
                slice = this.preallocatedLEBuf.slice(this.preallocatedLEBufPos, capacity);
                this.preallocatedLEBufPos += capacity;
            } else {
                this.preallocatedLEBuf = Unpooled.directBuffer(this.preallocatedBufCapacity).order(ByteOrder.LITTLE_ENDIAN);
                slice = this.preallocatedLEBuf.slice(0, capacity);
                this.preallocatedLEBufPos = capacity;
            }
        }
        return slice;
    }
}

