/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.HeapByteBufFactory;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.TruncatedByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class DynamicByteBuf
extends AbstractByteBuf {
    private final ByteBufFactory factory;
    private ByteBuf buffer;

    public DynamicByteBuf(int estimatedLength) {
        this(estimatedLength, HeapByteBufFactory.getInstance(ByteOrder.BIG_ENDIAN));
    }

    public DynamicByteBuf(int estimatedLength, ByteBufFactory factory) {
        super(ByteOrder.BIG_ENDIAN);
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
        this.buffer = factory.getBuffer(ByteOrder.BIG_ENDIAN, estimatedLength);
    }

    @Override
    public void ensureWritableBytes(int minWritableBytes) {
        if (minWritableBytes <= this.writableBytes()) {
            return;
        }
        int newCapacity = this.capacity() == 0 ? 1 : this.capacity();
        int minNewCapacity = this.writerIndex() + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if ((newCapacity <<= 1) != 0) continue;
            throw new IllegalStateException("buffer capacity over 2GiB");
        }
        ByteBuf newBuffer = this.factory().getBuffer(this.order(), newCapacity);
        newBuffer.writeBytes(this.buffer, 0, this.writerIndex());
        this.buffer = newBuffer;
    }

    @Override
    public ByteBufFactory factory() {
        return this.factory;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index, out, length);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index, out, length);
    }

    @Override
    public void setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    @Override
    public void setShort(int index, int value) {
        this.buffer.setShort(index, value);
    }

    @Override
    public void setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public void writeByte(int value) {
        this.ensureWritableBytes(1);
        super.writeByte(value);
    }

    @Override
    public void writeShort(int value) {
        this.ensureWritableBytes(2);
        super.writeShort(value);
    }

    @Override
    public void writeMedium(int value) {
        this.ensureWritableBytes(3);
        super.writeMedium(value);
    }

    @Override
    public void writeInt(int value) {
        this.ensureWritableBytes(4);
        super.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.ensureWritableBytes(8);
        super.writeLong(value);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.ensureWritableBytes(src.remaining());
        super.writeBytes(src);
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.ensureWritableBytes(length);
        return super.writeBytes(in, length);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.ensureWritableBytes(length);
        return super.writeBytes(in, length);
    }

    @Override
    public void writeZero(int length) {
        this.ensureWritableBytes(length);
        super.writeZero(length);
    }

    @Override
    public ByteBuf duplicate() {
        return new DuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf copy(int index, int length) {
        DynamicByteBuf copiedBuffer = new DynamicByteBuf(Math.max(length, 64), this.factory());
        copiedBuffer.buffer = this.buffer.copy(index, length);
        copiedBuffer.setIndex(0, length);
        return copiedBuffer;
    }

    @Override
    public ByteBuf slice(int index, int length) {
        if (index == 0) {
            if (length == 0) {
                return Unpooled.EMPTY_BUFFER;
            }
            return new TruncatedByteBuf(this, length);
        }
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return new SlicedByteBuf(this, index, length);
    }

    @Override
    public boolean hasNioBuffer() {
        return this.buffer.hasNioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return this.buffer.nioBuffer(index, length);
    }
}

