/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HeapByteBufFactory
extends AbstractByteBufFactory {
    private static final HeapByteBufFactory INSTANCE_BE = new HeapByteBufFactory(ByteOrder.BIG_ENDIAN);
    private static final HeapByteBufFactory INSTANCE_LE = new HeapByteBufFactory(ByteOrder.LITTLE_ENDIAN);

    public static ByteBufFactory getInstance() {
        return INSTANCE_BE;
    }

    public static ByteBufFactory getInstance(ByteOrder endianness) {
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return INSTANCE_BE;
        }
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return INSTANCE_LE;
        }
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        throw new IllegalStateException("Should not reach here");
    }

    public HeapByteBufFactory() {
    }

    public HeapByteBufFactory(ByteOrder defaultOrder) {
        super(defaultOrder);
    }

    @Override
    public ByteBuf getBuffer(ByteOrder order, int capacity) {
        return Unpooled.buffer(capacity).order(order);
    }

    @Override
    public ByteBuf getBuffer(ByteOrder order, byte[] array, int offset, int length) {
        return Unpooled.wrappedBuffer(array, offset, length).order(order);
    }

    @Override
    public ByteBuf getBuffer(ByteBuffer nioBuffer) {
        if (nioBuffer.hasArray()) {
            return Unpooled.wrappedBuffer(nioBuffer);
        }
        ByteBuf buf = this.getBuffer(nioBuffer.order(), nioBuffer.remaining());
        int pos = nioBuffer.position();
        buf.writeBytes(nioBuffer);
        nioBuffer.position(pos);
        return buf;
    }
}

