/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.DirectByteBufFactory;
import io.netty.buffer.HeapByteBufFactory;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class NioBufferBackedByteBuf
extends AbstractByteBuf {
    private final ByteBuffer buffer;
    private final ByteBuffer tmpBuf;
    private final int capacity;

    public NioBufferBackedByteBuf(ByteBuffer buffer) {
        super(buffer.order());
        this.buffer = buffer.slice().order(this.order());
        this.tmpBuf = this.buffer.duplicate();
        this.capacity = buffer.remaining();
        this.writerIndex(this.capacity);
    }

    private NioBufferBackedByteBuf(NioBufferBackedByteBuf buffer) {
        super(buffer.order());
        this.buffer = buffer.buffer;
        this.tmpBuf = this.buffer.duplicate();
        this.capacity = buffer.capacity;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    @Override
    public ByteBufFactory factory() {
        if (this.buffer.isDirect()) {
            return DirectByteBufFactory.getInstance(this.order());
        }
        return HeapByteBufFactory.getInstance(this.order());
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 0;
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        if (dst instanceof NioBufferBackedByteBuf) {
            NioBufferBackedByteBuf bbdst = (NioBufferBackedByteBuf)dst;
            ByteBuffer data = bbdst.tmpBuf;
            data.clear().position(dstIndex).limit(dstIndex + length);
            this.getBytes(index, data);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        try {
            this.tmpBuf.clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length) + ", maximum is " + this.buffer.limit());
        }
        this.tmpBuf.get(dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        try {
            this.tmpBuf.clear().position(index).limit(index + bytesToCopy);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + bytesToCopy) + ", maximum is " + this.buffer.limit());
        }
        dst.put(this.tmpBuf);
    }

    @Override
    public void setByte(int index, int value) {
        this.buffer.put(index, (byte)value);
    }

    @Override
    public void setShort(int index, int value) {
        this.buffer.putShort(index, (short)value);
    }

    @Override
    public void setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)(value >>> 0));
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.putInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.putLong(index, value);
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        if (src instanceof NioBufferBackedByteBuf) {
            NioBufferBackedByteBuf bbsrc = (NioBufferBackedByteBuf)src;
            ByteBuffer data = bbsrc.tmpBuf;
            data.clear().position(srcIndex).limit(srcIndex + length);
            this.setBytes(index, data);
        } else if (this.buffer.hasArray()) {
            src.getBytes(srcIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            src.getBytes(srcIndex, this, index, length);
        }
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.tmpBuf.clear().position(index).limit(index + length);
        this.tmpBuf.put(src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        if (src == this.tmpBuf) {
            src = src.duplicate();
        }
        this.tmpBuf.clear().position(index).limit(index + src.remaining());
        this.tmpBuf.put(src);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            this.tmpBuf.clear().position(index);
            this.tmpBuf.get(tmp);
            out.write(tmp);
        }
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        this.tmpBuf.clear().position(index).limit(index + length);
        return out.write(this.tmpBuf);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        if (this.buffer.hasArray()) {
            return in.read(this.buffer.array(), this.buffer.arrayOffset() + index, length);
        }
        byte[] tmp = new byte[length];
        int readBytes = in.read(tmp);
        this.tmpBuf.clear().position(index);
        this.tmpBuf.put(tmp);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.tmpBuf.clear().position(index).limit(index + length);
        try {
            return in.read(this.tmpBuf);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public boolean hasNioBuffer() {
        return true;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            return this.buffer.duplicate().order(this.order());
        }
        return ((ByteBuffer)this.tmpBuf.clear().position(index).limit(index + length)).slice().order(this.order());
    }

    @Override
    public ByteBuf slice(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            ByteBuf slice = this.duplicate();
            slice.setIndex(0, length);
            return slice;
        }
        if (index >= 0 && length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return new NioBufferBackedByteBuf(((ByteBuffer)this.tmpBuf.clear().position(index).limit(index + length)).order(this.order()));
    }

    @Override
    public ByteBuf duplicate() {
        return new NioBufferBackedByteBuf(this);
    }

    @Override
    public ByteBuf copy(int index, int length) {
        ByteBuffer src;
        try {
            src = (ByteBuffer)this.tmpBuf.clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length));
        }
        ByteBuffer dst = src.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new NioBufferBackedByteBuf(dst);
    }
}

