/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.ByteBufIndexFinder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ChannelBufType;
import io.netty.buffer.WrappedByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public class SwappedByteBuf
implements WrappedByteBuf {
    private final ByteBuf buf;
    private final ByteOrder order;

    public SwappedByteBuf(ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        this.buf = buf;
        this.order = buf.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (endianness == this.order) {
            return this;
        }
        return this.buf;
    }

    @Override
    public ByteBuf unwrap() {
        return this.buf;
    }

    @Override
    public boolean isPooled() {
        return this.buf.isPooled();
    }

    @Override
    public ChannelBufType type() {
        return ChannelBufType.MESSAGE;
    }

    @Override
    public ByteBufFactory factory() {
        return this.buf.factory();
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public boolean isDirect() {
        return this.buf.isDirect();
    }

    @Override
    public int readerIndex() {
        return this.buf.readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buf.readerIndex(readerIndex);
    }

    @Override
    public int writerIndex() {
        return this.buf.writerIndex();
    }

    @Override
    public void writerIndex(int writerIndex) {
        this.buf.writerIndex(writerIndex);
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        this.buf.setIndex(readerIndex, writerIndex);
    }

    @Override
    public int readableBytes() {
        return this.buf.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.buf.writableBytes();
    }

    @Override
    public boolean readable() {
        return this.buf.readable();
    }

    @Override
    public boolean writable() {
        return this.buf.writable();
    }

    @Override
    public void clear() {
        this.buf.clear();
    }

    @Override
    public void markReaderIndex() {
        this.buf.markReaderIndex();
    }

    @Override
    public void resetReaderIndex() {
        this.buf.resetReaderIndex();
    }

    @Override
    public void markWriterIndex() {
        this.buf.markWriterIndex();
    }

    @Override
    public void resetWriterIndex() {
        this.buf.resetWriterIndex();
    }

    @Override
    public void discardReadBytes() {
        this.buf.discardReadBytes();
    }

    @Override
    public void ensureWritableBytes(int writableBytes) {
        this.buf.ensureWritableBytes(writableBytes);
    }

    @Override
    public boolean getBoolean(int index) {
        return this.buf.getBoolean(index);
    }

    @Override
    public byte getByte(int index) {
        return this.buf.getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return this.buf.getUnsignedByte(index);
    }

    @Override
    public short getShort(int index) {
        return ByteBufUtil.swapShort(this.buf.getShort(index));
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public int getMedium(int index) {
        return ByteBufUtil.swapMedium(this.buf.getMedium(index));
    }

    @Override
    public int getUnsignedMedium(int index) {
        return this.getMedium(index) & 0xFFFFFF;
    }

    @Override
    public int getInt(int index) {
        return ByteBufUtil.swapInt(this.buf.getInt(index));
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int index) {
        return ByteBufUtil.swapLong(this.buf.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public void getBytes(int index, ByteBuf dst) {
        this.buf.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int length) {
        this.buf.getBytes(index, dst, length);
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.buf.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.buf.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.buf.getBytes(index, out, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buf.getBytes(index, out, length);
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.buf.setBoolean(index, value);
    }

    @Override
    public void setByte(int index, int value) {
        this.buf.setByte(index, value);
    }

    @Override
    public void setShort(int index, int value) {
        this.buf.setShort(index, ByteBufUtil.swapShort((short)value));
    }

    @Override
    public void setMedium(int index, int value) {
        this.buf.setMedium(index, ByteBufUtil.swapMedium(value));
    }

    @Override
    public void setInt(int index, int value) {
        this.buf.setInt(index, ByteBufUtil.swapInt(value));
    }

    @Override
    public void setLong(int index, long value) {
        this.buf.setLong(index, ByteBufUtil.swapLong(value));
    }

    @Override
    public void setChar(int index, int value) {
        this.setShort(index, value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
    }

    @Override
    public void setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
    }

    @Override
    public void setBytes(int index, ByteBuf src) {
        this.buf.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ByteBuf src, int length) {
        this.buf.setBytes(index, src, length);
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        this.buf.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.buf.setBytes(index, src);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    @Override
    public void setZero(int index, int length) {
        this.buf.setZero(index, length);
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return ByteBufUtil.swapShort(this.buf.readShort());
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        return ByteBufUtil.swapMedium(this.buf.readMedium());
    }

    @Override
    public int readUnsignedMedium() {
        return this.readMedium() & 0xFFFFFF;
    }

    @Override
    public int readInt() {
        return ByteBufUtil.swapInt(this.buf.readInt());
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        return ByteBufUtil.swapLong(this.buf.readLong());
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int length) {
        return this.buf.readBytes(length);
    }

    @Override
    public ByteBuf readSlice(int length) {
        return this.buf.readSlice(length);
    }

    @Override
    public void readBytes(ByteBuf dst) {
        this.buf.readBytes(dst);
    }

    @Override
    public void readBytes(ByteBuf dst, int length) {
        this.buf.readBytes(dst, length);
    }

    @Override
    public void readBytes(ByteBuf dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buf.readBytes(dst);
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        this.buf.readBytes(dst);
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        this.buf.readBytes(out, length);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.buf.readBytes(out, length);
    }

    @Override
    public void skipBytes(int length) {
        this.buf.skipBytes(length);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buf.writeBoolean(value);
    }

    @Override
    public void writeByte(int value) {
        this.buf.writeByte(value);
    }

    @Override
    public void writeShort(int value) {
        this.buf.writeShort(ByteBufUtil.swapShort((short)value));
    }

    @Override
    public void writeMedium(int value) {
        this.buf.writeMedium(ByteBufUtil.swapMedium(value));
    }

    @Override
    public void writeInt(int value) {
        this.buf.writeInt(ByteBufUtil.swapInt(value));
    }

    @Override
    public void writeLong(long value) {
        this.buf.writeLong(ByteBufUtil.swapLong(value));
    }

    @Override
    public void writeChar(int value) {
        this.writeShort(value);
    }

    @Override
    public void writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
    }

    @Override
    public void writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeBytes(ByteBuf src) {
        this.buf.writeBytes(src);
    }

    @Override
    public void writeBytes(ByteBuf src, int length) {
        this.buf.writeBytes(src, length);
    }

    @Override
    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.buf.writeBytes(src);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.buf.writeBytes(src);
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    @Override
    public void writeZero(int length) {
        this.buf.writeZero(length);
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buf.indexOf(fromIndex, toIndex, value);
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, ByteBufIndexFinder indexFinder) {
        return this.buf.indexOf(fromIndex, toIndex, indexFinder);
    }

    @Override
    public int bytesBefore(byte value) {
        return this.buf.bytesBefore(value);
    }

    @Override
    public int bytesBefore(ByteBufIndexFinder indexFinder) {
        return this.buf.bytesBefore(indexFinder);
    }

    @Override
    public int bytesBefore(int length, byte value) {
        return this.buf.bytesBefore(length, value);
    }

    @Override
    public int bytesBefore(int length, ByteBufIndexFinder indexFinder) {
        return this.buf.bytesBefore(length, indexFinder);
    }

    @Override
    public int bytesBefore(int index, int length, byte value) {
        return this.buf.bytesBefore(index, length, value);
    }

    @Override
    public int bytesBefore(int index, int length, ByteBufIndexFinder indexFinder) {
        return this.buf.bytesBefore(index, length, indexFinder);
    }

    @Override
    public ByteBuf copy() {
        return this.buf.copy().order(this.order);
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return this.buf.copy(index, length).order(this.order);
    }

    @Override
    public ByteBuf slice() {
        return this.buf.slice().order(this.order);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return this.buf.slice(index, length).order(this.order);
    }

    @Override
    public ByteBuf duplicate() {
        return this.buf.duplicate().order(this.order);
    }

    @Override
    public boolean hasNioBuffer() {
        return this.buf.hasNioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer().order(this.order);
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return this.buf.nioBuffer(index, length).order(this.order);
    }

    @Override
    public boolean hasArray() {
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        return this.buf.toString(index, length, charset);
    }

    @Override
    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteBuf) {
            return ByteBufUtil.equals(this, (ByteBuf)obj);
        }
        return false;
    }

    @Override
    public int compareTo(ByteBuf buffer) {
        return ByteBufUtil.compare(this, buffer);
    }

    @Override
    public String toString() {
        return "Swapped(" + this.buf.toString() + ')';
    }
}

