/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class TruncatedByteBuf
extends AbstractByteBuf
implements WrappedByteBuf {
    private final ByteBuf buffer;
    private final int length;

    public TruncatedByteBuf(ByteBuf buffer, int length) {
        super(buffer.order());
        if (length > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Length is too large, got " + length + " but can't go higher than " + buffer.capacity());
        }
        this.buffer = buffer;
        this.length = length;
        this.writerIndex(length);
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufFactory factory() {
        return this.buffer.factory();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index);
    }

    @Override
    public ByteBuf duplicate() {
        TruncatedByteBuf duplicate = new TruncatedByteBuf(this.buffer, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index, length);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        this.checkIndex(index, length);
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return this.buffer.slice(index, length);
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void setByte(int index, int value) {
        this.checkIndex(index);
        this.buffer.setByte(index, value);
    }

    @Override
    public void setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setShort(index, value);
    }

    @Override
    public void setMedium(int index, int value) {
        this.checkIndex(index, 3);
        this.buffer.setMedium(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.buffer.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.buffer.setLong(index, value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        this.buffer.setBytes(index, src);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, out, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.getBytes(index, out, length);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index, in, length);
    }

    @Override
    public boolean hasNioBuffer() {
        return this.buffer.hasNioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.nioBuffer(index, length);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index of " + index + ", maximum is " + this.capacity());
        }
    }

    private void checkIndex(int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length is negative: " + length);
        }
        if (index + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index of " + (index + length) + ", maximum is " + this.capacity());
        }
    }
}

