/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import sun.misc.Cleaner;

public class DirectByteBuf
extends AbstractByteBuf {
    private static final Field CLEANER_FIELD;
    private final ByteBuf.Unsafe unsafe = new DirectUnsafe();
    private boolean doNotFree;
    private ByteBuffer buffer;
    private ByteBuffer tmpBuf;
    private int capacity;

    private static void freeDirect(ByteBuffer buffer) {
        try {
            Cleaner cleaner = (Cleaner)CLEANER_FIELD.get(buffer);
            cleaner.clean();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public DirectByteBuf(int initialCapacity, int maxCapacity) {
        super(ByteOrder.BIG_ENDIAN, maxCapacity);
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity);
        }
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity: " + maxCapacity);
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.setByteBuffer(ByteBuffer.allocateDirect(initialCapacity));
    }

    public DirectByteBuf(ByteBuffer initialBuffer, int maxCapacity) {
        super(ByteOrder.BIG_ENDIAN, maxCapacity);
        if (initialBuffer == null) {
            throw new NullPointerException("initialBuffer");
        }
        if (!initialBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (initialBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int initialCapacity = initialBuffer.remaining();
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.doNotFree = true;
        this.setByteBuffer(initialBuffer.slice().order(ByteOrder.BIG_ENDIAN));
        this.writerIndex(initialCapacity);
    }

    private void setByteBuffer(ByteBuffer buffer) {
        ByteBuffer oldBuffer = this.buffer;
        if (oldBuffer != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                DirectByteBuf.freeDirect(oldBuffer);
            }
        }
        this.buffer = buffer;
        this.tmpBuf = buffer.duplicate();
        this.capacity = buffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity);
        }
        int readerIndex = this.readerIndex();
        int writerIndex = this.writerIndex();
        int oldCapacity = this.capacity;
        if (newCapacity > oldCapacity) {
            ByteBuffer oldBuffer = this.buffer;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            oldBuffer.position(readerIndex).limit(writerIndex);
            newBuffer.position(readerIndex).limit(writerIndex);
            newBuffer.put(oldBuffer);
            newBuffer.clear();
            this.setByteBuffer(newBuffer);
        } else if (newCapacity < oldCapacity) {
            ByteBuffer oldBuffer = this.buffer;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            if (readerIndex < newCapacity) {
                if (writerIndex > newCapacity) {
                    writerIndex = newCapacity;
                    this.writerIndex(writerIndex);
                }
                oldBuffer.position(readerIndex).limit(writerIndex);
                newBuffer.position(readerIndex).limit(writerIndex);
                newBuffer.put(oldBuffer);
                newBuffer.clear();
            } else {
                this.setIndex(newCapacity, newCapacity);
            }
            this.setByteBuffer(newBuffer);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 0;
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        if (dst instanceof DirectByteBuf) {
            DirectByteBuf bbdst = (DirectByteBuf)dst;
            ByteBuffer data = bbdst.tmpBuf;
            data.clear().position(dstIndex).limit(dstIndex + length);
            this.getBytes(index, data);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        try {
            this.tmpBuf.clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length) + ", maximum is " + this.buffer.limit());
        }
        this.tmpBuf.get(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        try {
            this.tmpBuf.clear().position(index).limit(index + bytesToCopy);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + bytesToCopy) + ", maximum is " + this.buffer.limit());
        }
        dst.put(this.tmpBuf);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.buffer.put(index, (byte)value);
        return this;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.buffer.putShort(index, (short)value);
        return this;
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)(value >>> 0));
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.buffer.putInt(index, value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.buffer.putLong(index, value);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        if (src instanceof DirectByteBuf) {
            DirectByteBuf bbsrc = (DirectByteBuf)src;
            ByteBuffer data = bbsrc.tmpBuf;
            data.clear().position(srcIndex).limit(srcIndex + length);
            this.setBytes(index, data);
        } else if (this.buffer.hasArray()) {
            src.getBytes(srcIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            src.getBytes(srcIndex, this, index, length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.tmpBuf.clear().position(index).limit(index + length);
        this.tmpBuf.put(src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        if (src == this.tmpBuf) {
            src = src.duplicate();
        }
        this.tmpBuf.clear().position(index).limit(index + src.remaining());
        this.tmpBuf.put(src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        if (length == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            this.tmpBuf.clear().position(index);
            this.tmpBuf.get(tmp);
            out.write(tmp);
        }
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        this.tmpBuf.clear().position(index).limit(index + length);
        return out.write(this.tmpBuf);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        if (this.buffer.hasArray()) {
            return in.read(this.buffer.array(), this.buffer.arrayOffset() + index, length);
        }
        byte[] tmp = new byte[length];
        int readBytes = in.read(tmp);
        this.tmpBuf.clear().position(index);
        this.tmpBuf.put(tmp);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.tmpBuf.clear().position(index).limit(index + length);
        try {
            return in.read(this.tmpBuf);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public boolean hasNioBuffer() {
        return true;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            return this.buffer.duplicate();
        }
        return ((ByteBuffer)this.tmpBuf.clear().position(index).limit(index + length)).slice();
    }

    @Override
    public boolean hasNioBuffers() {
        return false;
    }

    @Override
    public ByteBuffer[] nioBuffers(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        ByteBuffer src;
        try {
            src = (ByteBuffer)this.tmpBuf.clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length));
        }
        ByteBuffer dst = src.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new DirectByteBuf(dst, this.maxCapacity());
    }

    @Override
    public ByteBuf.Unsafe unsafe() {
        return this.unsafe;
    }

    static {
        Field cleanerField;
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            cleanerField = direct.getClass().getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            Cleaner cleaner = (Cleaner)cleanerField.get(direct);
            cleaner.clean();
        }
        catch (Throwable t) {
            cleanerField = null;
        }
        CLEANER_FIELD = cleanerField;
    }

    private class DirectUnsafe
    implements ByteBuf.Unsafe {
        private DirectUnsafe() {
        }

        @Override
        public ByteBuffer nioBuffer() {
            return DirectByteBuf.this.tmpBuf;
        }

        @Override
        public ByteBuffer[] nioBuffers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuf newBuffer(int initialCapacity) {
            return new DirectByteBuf(initialCapacity, Math.max(initialCapacity, DirectByteBuf.this.maxCapacity()));
        }

        @Override
        public void discardSomeReadBytes() {
            int readerIndex = DirectByteBuf.this.readerIndex();
            if (readerIndex == DirectByteBuf.this.writerIndex()) {
                DirectByteBuf.this.discardReadBytes();
                return;
            }
            if (readerIndex > 0 && readerIndex >= DirectByteBuf.this.capacity >>> 1) {
                DirectByteBuf.this.discardReadBytes();
            }
        }

        @Override
        public void acquire() {
            if (DirectByteBuf.this.refCnt <= 0) {
                throw new IllegalStateException();
            }
            ++DirectByteBuf.this.refCnt;
        }

        @Override
        public void release() {
            if (DirectByteBuf.this.refCnt <= 0) {
                throw new IllegalStateException();
            }
            --DirectByteBuf.this.refCnt;
            if (DirectByteBuf.this.refCnt == 0) {
                if (DirectByteBuf.this.doNotFree) {
                    DirectByteBuf.this.doNotFree = false;
                } else {
                    DirectByteBuf.freeDirect(DirectByteBuf.this.buffer);
                }
                DirectByteBuf.this.buffer = null;
                DirectByteBuf.this.tmpBuf = null;
            }
        }
    }
}

