/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ChannelBufType;
import io.netty.buffer.MessageBuf;
import java.util.ArrayDeque;
import java.util.Collection;

public class DefaultMessageBuf<T>
extends ArrayDeque<T>
implements MessageBuf<T> {
    private static final long serialVersionUID = 1229808623624907552L;

    public DefaultMessageBuf() {
    }

    public DefaultMessageBuf(Collection<? extends T> c) {
        super(c);
    }

    public DefaultMessageBuf(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public ChannelBufType type() {
        return ChannelBufType.MESSAGE;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        Object o;
        int cnt = 0;
        while ((o = this.poll()) != null) {
            c.add(o);
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        Object o;
        int cnt;
        for (cnt = 0; cnt < maxElements && (o = this.poll()) != null; ++cnt) {
            c.add(o);
        }
        return cnt;
    }
}

