/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolChunk;

final class PoolSubpage<T> {
    final PoolChunk<T> chunk;
    final int memoryMapIdx;
    final int runOffset;
    final int pageSize;
    final long[] bitmap;
    boolean doNotDestroy;
    int elemSize;
    int maxNumElems;
    int nextAvail;
    int bitmapLength;
    int numAvail;

    PoolSubpage(PoolChunk<T> chunk, int memoryMapIdx, int runOffset, int pageSize, int elemSize) {
        this.chunk = chunk;
        this.memoryMapIdx = memoryMapIdx;
        this.runOffset = runOffset;
        this.pageSize = pageSize;
        this.bitmap = new long[pageSize >>> 10];
        this.init(elemSize);
    }

    void init(int elemSize) {
        this.doNotDestroy = true;
        this.elemSize = elemSize;
        if (elemSize == 0) {
            return;
        }
        this.maxNumElems = this.numAvail = this.pageSize / elemSize;
        this.nextAvail = 0;
        this.bitmapLength = this.maxNumElems >>> 6;
        if ((this.maxNumElems & 0x3F) != 0) {
            ++this.bitmapLength;
        }
        for (int i = 0; i < this.bitmapLength; ++i) {
            this.bitmap[i] = 0L;
        }
    }

    long allocate() {
        if (this.elemSize == 0) {
            return this.toHandle(0);
        }
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int bitmapIdx = this.nextAvail;
        int q = bitmapIdx >>> 6;
        int r = bitmapIdx & 0x3F;
        assert ((this.bitmap[q] >>> r & 1L) == 0L);
        int n = q;
        this.bitmap[n] = this.bitmap[n] | 1L << r;
        this.nextAvail = --this.numAvail == 0 ? -1 : this.findNextAvailable();
        return this.toHandle(bitmapIdx);
    }

    boolean free(int bitmapIdx) {
        if (this.elemSize == 0) {
            return true;
        }
        int q = bitmapIdx >>> 6;
        int r = bitmapIdx & 0x3F;
        assert ((this.bitmap[q] >>> r & 1L) != 0L);
        int n = q;
        this.bitmap[n] = this.bitmap[n] ^ 1L << r;
        if (this.numAvail++ == 0) {
            this.nextAvail = bitmapIdx;
            this.chunk.arena.addSubpage(this);
            return true;
        }
        if (this.numAvail < this.maxNumElems) {
            return true;
        }
        this.doNotDestroy = false;
        return false;
    }

    private int findNextAvailable() {
        int newNextAvail = -1;
        block0: for (int i = 0; i < this.bitmapLength; ++i) {
            long bits = this.bitmap[i];
            if ((bits ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((bits & 1L) == 0L) {
                    newNextAvail = i << 6 | j;
                    break block0;
                }
                bits >>>= 1;
            }
        }
        if (newNextAvail < this.maxNumElems) {
            return newNextAvail;
        }
        return -1;
    }

    private long toHandle(int bitmapIdx) {
        return 0x4000000000000000L | (long)bitmapIdx << 32 | (long)this.memoryMapIdx;
    }

    public String toString() {
        if (!this.doNotDestroy) {
            return "(" + this.memoryMapIdx + ": not in use)";
        }
        return String.valueOf('(') + this.memoryMapIdx + ": " + (this.maxNumElems - this.numAvail) + '/' + this.maxNumElems + ", offset: " + this.runOffset + ", length: " + this.pageSize + ", elemSize: " + this.elemSize + ')';
    }
}

