/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private long memoryAddress;

    PooledUnsafeDirectByteBuf(int maxCapacity) {
        super(maxCapacity);
    }

    @Override
    void init(PoolChunk<ByteBuffer> chunk, long handle, int offset, int length, int maxLength) {
        super.init(chunk, handle, offset, length, maxLength);
        this.initMemoryAddress();
    }

    @Override
    void initUnpooled(PoolChunk<ByteBuffer> chunk, int length) {
        super.initUnpooled(chunk, length);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)((ByteBuffer)this.memory)) + (long)this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return PlatformDependent.getByte((long)this.addr(index));
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        short v = PlatformDependent.getShort((long)this.addr(index));
        return NATIVE_ORDER ? v : Short.reverseBytes(v);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        long addr = this.addr(index);
        return (PlatformDependent.getByte((long)addr) & 0xFF) << 16 | (PlatformDependent.getByte((long)(addr + 1L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(addr + 2L)) & 0xFF;
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        int v = PlatformDependent.getInt((long)this.addr(index));
        return NATIVE_ORDER ? v : Integer.reverseBytes(v);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        long v = PlatformDependent.getLong((long)this.addr(index));
        return NATIVE_ORDER ? v : Long.reverseBytes(v);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        if (length != 0) {
            if (dst instanceof PooledUnsafeDirectByteBuf) {
                PooledUnsafeDirectByteBuf bbdst = (PooledUnsafeDirectByteBuf)dst;
                PlatformDependent.copyMemory((long)this.addr(index), (long)bbdst.addr(dstIndex), (long)length);
            } else if (dst.hasArray()) {
                PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst.array(), (int)(dst.arrayOffset() + dstIndex), (long)length);
            } else {
                dst.setBytes(dstIndex, this, index, length);
            }
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        if (length != 0) {
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst, (int)dstIndex, (long)length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index);
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + bytesToCopy);
        dst.put(tmpBuf);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length != 0) {
            byte[] tmp = new byte[length];
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])tmp, (int)0, (long)length);
            out.write(tmp);
        }
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length);
        return out.write(tmpBuf);
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.checkIndex(index);
        PlatformDependent.putByte((long)this.addr(index), (byte)((byte)value));
        return this;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.checkIndex(index, 2);
        PlatformDependent.putShort((long)this.addr(index), (short)(NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value)));
        return this;
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.checkIndex(index, 3);
        long addr = this.addr(index);
        PlatformDependent.putByte((long)addr, (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((long)(addr + 1L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(addr + 2L), (byte)((byte)value));
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.checkIndex(index, 4);
        PlatformDependent.putInt((long)this.addr(index), (int)(NATIVE_ORDER ? value : Integer.reverseBytes(value)));
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.checkIndex(index, 8);
        PlatformDependent.putLong((long)this.addr(index), (long)(NATIVE_ORDER ? value : Long.reverseBytes(value)));
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkIndex(index, length);
        if (length != 0) {
            if (src instanceof PooledUnsafeDirectByteBuf) {
                PooledUnsafeDirectByteBuf bbsrc = (PooledUnsafeDirectByteBuf)src;
                PlatformDependent.copyMemory((long)bbsrc.addr(srcIndex), (long)this.addr(index), (long)length);
            } else if (src.hasArray()) {
                PlatformDependent.copyMemory((byte[])src.array(), (int)(src.arrayOffset() + srcIndex), (long)this.addr(index), (long)length);
            } else {
                src.getBytes(srcIndex, this, index, length);
            }
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        if (length != 0) {
            PlatformDependent.copyMemory((byte[])src, (int)srcIndex, (long)this.addr(index), (long)length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex(index);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + src.remaining());
        tmpBuf.put(src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        byte[] tmp = new byte[length];
        int readBytes = in.read(tmp);
        if (readBytes > 0) {
            PlatformDependent.copyMemory((byte[])tmp, (int)0, (long)this.addr(index), (long)readBytes);
        }
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        ByteBuffer tmpNioBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpNioBuf.clear().position(index).limit(index + length);
        try {
            return in.read(tmpNioBuf);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        PooledUnsafeDirectByteBuf copy = (PooledUnsafeDirectByteBuf)this.alloc().directBuffer(this.capacity(), this.maxCapacity());
        if (length != 0) {
            PlatformDependent.copyMemory((long)this.addr(index), (long)copy.addr(index), (long)length);
            copy.setIndex(index, index + length);
        }
        return copy;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        index = this.idx(index);
        return ((ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }
}

