/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class UnsafeByteBufUtilTest {
    @BeforeEach
    public void checkHasUnsafe() {
        Assumptions.assumeTrue((boolean)PlatformDependent.hasUnsafe(), (String)"sun.misc.Unsafe not found, skip tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesOnReadOnlyByteBuffer() throws Exception {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        ByteBuffer readOnlyBuffer = ByteBuffer.wrap(testData).asReadOnlyBuffer();
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        try {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (ByteBuffer)readOnlyBuffer);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assertions.assertArrayEquals((byte[])testData, (byte[])check, (String)"The byte array's copy does not equal the original");
        }
        finally {
            targetBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesOnReadOnlyByteBufferWithPooledAlloc() throws Exception {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        ByteBuffer readOnlyBuffer = ByteBuffer.wrap(testData).asReadOnlyBuffer();
        int pageSize = 4096;
        PooledByteBufAllocator alloc = new PooledByteBufAllocator(true, 1, 1, pageSize, 0);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        ByteBuf b1 = alloc.heapBuffer(16);
        ByteBuf b2 = alloc.heapBuffer(16);
        try {
            Assertions.assertEquals((int)pageSize, (int)b1.array().length);
            Assertions.assertArrayEquals((byte[])b1.array(), (byte[])b2.array());
            Assertions.assertNotEquals((int)b1.arrayOffset(), (int)b2.arrayOffset());
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (ByteBuffer)readOnlyBuffer);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assertions.assertArrayEquals((byte[])testData, (byte[])check, (String)"The byte array's copy does not equal the original");
        }
        finally {
            targetBuffer.release();
            b1.release();
            b2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesWithByteArray() {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        try {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (byte[])testData, (int)0, (int)length);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assertions.assertArrayEquals((byte[])testData, (byte[])check, (String)"The byte array's copy does not equal the original");
        }
        finally {
            targetBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesWithZeroLength() {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        try {
            byte[] beforeSet = new byte[length];
            targetBuffer.getBytes(0, beforeSet, 0, length);
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (byte[])testData, (int)0, (int)0);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assertions.assertArrayEquals((byte[])beforeSet, (byte[])check);
        }
        finally {
            targetBuffer.release();
        }
    }

    @Test
    public void testSetBytesWithNullByteArray() {
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        final UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, 8, 8);
        try {
            Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

                public void execute() {
                    UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (byte[])null, (int)0, (int)8);
                }
            });
        }
        finally {
            targetBuffer.release();
        }
    }

    @Test
    public void testSetBytesOutOfBounds() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 4, -1, 0, 4);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds2() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 4, 0, 0, -1);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds3() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 8, 0, 0, 5);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds4() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 4, 3, 0, 3);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds5() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 4, 0, -1, 4);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds6() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(8, 4, 0, 0, 5);
            }
        });
    }

    @Test
    public void testSetBytesOutOfBounds7() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                UnsafeByteBufUtilTest.testSetBytesOutOfBounds0(4, 4, 0, 1, 4);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSetBytesOutOfBounds0(int lengthOfBuffer, int lengthOfBytes, int index, int srcIndex, int length) {
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, lengthOfBuffer, lengthOfBuffer);
        try {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)index, (byte[])new byte[lengthOfBytes], (int)srcIndex, (int)length);
        }
        finally {
            targetBuffer.release();
        }
    }
}

