/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AdvancedLeakAwareByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.NoopResourceLeakTracker;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBufTest;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ResourceLeakTracker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdvancedLeakAwareByteBufTest
extends SimpleLeakAwareByteBufTest {
    @Override
    protected Class<? extends ByteBuf> leakClass() {
        return AdvancedLeakAwareByteBuf.class;
    }

    @Override
    protected SimpleLeakAwareByteBuf wrap(ByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new AdvancedLeakAwareByteBuf(buffer, tracker);
    }

    @Test
    public void testAddComponentWithLeakAwareByteBuf() {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])"hello world".getBytes(CharsetUtil.US_ASCII)).slice(6, 5);
        SimpleLeakAwareByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponent(true, (ByteBuf)leakAwareBuf);
        byte[] result = new byte[5];
        ByteBuf bb = composite.component(0);
        bb.readBytes(result);
        Assertions.assertArrayEquals((byte[])"world".getBytes(CharsetUtil.US_ASCII), (byte[])result);
        composite.release();
    }
}

