/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public abstract class AbstractCompositeByteBufTest
extends AbstractByteBufTest {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    private final ByteOrder order;

    protected AbstractCompositeByteBufTest(ByteOrder order) {
        this.order = (ByteOrder)ObjectUtil.checkNotNull((Object)order, (String)"order");
    }

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        CompositeByteBuf buffer;
        Assumptions.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
        for (int i = 0; i < length + 45; i += 45) {
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[1]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[2]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[3]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[4]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[5]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[6]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[7]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[8]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[9]));
            buffers.add(Unpooled.EMPTY_BUFFER);
        }
        switch (buffers.size()) {
            case 0: {
                buffer = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
                break;
            }
            case 1: {
                buffer = Unpooled.compositeBuffer((int)Integer.MAX_VALUE).addComponent((ByteBuf)buffers.get(0));
                break;
            }
            default: {
                buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0]));
            }
        }
        buffer = buffer.order(this.order);
        buffer.capacity(length);
        Assertions.assertEquals((int)length, (int)buffer.capacity());
        Assertions.assertEquals((int)length, (int)buffer.readableBytes());
        Assertions.assertFalse((boolean)buffer.isWritable());
        buffer.writerIndex(0);
        return buffer;
    }

    protected CompositeByteBuf newCompositeBuffer() {
        return Unpooled.compositeBuffer();
    }

    @Override
    protected boolean discardReadBytesDoesNotMoveWritableBytes() {
        return false;
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assertions.assertFalse((boolean)buf.isContiguous());
        buf.release();
    }

    @Test
    public void testComponentAtOffset() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}});
        Assertions.assertEquals((int)5, (int)buf.componentAtOffset(2).capacity());
        for (int index = 0; index < buf.capacity(); index = (int)((byte)(index + 1))) {
            int n = index;
            ByteBuf _buf = buf.componentAtOffset(n);
            Assertions.assertNotNull((Object)_buf);
            Assertions.assertTrue((_buf.capacity() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((_buf.getByte(0) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((_buf.getByte(_buf.readableBytes() - 1) > 0 ? 1 : 0) != 0);
        }
        buf.release();
    }

    @Test
    public void testToComponentIndex() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}, {10, 9, 8, 7, 6, 5, 33}});
        Assertions.assertEquals((int)0, (int)buf.toComponentIndex(4));
        Assertions.assertEquals((int)1, (int)buf.toComponentIndex(5));
        Assertions.assertEquals((int)2, (int)buf.toComponentIndex(15));
        for (int index = 0; index < buf.capacity(); index = (int)((byte)(index + 1))) {
            int n = index;
            int cindex = buf.toComponentIndex(n);
            Assertions.assertTrue((cindex >= 0 && cindex < buf.numComponents() ? 1 : 0) != 0);
        }
        buf.release();
    }

    @Test
    public void testToByteIndex() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}, {10, 9, 8, 7, 6, 5, 33}});
        Assertions.assertEquals((int)0, (int)buf.toByteIndex(0));
        Assertions.assertEquals((int)5, (int)buf.toByteIndex(1));
        Assertions.assertEquals((int)12, (int)buf.toByteIndex(2));
        buf.release();
    }

    @Test
    public void testDiscardReadBytes3() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (int)0, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (int)5, (int)5).order(this.order)});
        a.skipBytes(6);
        a.markReaderIndex();
        b.skipBytes(6);
        b.markReaderIndex();
        Assertions.assertEquals((int)a.readerIndex(), (int)b.readerIndex());
        a.readerIndex(a.readerIndex() - 1);
        b.readerIndex(b.readerIndex() - 1);
        Assertions.assertEquals((int)a.readerIndex(), (int)b.readerIndex());
        a.writerIndex(a.writerIndex() - 1);
        a.markWriterIndex();
        b.writerIndex(b.writerIndex() - 1);
        b.markWriterIndex();
        Assertions.assertEquals((int)a.writerIndex(), (int)b.writerIndex());
        a.writerIndex(a.writerIndex() + 1);
        b.writerIndex(b.writerIndex() + 1);
        Assertions.assertEquals((int)a.writerIndex(), (int)b.writerIndex());
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.discardReadBytes();
        b.discardReadBytes();
        Assertions.assertEquals((int)a.readerIndex(), (int)b.readerIndex());
        Assertions.assertEquals((int)a.writerIndex(), (int)b.writerIndex());
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.resetReaderIndex();
        b.resetReaderIndex();
        Assertions.assertEquals((int)a.readerIndex(), (int)b.readerIndex());
        a.resetWriterIndex();
        b.resetWriterIndex();
        Assertions.assertEquals((int)a.writerIndex(), (int)b.writerIndex());
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
    }

    @Test
    public void testAutoConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)2);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        Assertions.assertEquals((int)2, (int)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        Assertions.assertTrue((boolean)buf.hasArray());
        Assertions.assertNotNull((Object)buf.array());
        Assertions.assertEquals((int)0, (int)buf.arrayOffset());
        buf.release();
    }

    @Test
    public void testCompositeToSingleBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)3);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}));
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4}));
        Assertions.assertEquals((int)2, (int)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{5, 6}));
        Assertions.assertEquals((int)3, (int)buf.numComponents());
        ByteBuffer nioBuffer = buf.nioBuffer(0, 6);
        byte[] bytes = nioBuffer.array();
        Assertions.assertEquals((int)6, (int)bytes.length);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (byte[])bytes);
        buf.release();
    }

    @Test
    public void testFullConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        buf.consolidate();
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        Assertions.assertTrue((boolean)buf.hasArray());
        Assertions.assertNotNull((Object)buf.array());
        Assertions.assertEquals((int)0, (int)buf.arrayOffset());
        buf.release();
    }

    @Test
    public void testRangedConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}));
        buf.consolidate(1, 2);
        Assertions.assertEquals((int)3, (int)buf.numComponents());
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1}), (Object)buf.component(0));
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6}), (Object)buf.component(1));
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}), (Object)buf.component(2));
        buf.release();
    }

    @Test
    public void testCompositeWrappedBuffer() {
        ByteBuf header = Unpooled.buffer((int)12).order(this.order);
        ByteBuf payload = Unpooled.buffer((int)512).order(this.order);
        header.writeBytes(new byte[12]);
        payload.writeBytes(new byte[512]);
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, payload});
        Assertions.assertEquals((int)12, (int)header.readableBytes());
        Assertions.assertEquals((int)512, (int)payload.readableBytes());
        Assertions.assertEquals((int)524, (int)buffer.readableBytes());
        Assertions.assertEquals((int)2, (int)buffer.nioBufferCount());
        buffer.release();
    }

    @Test
    public void testSeveralBuffersEquals() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order)});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order)});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)1, (int)2).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)3, (int)1).order(this.order)});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{4}).order(this.order)});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)1, (int)2).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)3, (int)1).order(this.order)});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}).order(this.order)});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)1, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)6, (int)5).order(this.order)});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 6}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 5, 9, 10}).order(this.order)});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)1, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)6, (int)5).order(this.order)});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
    }

    @Test
    public void testWrappedBuffer() {
        ByteBuf a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(16)));
        Assertions.assertEquals((int)16, (int)a.capacity());
        a.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3}}).order(this.order));
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, {2}, {3}}).order(this.order));
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order)});
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order)});
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1, 2, 3})}));
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}), ByteBuffer.wrap(new byte[]{3})}));
        Assertions.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
    }

    @Test
    public void testWrittenBuffersEquals() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, new byte[1]})).order(this.order);
        ByteBuf c = Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, new byte[2]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order);
        b.writerIndex(b.writerIndex() - 2);
        b.writeBytes(c);
        c.release();
        c = Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order);
        b.writeBytes(c);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)1, (int)3)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)3, (int)1).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2}, new byte[1]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{4}).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)1, (int)3)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)3, (int)1).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3}, new byte[7]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}).order(this.order);
        b.writerIndex(b.writerIndex() - 7);
        b.writeBytes(c);
        c.release();
        c = Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}).order(this.order);
        b.writeBytes(c);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)1, (int)10)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)6, (int)5).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 6}, new byte[5]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 5, 9, 10}).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)1, (int)10)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)6, (int)5).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
    }

    @Test
    public void testEmptyBuffer() {
        ByteBuf b = Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2}, {3, 4}});
        b.readBytes(new byte[4]);
        b.readBytes(EmptyArrays.EMPTY_BYTES);
        b.release();
    }

    @Test
    public void testReadWithEmptyCompositeBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        int n = 65;
        for (int i = 0; i < n; ++i) {
            buf.writeByte(1);
            Assertions.assertEquals((int)1, (int)buf.readByte());
        }
        buf.release();
    }

    @Test
    public void testComponentMustBeDuplicate() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.buffer((int)4, (int)6).setIndex(1, 3));
        MatcherAssert.assertThat((Object)buf.component(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AbstractDerivedByteBuf.class)));
        MatcherAssert.assertThat((Object)buf.component(0).capacity(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)buf.component(0).maxCapacity(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)buf.component(0).readableBytes(), (Matcher)CoreMatchers.is((Object)2));
        buf.release();
    }

    @Test
    public void testReferenceCounts1() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        MatcherAssert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        buf.addComponents(new ByteBuf[]{c1, c2, c3});
        MatcherAssert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)buf.component(0).refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)buf.component(1).refCnt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)buf.component(2).refCnt(), (Matcher)CoreMatchers.is((Object)3));
        c3.release(2);
        c2.release();
        buf.release();
    }

    @Test
    public void testReferenceCounts2() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf bufA = Unpooled.compositeBuffer();
        bufA.addComponents(new ByteBuf[]{c1, c2, c3}).writerIndex(3);
        CompositeByteBuf bufB = Unpooled.compositeBuffer();
        bufB.addComponents((Iterable)bufA);
        MatcherAssert.assertThat((Object)bufA.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        bufB.release();
        MatcherAssert.assertThat((Object)bufB.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufA.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        c3.release(2);
        c2.release();
    }

    @Test
    public void testReferenceCounts3() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        MatcherAssert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        ArrayList components = new ArrayList();
        Collections.addAll(components, c1, c2, c3);
        buf.addComponents(components);
        MatcherAssert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)buf.component(0).refCnt(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)buf.component(1).refCnt(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)buf.component(2).refCnt(), (Matcher)CoreMatchers.is((Object)3));
        c3.release(2);
        c2.release();
        buf.release();
    }

    @Test
    public void testNestedLayout() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.compositeBuffer().addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2})).addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{3, 4})).slice(1, 2));
        ByteBuffer[] nioBuffers = buf.nioBuffers(0, 2);
        MatcherAssert.assertThat((Object)nioBuffers.length, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)nioBuffers[0].remaining(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)nioBuffers[0].get(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)nioBuffers[1].remaining(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)nioBuffers[1].get(), (Matcher)CoreMatchers.is((Object)3));
        buf.release();
    }

    @Test
    public void testRemoveLastComponent() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        buf.removeComponent(0);
        Assertions.assertEquals((int)0, (int)buf.numComponents());
        buf.release();
    }

    @Test
    public void testCopyEmpty() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assertions.assertEquals((int)0, (int)buf.numComponents());
        ByteBuf copy = buf.copy();
        Assertions.assertEquals((int)0, (int)copy.readableBytes());
        buf.release();
        copy.release();
    }

    @Test
    public void testDuplicateEmpty() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assertions.assertEquals((int)0, (int)buf.numComponents());
        Assertions.assertEquals((int)0, (int)buf.duplicate().readableBytes());
        buf.release();
    }

    @Test
    public void testRemoveLastComponentWithOthersLeft() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assertions.assertEquals((int)2, (int)buf.numComponents());
        buf.removeComponent(1);
        Assertions.assertEquals((int)1, (int)buf.numComponents());
        buf.release();
    }

    @Test
    public void testRemoveComponents() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        for (int i = 0; i < 10; ++i) {
            buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        }
        Assertions.assertEquals((int)10, (int)buf.numComponents());
        Assertions.assertEquals((int)20, (int)buf.capacity());
        buf.removeComponents(4, 3);
        Assertions.assertEquals((int)7, (int)buf.numComponents());
        Assertions.assertEquals((int)14, (int)buf.capacity());
        buf.release();
    }

    @Test
    public void testGatheringWritesHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order));
    }

    @Test
    public void testGatheringWritesDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesMixes() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesHeapPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesDirectPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesMixesPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order));
    }

    private static void testGatheringWrites(ByteBuf buf1, ByteBuf buf2) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(buf1.writeBytes(new byte[]{1, 2}));
        buf.addComponent(buf2.writeBytes(new byte[]{1, 2}));
        buf.writerIndex(3);
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testGatheringWritesPartialHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialMixes() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialHeapSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialDirectSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialMixesSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialHeapPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialDirectPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialMixesPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialHeapPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialDirectPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialMixesPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), true);
    }

    private static void testGatheringWritesPartial(ByteBuf buf1, ByteBuf buf2, boolean slice) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf1.writeBytes(new byte[]{1, 2, 3, 4});
        buf2.writeBytes(new byte[]{1, 2, 3, 4});
        if (slice) {
            buf1 = buf1.readerIndex(1).slice();
            buf2 = buf2.writerIndex(3).slice();
            buf.addComponent(buf1);
            buf.addComponent(buf2);
            buf.writerIndex(6);
        } else {
            buf.addComponent(buf1);
            buf.addComponent(buf2);
            buf.writerIndex(7);
            buf.readerIndex(1);
        }
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel(1);
        while (buf.isReadable()) {
            buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
        }
        byte[] data = new byte[6];
        if (slice) {
            buf.getBytes(0, data);
        } else {
            buf.getBytes(1, data);
        }
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testGatheringWritesSingleHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.buffer().order(this.order));
    }

    @Test
    public void testGatheringWritesSingleDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.directBuffer().order(this.order));
    }

    private static void testGatheringWritesSingleBuf(ByteBuf buf1) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(buf1.writeBytes(new byte[]{1, 2, 3, 4}));
        buf.writerIndex(3);
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Override
    @Test
    public void testInternalNioBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assertions.assertEquals((int)0, (int)buf.internalNioBuffer(0, 0).remaining());
        ByteBuf concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer);
        Assertions.assertSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
        buf = Unpooled.compositeBuffer();
        concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer.slice());
        Assertions.assertNotSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
        buf = Unpooled.compositeBuffer();
        concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer.duplicate());
        Assertions.assertNotSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
    }

    @Test
    public void testisDirectMultipleBufs() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assertions.assertFalse((boolean)buf.isDirect());
        buf.addComponent(Unpooled.directBuffer().writeByte(1));
        Assertions.assertTrue((boolean)buf.isDirect());
        buf.addComponent(Unpooled.directBuffer().writeByte(1));
        Assertions.assertTrue((boolean)buf.isDirect());
        buf.addComponent(Unpooled.buffer().writeByte(1));
        Assertions.assertFalse((boolean)buf.isDirect());
        buf.release();
    }

    @Test
    public void testDiscardSomeReadBytes() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        int len = 32;
        for (int i = 0; i < len; i += 4) {
            ByteBuf buf = Unpooled.buffer().writeInt(i);
            cbuf.capacity(cbuf.writerIndex()).addComponent(buf).writerIndex(i + 4);
        }
        cbuf.writeByte(1);
        byte[] me = new byte[len];
        cbuf.readBytes(me);
        cbuf.readByte();
        cbuf.discardSomeReadBytes();
        cbuf.release();
    }

    @Test
    public void testAddEmptyBufferRelease() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf = Unpooled.buffer();
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        cbuf.addComponent(buf);
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        cbuf.release();
        Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testAddEmptyBuffersRelease() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf = Unpooled.buffer();
        ByteBuf buf2 = Unpooled.buffer().writeInt(1);
        ByteBuf buf3 = Unpooled.buffer();
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertEquals((int)1, (int)buf2.refCnt());
        Assertions.assertEquals((int)1, (int)buf3.refCnt());
        cbuf.addComponents(new ByteBuf[]{buf, buf2, buf3});
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertEquals((int)1, (int)buf2.refCnt());
        Assertions.assertEquals((int)1, (int)buf3.refCnt());
        cbuf.release();
        Assertions.assertEquals((int)0, (int)buf.refCnt());
        Assertions.assertEquals((int)0, (int)buf2.refCnt());
        Assertions.assertEquals((int)0, (int)buf3.refCnt());
    }

    @Test
    public void testAddEmptyBufferInMiddle() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf1 = Unpooled.buffer().writeByte(1);
        cbuf.addComponent(true, buf1);
        cbuf.addComponent(true, Unpooled.EMPTY_BUFFER);
        ByteBuf buf3 = Unpooled.buffer().writeByte(2);
        cbuf.addComponent(true, buf3);
        Assertions.assertEquals((int)2, (int)cbuf.readableBytes());
        Assertions.assertEquals((byte)1, (byte)cbuf.readByte());
        Assertions.assertEquals((byte)2, (byte)cbuf.readByte());
        Assertions.assertSame((Object)Unpooled.EMPTY_BUFFER, (Object)cbuf.internalComponent(1));
        Assertions.assertNotSame((Object)Unpooled.EMPTY_BUFFER, (Object)cbuf.internalComponentAtOffset(1));
        cbuf.release();
    }

    @Test
    public void testInsertEmptyBufferInMiddle() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf1 = Unpooled.buffer().writeByte(1);
        cbuf.addComponent(true, buf1);
        ByteBuf buf2 = Unpooled.buffer().writeByte(2);
        cbuf.addComponent(true, buf2);
        cbuf.addComponent(true, 1, Unpooled.EMPTY_BUFFER);
        Assertions.assertEquals((int)2, (int)cbuf.readableBytes());
        Assertions.assertEquals((byte)1, (byte)cbuf.readByte());
        Assertions.assertEquals((byte)2, (byte)cbuf.readByte());
        Assertions.assertEquals((int)2, (int)cbuf.capacity());
        Assertions.assertEquals((int)3, (int)cbuf.numComponents());
        byte[] dest = new byte[2];
        cbuf.getBytes(0, dest);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])dest);
        cbuf.release();
    }

    @Test
    public void testAddFlattenedComponents() {
        this.testAddFlattenedComponents(false);
    }

    @Test
    public void testAddFlattenedComponentsWithWrappedComposite() {
        this.testAddFlattenedComponents(true);
    }

    private void testAddFlattenedComponents(boolean addWrapped) {
        ByteBuf b1 = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        CompositeByteBuf newComposite = this.newCompositeBuffer().addComponent(true, b1).addFlattenedComponents(true, b1.retain()).addFlattenedComponents(true, Unpooled.EMPTY_BUFFER);
        Assertions.assertEquals((int)2, (int)newComposite.numComponents());
        Assertions.assertEquals((int)6, (int)newComposite.capacity());
        Assertions.assertEquals((int)6, (int)newComposite.writerIndex());
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer().writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readRetainedSlice(2);
        ByteBuf s2 = s1.retainedSlice(0, 2);
        ByteBuf s3 = buffer.slice(0, 2).retain();
        ByteBuf s4 = s2.retainedSlice(0, 2);
        buffer.release();
        CompositeByteBuf compositeToAdd = Unpooled.compositeBuffer().addComponent(s1).addComponent(Unpooled.EMPTY_BUFFER).addComponents(new ByteBuf[]{s2, s3, s4});
        compositeToAdd.setIndex(1, 5);
        Assertions.assertEquals((int)1, (int)compositeToAdd.refCnt());
        Assertions.assertEquals((int)1, (int)s4.refCnt());
        ByteBuf compositeCopy = compositeToAdd.copy();
        if (addWrapped) {
            compositeToAdd = new WrappedCompositeByteBuf(compositeToAdd);
        }
        newComposite.addFlattenedComponents(true, (ByteBuf)compositeToAdd);
        ByteBufUtil.equals((ByteBuf)compositeCopy, (int)0, (ByteBuf)newComposite, (int)6, (int)compositeCopy.readableBytes());
        Assertions.assertEquals((int)5, (int)newComposite.numComponents());
        Assertions.assertEquals((int)10, (int)newComposite.capacity());
        Assertions.assertEquals((int)10, (int)newComposite.writerIndex());
        Assertions.assertEquals((int)0, (int)compositeToAdd.refCnt());
        Assertions.assertEquals((int)0, (int)s4.refCnt());
        Assertions.assertEquals((int)1, (int)newComposite.refCnt());
        newComposite.release();
        Assertions.assertEquals((int)0, (int)newComposite.refCnt());
        Assertions.assertEquals((int)0, (int)s1.refCnt());
        Assertions.assertEquals((int)0, (int)s2.refCnt());
        Assertions.assertEquals((int)0, (int)s3.refCnt());
        Assertions.assertEquals((int)0, (int)b1.refCnt());
    }

    @Test
    public void testIterator() {
        CompositeByteBuf cbuf = this.newCompositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Iterator it = cbuf.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)Unpooled.EMPTY_BUFFER, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)Unpooled.EMPTY_BUFFER, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        cbuf.release();
    }

    @Test
    public void testEmptyIterator() {
        CompositeByteBuf cbuf = this.newCompositeBuffer();
        Iterator it = cbuf.iterator();
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        cbuf.release();
    }

    @Test
    public void testIteratorConcurrentModificationAdd() {
        CompositeByteBuf cbuf = this.newCompositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        final Iterator it = cbuf.iterator();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Assertions.assertTrue((boolean)it.hasNext());
        try {
            Assertions.assertThrows(ConcurrentModificationException.class, (Executable)new Executable(){

                public void execute() {
                    it.next();
                }
            });
        }
        finally {
            cbuf.release();
        }
    }

    @Test
    public void testIteratorConcurrentModificationRemove() {
        CompositeByteBuf cbuf = this.newCompositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        final Iterator it = cbuf.iterator();
        cbuf.removeComponent(0);
        Assertions.assertTrue((boolean)it.hasNext());
        try {
            Assertions.assertThrows(ConcurrentModificationException.class, (Executable)new Executable(){

                public void execute() {
                    it.next();
                }
            });
        }
        finally {
            cbuf.release();
        }
    }

    @Test
    public void testReleasesItsComponents() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readSlice(2).retain();
        ByteBuf s2 = s1.readSlice(2).retain();
        ByteBuf s3 = s2.readSlice(2).retain();
        ByteBuf s4 = s3.readSlice(2).retain();
        ByteBuf composite = PooledByteBufAllocator.DEFAULT.compositeBuffer().addComponent(s1).addComponents(new ByteBuf[]{s2, s3, s4}).order(ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((int)1, (int)composite.refCnt());
        Assertions.assertEquals((int)5, (int)buffer.refCnt());
        ReferenceCountUtil.release((Object)composite);
        Assertions.assertEquals((int)0, (int)composite.refCnt());
        Assertions.assertEquals((int)1, (int)buffer.refCnt());
        ReferenceCountUtil.release((Object)buffer);
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }

    @Test
    public void testReleasesItsComponents2() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readRetainedSlice(2);
        ByteBuf s2 = s1.readRetainedSlice(2);
        ByteBuf s3 = s2.readRetainedSlice(2);
        ByteBuf s4 = s3.readRetainedSlice(2);
        ByteBuf composite = this.newCompositeBuffer().addComponent(s1).addComponents(new ByteBuf[]{s2, s3, s4}).order(ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((int)1, (int)composite.refCnt());
        Assertions.assertEquals((int)2, (int)buffer.refCnt());
        composite.release();
        Assertions.assertEquals((int)0, (int)composite.refCnt());
        Assertions.assertEquals((int)1, (int)buffer.refCnt());
        buffer.release();
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }

    @Test
    public void testReleasesOnShrink() {
        ByteBuf b1 = Unpooled.buffer((int)2).writeShort(1);
        ByteBuf b2 = Unpooled.buffer((int)2).writeShort(2);
        CompositeByteBuf composite = this.newCompositeBuffer().addComponents(new ByteBuf[]{b1, b2});
        Assertions.assertEquals((int)4, (int)composite.capacity());
        composite.capacity(2);
        Assertions.assertEquals((int)2, (int)composite.capacity());
        composite.release();
        Assertions.assertEquals((int)0, (int)composite.refCnt());
        Assertions.assertEquals((int)0, (int)b1.refCnt());
        Assertions.assertEquals((int)0, (int)b2.refCnt());
    }

    @Test
    public void testReleasesOnShrink2() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeShort(1).writeShort(2);
        ByteBuf b1 = buffer.readRetainedSlice(2);
        ByteBuf b2 = b1.retainedSlice(b1.readerIndex(), 2);
        CompositeByteBuf composite = this.newCompositeBuffer().addComponents(new ByteBuf[]{b1, b2});
        Assertions.assertEquals((int)4, (int)composite.capacity());
        composite.capacity(2);
        Assertions.assertEquals((int)2, (int)composite.capacity());
        composite.release();
        Assertions.assertEquals((int)0, (int)composite.refCnt());
        Assertions.assertEquals((int)0, (int)b1.refCnt());
        Assertions.assertEquals((int)0, (int)b2.refCnt());
        buffer.release();
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }

    @Test
    public void testAllocatorIsSameWhenCopy() {
        this.testAllocatorIsSameWhenCopy(false);
    }

    @Test
    public void testAllocatorIsSameWhenCopyUsingIndexAndLength() {
        this.testAllocatorIsSameWhenCopy(true);
    }

    private void testAllocatorIsSameWhenCopy(boolean withIndexAndLength) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeZero(4);
        ByteBuf copy = withIndexAndLength ? buffer.copy(0, 4) : buffer.copy();
        Assertions.assertEquals((Object)buffer, (Object)copy);
        Assertions.assertEquals((Object)buffer.isDirect(), (Object)copy.isDirect());
        Assertions.assertSame((Object)buffer.alloc(), (Object)copy.alloc());
        buffer.release();
        copy.release();
    }

    @Test
    public void testDecomposeMultiple() {
        this.testDecompose(150, 500, 3);
    }

    @Test
    public void testDecomposeOne() {
        this.testDecompose(310, 50, 1);
    }

    @Test
    public void testDecomposeNone() {
        this.testDecompose(310, 0, 0);
    }

    private void testDecompose(int offset, int length, int expectedListSize) {
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        CompositeByteBuf composite = this.newCompositeBuffer();
        composite.addComponents(true, new ByteBuf[]{buf.retainedSlice(100, 200), buf.retainedSlice(300, 400), buf.retainedSlice(700, 100)});
        ByteBuf slice = composite.slice(offset, length);
        List bufferList = composite.decompose(offset, length);
        Assertions.assertEquals((int)expectedListSize, (int)bufferList.size());
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuf[])bufferList.toArray(new ByteBuf[0]));
        Assertions.assertEquals((Object)slice, (Object)wrapped);
        composite.release();
        buf.release();
        for (ByteBuf buffer : bufferList) {
            Assertions.assertEquals((int)0, (int)buffer.refCnt());
        }
    }

    @Test
    public void testDecomposeReturnNonUnwrappedBuffer() {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(1024);
        buf.writeZero(1024);
        ByteBuf sliced = buf.retainedSlice(100, 200);
        sliced.retain();
        Assertions.assertEquals((int)2, (int)sliced.refCnt());
        CompositeByteBuf composite = this.newCompositeBuffer();
        composite.addComponents(true, new ByteBuf[]{sliced});
        List bufferList = composite.decompose(0, 100);
        Assertions.assertEquals((int)1, (int)bufferList.size());
        ByteBuf decomposed = (ByteBuf)bufferList.get(0);
        Assertions.assertSame((Object)sliced.refCnt(), (Object)decomposed.refCnt());
        decomposed.release();
        Assertions.assertSame((Object)sliced.refCnt(), (Object)decomposed.refCnt());
        composite.release();
        buf.release();
        for (ByteBuf buffer : bufferList) {
            Assertions.assertEquals((int)0, (int)buffer.refCnt());
        }
    }

    @Test
    public void testDecomposeReturnNonUnwrappedBuffers() {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(1024);
        buf.writeZero(1024);
        ByteBuf sliced = buf.retainedSlice(100, 200);
        ByteBuf sliced2 = buf.retainedSlice(400, 100);
        sliced.retain();
        sliced2.retain();
        Assertions.assertEquals((int)2, (int)sliced.refCnt());
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponents(true, new ByteBuf[]{sliced});
        composite.addComponents(true, new ByteBuf[]{sliced2});
        List bufferList = composite.decompose(100, 150);
        Assertions.assertEquals((int)2, (int)bufferList.size());
        ByteBuf decomposed = (ByteBuf)bufferList.get(0);
        ByteBuf decomposed2 = (ByteBuf)bufferList.get(1);
        Assertions.assertSame((Object)sliced.refCnt(), (Object)decomposed.refCnt());
        decomposed.release();
        decomposed2.release();
        Assertions.assertSame((Object)sliced.refCnt(), (Object)decomposed.refCnt());
        Assertions.assertSame((Object)sliced2.refCnt(), (Object)decomposed2.refCnt());
        composite.release();
        buf.release();
        for (ByteBuf buffer : bufferList) {
            Assertions.assertEquals((int)0, (int)buffer.refCnt());
        }
    }

    @Test
    public void testComponentsLessThanLowerBound() {
        try {
            new CompositeByteBuf(ALLOC, true, 0);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"maxNumComponents: 0 (expected: >= 1)", (Object)e.getMessage());
        }
    }

    @Test
    public void testComponentsEqualToLowerBound() {
        AbstractCompositeByteBufTest.assertCompositeBufCreated(1);
    }

    @Test
    public void testComponentsGreaterThanLowerBound() {
        AbstractCompositeByteBufTest.assertCompositeBufCreated(5);
    }

    private static void assertCompositeBufCreated(int expectedMaxComponents) {
        CompositeByteBuf buf = new CompositeByteBuf(ALLOC, true, expectedMaxComponents);
        Assertions.assertEquals((int)expectedMaxComponents, (int)buf.maxNumComponents());
        Assertions.assertTrue((boolean)buf.release());
    }

    @Test
    public void testDiscardSomeReadBytesCorrectlyUpdatesLastAccessed() {
        this.testDiscardCorrectlyUpdatesLastAccessed(true);
    }

    @Test
    public void testDiscardReadBytesCorrectlyUpdatesLastAccessed() {
        this.testDiscardCorrectlyUpdatesLastAccessed(false);
    }

    private void testDiscardCorrectlyUpdatesLastAccessed(boolean discardSome) {
        CompositeByteBuf cbuf = this.newCompositeBuffer();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(4);
        for (int i = 0; i < 4; ++i) {
            ByteBuf buf = Unpooled.buffer().writeInt(i);
            cbuf.addComponent(true, buf);
            buffers.add(buf);
        }
        cbuf.skipBytes(2);
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assertions.assertEquals((int)4, (int)cbuf.numComponents());
        cbuf.skipBytes(3);
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assertions.assertEquals((int)3, (int)cbuf.numComponents());
        cbuf.skipBytes(3);
        Assertions.assertEquals((int)2, (int)cbuf.readInt());
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assertions.assertEquals((int)1, (int)cbuf.numComponents());
        Assertions.assertEquals((int)3, (int)cbuf.readInt());
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assertions.assertEquals((int)0, (int)cbuf.numComponents());
        for (ByteBuf buffer : buffers) {
            Assertions.assertEquals((int)0, (int)buffer.refCnt());
        }
        Assertions.assertTrue((boolean)cbuf.release());
    }

    @Test
    public void testAddComponentWithNullEntry() {
        ByteBuf buffer = Unpooled.buffer((int)8).writeZero(8);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            compositeByteBuf.addComponents(true, new ByteBuf[]{buffer, null});
            Assertions.assertEquals((int)8, (int)compositeByteBuf.readableBytes());
            Assertions.assertEquals((int)1, (int)compositeByteBuf.numComponents());
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverflowWhileAddingComponent() {
        int capacity = 0x100000;
        final ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        final CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                        ByteBuf duplicate = buffer.duplicate();
                        compositeByteBuf.addComponent(duplicate);
                        duplicate.retain();
                    }
                }
            });
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverflowWhileAddingComponentsViaVarargs() {
        int capacity = 0x100000;
        final ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        final CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                        ByteBuf duplicate = buffer.duplicate();
                        compositeByteBuf.addComponents(new ByteBuf[]{duplicate});
                        duplicate.retain();
                    }
                }
            });
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverflowWhileAddingComponentsViaIterable() {
        int capacity = 0x100000;
        final ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        final CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                        ByteBuf duplicate = buffer.duplicate();
                        compositeByteBuf.addComponents(Collections.singletonList(duplicate));
                        duplicate.retain();
                    }
                }
            });
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverflowWhileUseConstructorWithOffset() {
        int capacity = 0x100000;
        ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        final ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
        for (long i = 0L; i <= Integer.MAX_VALUE; i += (long)capacity) {
            buffers.add(buffer.duplicate());
        }
        buffers.add(buffer.duplicate());
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    ByteBuf[] bufferArray = buffers.toArray(new ByteBuf[0]);
                    new CompositeByteBuf(ALLOC, false, Integer.MAX_VALUE, bufferArray, 0);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testNotOverflowWhileUseConstructorWithOffset() {
        int capacity = 0x100000;
        ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
        for (long i = 0L; i <= Integer.MAX_VALUE; i += (long)capacity) {
            buffers.add(buffer.duplicate());
        }
        buffers.add(buffer.duplicate());
        ByteBuf[] bufferArray = buffers.toArray(new ByteBuf[0]);
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(ALLOC, false, Integer.MAX_VALUE, bufferArray, bufferArray.length - 1);
        compositeByteBuf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sliceOfCompositeBufferMustThrowISEAfterDiscardBytes() {
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponent(true, Unpooled.buffer((int)8).writeZero(8));
        ByteBuf slice = composite.retainedSlice();
        composite.skipBytes(slice.readableBytes());
        composite.discardSomeReadBytes();
        try {
            slice.readByte();
            Assertions.fail((String)"Expected readByte of discarded slice to throw.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            slice.release();
            composite.release();
        }
    }

    @Test
    public void forEachByteOnNestedCompositeByteBufMustSeeEntireFlattenedContents() {
        CompositeByteBuf buf = this.newCompositeBuffer();
        buf.addComponent(true, (ByteBuf)this.newCompositeBuffer().addComponents(true, new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6})}));
        final byte[] arrayAsc = new byte[6];
        final byte[] arrayDesc = new byte[6];
        buf.forEachByte(new ByteProcessor(){
            int index;

            public boolean process(byte value) throws Exception {
                arrayAsc[this.index++] = value;
                return true;
            }
        });
        buf.forEachByteDesc(new ByteProcessor(){
            int index;

            public boolean process(byte value) throws Exception {
                arrayDesc[this.index++] = value;
                return true;
            }
        });
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (byte[])arrayAsc);
        Assertions.assertArrayEquals((byte[])new byte[]{6, 5, 4, 3, 2, 1}, (byte[])arrayDesc);
        buf.release();
    }
}

