/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ReadOnlyByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class ReadOnlyByteBufTest {
    @Test
    public void shouldNotAllowNullInConstructor() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new ReadOnlyByteBuf(null);
            }
        });
    }

    @Test
    public void testUnmodifiableBuffer() {
        Assertions.assertThat((Comparable)Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1))).isInstanceOf(ReadOnlyByteBuf.class);
    }

    @Test
    public void testUnwrap() {
        ByteBuf buf = Unpooled.buffer((int)1);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).unwrap());
    }

    @Test
    public void shouldHaveSameByteOrder() {
        ByteBuf buf = Unpooled.buffer((int)1);
        org.junit.jupiter.api.Assertions.assertSame((Object)Unpooled.BIG_ENDIAN, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).order());
        buf = buf.order(Unpooled.LITTLE_ENDIAN);
        org.junit.jupiter.api.Assertions.assertSame((Object)Unpooled.LITTLE_ENDIAN, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).order());
    }

    @Test
    public void shouldReturnReadOnlyDerivedBuffer() {
        ByteBuf buf = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1));
        Assertions.assertThat((Comparable)buf.duplicate()).isInstanceOf(ReadOnlyByteBuf.class);
        Assertions.assertThat((Comparable)buf.slice()).isInstanceOf(ReadOnlyByteBuf.class);
        Assertions.assertThat((Comparable)buf.slice(0, 1)).isInstanceOf(ReadOnlyByteBuf.class);
        Assertions.assertThat((Comparable)buf.duplicate()).isInstanceOf(ReadOnlyByteBuf.class);
    }

    @Test
    public void shouldReturnWritableCopy() {
        ByteBuf buf = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1));
        Assertions.assertThat((Comparable)buf.copy()).isNotInstanceOf(ReadOnlyByteBuf.class);
    }

    @Test
    public void shouldForwardReadCallsBlindly() throws Exception {
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.order()).thenReturn((Object)Unpooled.BIG_ENDIAN);
        Mockito.when((Object)buf.maxCapacity()).thenReturn((Object)65536);
        Mockito.when((Object)buf.readerIndex()).thenReturn((Object)0);
        Mockito.when((Object)buf.writerIndex()).thenReturn((Object)0);
        Mockito.when((Object)buf.capacity()).thenReturn((Object)0);
        Mockito.when((Object)buf.getBytes(1, (GatheringByteChannel)null, 2)).thenReturn((Object)3);
        Mockito.when((Object)buf.getBytes(4, (OutputStream)null, 5)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(6, (byte[])null, 7, 8)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(9, (ByteBuf)null, 10, 11)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(12, (ByteBuffer)null)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getByte(13)).thenReturn((Object)14);
        Mockito.when((Object)buf.getShort(15)).thenReturn((Object)16);
        Mockito.when((Object)buf.getUnsignedMedium(17)).thenReturn((Object)18);
        Mockito.when((Object)buf.getInt(19)).thenReturn((Object)20);
        Mockito.when((Object)buf.getLong(21)).thenReturn((Object)22L);
        ByteBuffer bb = ByteBuffer.allocate(100);
        Mockito.when((Object)buf.nioBuffer(23, 24)).thenReturn((Object)bb);
        Mockito.when((Object)buf.capacity()).thenReturn((Object)27);
        ByteBuf roBuf = Unpooled.unmodifiableBuffer((ByteBuf)buf);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)roBuf.getBytes(1, (GatheringByteChannel)null, 2));
        roBuf.getBytes(4, (OutputStream)null, 5);
        roBuf.getBytes(6, (byte[])null, 7, 8);
        roBuf.getBytes(9, (ByteBuf)null, 10, 11);
        roBuf.getBytes(12, (ByteBuffer)null);
        org.junit.jupiter.api.Assertions.assertEquals((byte)14, (byte)roBuf.getByte(13));
        org.junit.jupiter.api.Assertions.assertEquals((short)16, (short)roBuf.getShort(15));
        org.junit.jupiter.api.Assertions.assertEquals((int)18, (int)roBuf.getUnsignedMedium(17));
        org.junit.jupiter.api.Assertions.assertEquals((int)20, (int)roBuf.getInt(19));
        org.junit.jupiter.api.Assertions.assertEquals((long)22L, (long)roBuf.getLong(21));
        ByteBuffer roBB = roBuf.nioBuffer(23, 24);
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)roBB.capacity());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)roBB.isReadOnly());
        org.junit.jupiter.api.Assertions.assertEquals((int)27, (int)roBuf.capacity());
    }

    @Test
    public void shouldRejectDiscardReadBytes() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).discardReadBytes();
            }
        });
    }

    @Test
    public void shouldRejectSetByte() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setByte(0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetShort() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setShort(0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetMedium() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setMedium(0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetInt() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setInt(0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetLong() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setLong(0, 0L);
            }
        });
    }

    @Test
    public void shouldRejectSetBytes1() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (InputStream)null, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetBytes2() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ScatteringByteChannel)null, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetBytes3() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (byte[])null, 0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetBytes4() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ByteBuf)null, 0, 0);
            }
        });
    }

    @Test
    public void shouldRejectSetBytes5() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ByteBuffer)null);
            }
        });
    }

    @Test
    public void shouldIndicateNotWritable() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1)).isWritable());
    }

    @Test
    public void shouldIndicateNotWritableAnyNumber() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1)).isWritable(1));
    }

    @Test
    public void ensureWritableIntStatusShouldFailButNotThrow() {
        ReadOnlyByteBufTest.ensureWritableIntStatusShouldFailButNotThrow(false);
    }

    @Test
    public void ensureWritableForceIntStatusShouldFailButNotThrow() {
        ReadOnlyByteBufTest.ensureWritableIntStatusShouldFailButNotThrow(true);
    }

    private static void ensureWritableIntStatusShouldFailButNotThrow(boolean force) {
        ByteBuf buf = Unpooled.buffer((int)1);
        ByteBuf readOnly = buf.asReadOnly();
        int result = readOnly.ensureWritable(1, force);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ByteBufUtil.ensureWritableSuccess((int)result));
        readOnly.release();
    }

    @Test
    public void ensureWritableShouldThrow() {
        ByteBuf buf = Unpooled.buffer((int)1);
        final ByteBuf readOnly = buf.asReadOnly();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    readOnly.ensureWritable(1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void asReadOnly() {
        ByteBuf buf = Unpooled.buffer((int)1);
        ByteBuf readOnly = buf.asReadOnly();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readOnly.isReadOnly());
        org.junit.jupiter.api.Assertions.assertSame((Object)readOnly, (Object)readOnly.asReadOnly());
        readOnly.release();
    }
}

