/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsMessage;
import io.netty.handler.codec.dns.DnsQueryHeader;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResource;
import java.net.InetSocketAddress;

public class DnsQuery
extends DnsMessage {
    private final InetSocketAddress recipient;

    public DnsQuery(int id, InetSocketAddress recipient) {
        super(id);
        if (recipient == null) {
            throw new NullPointerException("recipient");
        }
        this.recipient = recipient;
    }

    public InetSocketAddress recipient() {
        return this.recipient;
    }

    @Override
    public DnsQuery addAnswer(DnsResource answer) {
        super.addAnswer(answer);
        return this;
    }

    @Override
    public DnsQuery addQuestion(DnsQuestion question) {
        super.addQuestion(question);
        return this;
    }

    @Override
    public DnsQuery addAuthorityResource(DnsResource resource) {
        super.addAuthorityResource(resource);
        return this;
    }

    @Override
    public DnsQuery addAdditionalResource(DnsResource resource) {
        super.addAdditionalResource(resource);
        return this;
    }

    @Override
    public DnsQuery touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public DnsQuery retain() {
        super.retain();
        return this;
    }

    @Override
    public DnsQuery retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public DnsQuery touch() {
        super.touch();
        return this;
    }

    @Override
    public DnsQueryHeader header() {
        return (DnsQueryHeader)super.header();
    }

    @Override
    protected DnsQueryHeader newHeader(int id) {
        return new DnsQueryHeader(this, id);
    }
}

