/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.AbstractDnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class AbstractDnsRecordTest {
    @Test
    public void testValidDomainName() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assertions.assertEquals((Object)(name + '.'), (Object)record.name());
    }

    @Test
    public void testValidDomainNameUmlaut() {
        String name = "\u00e4";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assertions.assertEquals((Object)"xn--4ca.", (Object)record.name());
    }

    @Test
    public void testValidDomainNameTrailingDot() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assertions.assertEquals((Object)name, (Object)record.name());
    }

    @Test
    public void testValidDomainNameUmlautTrailingDot() {
        String name = "\u00e4.";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assertions.assertEquals((Object)"xn--4ca.", (Object)record.name());
    }

    @Test
    public void testValidDomainNameLength() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new AbstractDnsRecord("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", DnsRecordType.A, 0L){};
            }
        });
    }

    @Test
    public void testValidDomainNameUmlautLength() {
        String name = "\u00e4aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new AbstractDnsRecord("\u00e4aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", DnsRecordType.A, 0L){};
            }
        });
    }
}

