/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsCodecUtil;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDnsRecordDecoderTest {
    @Test
    public void testDecodeName() {
        DefaultDnsRecordDecoderTest.testDecodeName("netty.io.", Unpooled.wrappedBuffer((byte[])new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}));
    }

    @Test
    public void testDecodeNameWithoutTerminator() {
        DefaultDnsRecordDecoderTest.testDecodeName("netty.io.", Unpooled.wrappedBuffer((byte[])new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111}));
    }

    @Test
    public void testDecodeNameWithExtraTerminator() {
        DefaultDnsRecordDecoderTest.testDecodeName("netty.io.", Unpooled.wrappedBuffer((byte[])new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0, 0}));
    }

    @Test
    public void testDecodeEmptyName() {
        DefaultDnsRecordDecoderTest.testDecodeName(".", Unpooled.buffer().writeByte(0));
    }

    @Test
    public void testDecodeEmptyNameFromEmptyBuffer() {
        DefaultDnsRecordDecoderTest.testDecodeName(".", Unpooled.EMPTY_BUFFER);
    }

    @Test
    public void testDecodeEmptyNameFromExtraZeroes() {
        DefaultDnsRecordDecoderTest.testDecodeName(".", Unpooled.wrappedBuffer((byte[])new byte[]{0, 0}));
    }

    private static void testDecodeName(String expected, ByteBuf buffer) {
        try {
            DefaultDnsRecordDecoder decoder = new DefaultDnsRecordDecoder();
            Assertions.assertEquals((Object)expected, (Object)decoder.decodeName0(buffer));
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodePtrRecord() throws Exception {
        DefaultDnsRecordDecoder decoder = new DefaultDnsRecordDecoder();
        ByteBuf buffer = Unpooled.buffer().writeByte(0);
        int readerIndex = buffer.readerIndex();
        int writerIndex = buffer.writerIndex();
        try {
            DnsPtrRecord record = (DnsPtrRecord)decoder.decodeRecord("netty.io", DnsRecordType.PTR, 1, 60L, buffer, 0, 1);
            Assertions.assertEquals((Object)"netty.io.", (Object)record.name());
            Assertions.assertEquals((int)1, (int)record.dnsClass());
            Assertions.assertEquals((long)60L, (long)record.timeToLive());
            Assertions.assertEquals((Object)DnsRecordType.PTR, (Object)record.type());
            Assertions.assertEquals((int)readerIndex, (int)buffer.readerIndex());
            Assertions.assertEquals((int)writerIndex, (int)buffer.writerIndex());
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testdecompressCompressPointer() {
        byte[] compressionPointer = new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0, -64, 0};
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])compressionPointer);
        ByteBuf uncompressed = null;
        try {
            uncompressed = DnsCodecUtil.decompressDomainName((ByteBuf)buffer.duplicate().setIndex(10, 12));
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)buffer.duplicate().setIndex(0, 10), (ByteBuf)uncompressed));
        }
        finally {
            buffer.release();
            if (uncompressed != null) {
                uncompressed.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testdecompressNestedCompressionPointer() {
        byte[] nestedCompressionPointer = new byte[]{6, 103, 105, 116, 104, 117, 98, 2, 105, 111, 0, 5, 110, 101, 116, 116, 121, -64, 0, -64, 11};
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])nestedCompressionPointer);
        ByteBuf uncompressed = null;
        try {
            uncompressed = DnsCodecUtil.decompressDomainName((ByteBuf)buffer.duplicate().setIndex(19, 21));
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{5, 110, 101, 116, 116, 121, 6, 103, 105, 116, 104, 117, 98, 2, 105, 111, 0}), (ByteBuf)uncompressed));
        }
        finally {
            buffer.release();
            if (uncompressed != null) {
                uncompressed.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeCompressionRDataPointer() throws Exception {
        DefaultDnsRecordDecoder decoder = new DefaultDnsRecordDecoder();
        byte[] compressionPointer = new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0, -64, 0};
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])compressionPointer);
        DefaultDnsRawRecord cnameRecord = null;
        DefaultDnsRawRecord nsRecord = null;
        try {
            cnameRecord = (DefaultDnsRawRecord)decoder.decodeRecord("netty.github.io", DnsRecordType.CNAME, 1, 60L, buffer, 10, 2);
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)buffer.duplicate().setIndex(0, 10), (ByteBuf)cnameRecord.content()), (String)"The rdata of CNAME-type record should be decompressed in advance");
            Assertions.assertEquals((Object)"netty.io.", (Object)DnsCodecUtil.decodeDomainName((ByteBuf)cnameRecord.content()));
            nsRecord = (DefaultDnsRawRecord)decoder.decodeRecord("netty.github.io", DnsRecordType.NS, 1, 60L, buffer, 10, 2);
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)buffer.duplicate().setIndex(0, 10), (ByteBuf)nsRecord.content()), (String)"The rdata of NS-type record should be decompressed in advance");
            Assertions.assertEquals((Object)"netty.io.", (Object)DnsCodecUtil.decodeDomainName((ByteBuf)nsRecord.content()));
        }
        finally {
            buffer.release();
            if (cnameRecord != null) {
                cnameRecord.release();
            }
            if (nsRecord != null) {
                nsRecord.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeMessageCompression() throws Exception {
        DefaultDnsRecordDecoder decoder = new DefaultDnsRecordDecoder();
        byte[] rfcExample = new byte[]{1, 70, 3, 73, 83, 73, 4, 65, 82, 80, 65, 0, 3, 70, 79, 79, -64, 0, -64, 6};
        DefaultDnsRawRecord rawPlainRecord = null;
        DefaultDnsRawRecord rawUncompressedRecord = null;
        DefaultDnsRawRecord rawUncompressedIndexedRecord = null;
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])rfcExample);
        try {
            String plainName = DefaultDnsRecordDecoder.decodeName((ByteBuf)buffer.duplicate());
            Assertions.assertEquals((Object)"F.ISI.ARPA.", (Object)plainName);
            String uncompressedPlainName = DefaultDnsRecordDecoder.decodeName((ByteBuf)buffer.duplicate().setIndex(16, 20));
            Assertions.assertEquals((Object)plainName, (Object)uncompressedPlainName);
            String uncompressedIndexedName = DefaultDnsRecordDecoder.decodeName((ByteBuf)buffer.duplicate().setIndex(12, 20));
            Assertions.assertEquals((Object)("FOO." + plainName), (Object)uncompressedIndexedName);
            rawPlainRecord = (DefaultDnsRawRecord)decoder.decodeRecord(plainName, DnsRecordType.CNAME, 1, 60L, buffer, 0, 11);
            Assertions.assertEquals((Object)plainName, (Object)rawPlainRecord.name());
            Assertions.assertEquals((Object)plainName, (Object)DefaultDnsRecordDecoder.decodeName((ByteBuf)rawPlainRecord.content()));
            rawUncompressedRecord = (DefaultDnsRawRecord)decoder.decodeRecord(uncompressedPlainName, DnsRecordType.CNAME, 1, 60L, buffer, 16, 4);
            Assertions.assertEquals((Object)uncompressedPlainName, (Object)rawUncompressedRecord.name());
            Assertions.assertEquals((Object)uncompressedPlainName, (Object)DefaultDnsRecordDecoder.decodeName((ByteBuf)rawUncompressedRecord.content()));
            rawUncompressedIndexedRecord = (DefaultDnsRawRecord)decoder.decodeRecord(uncompressedIndexedName, DnsRecordType.CNAME, 1, 60L, buffer, 12, 8);
            Assertions.assertEquals((Object)uncompressedIndexedName, (Object)rawUncompressedIndexedRecord.name());
            Assertions.assertEquals((Object)uncompressedIndexedName, (Object)DefaultDnsRecordDecoder.decodeName((ByteBuf)rawUncompressedIndexedRecord.content()));
            DnsPtrRecord ptrRecord = (DnsPtrRecord)decoder.decodeRecord(plainName, DnsRecordType.PTR, 1, 60L, buffer, 0, 11);
            Assertions.assertEquals((Object)plainName, (Object)ptrRecord.name());
            Assertions.assertEquals((Object)plainName, (Object)ptrRecord.hostname());
            ptrRecord = (DnsPtrRecord)decoder.decodeRecord(uncompressedPlainName, DnsRecordType.PTR, 1, 60L, buffer, 16, 4);
            Assertions.assertEquals((Object)uncompressedPlainName, (Object)ptrRecord.name());
            Assertions.assertEquals((Object)uncompressedPlainName, (Object)ptrRecord.hostname());
            ptrRecord = (DnsPtrRecord)decoder.decodeRecord(uncompressedIndexedName, DnsRecordType.PTR, 1, 60L, buffer, 12, 8);
            Assertions.assertEquals((Object)uncompressedIndexedName, (Object)ptrRecord.name());
            Assertions.assertEquals((Object)uncompressedIndexedName, (Object)ptrRecord.hostname());
        }
        finally {
            if (rawPlainRecord != null) {
                rawPlainRecord.release();
            }
            if (rawUncompressedRecord != null) {
                rawUncompressedRecord.release();
            }
            if (rawUncompressedIndexedRecord != null) {
                rawUncompressedIndexedRecord.release();
            }
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncatedPacket() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeByte(0);
        buffer.writeShort(DnsRecordType.A.intValue());
        buffer.writeShort(1);
        buffer.writeInt(32);
        buffer.writeByte(0);
        DefaultDnsRecordDecoder decoder = new DefaultDnsRecordDecoder();
        try {
            int readerIndex = buffer.readerIndex();
            Assertions.assertNull((Object)decoder.decodeRecord(buffer));
            Assertions.assertEquals((int)readerIndex, (int)buffer.readerIndex());
        }
        finally {
            buffer.release();
        }
    }
}

