/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpCodecUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpTransferEncoding;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpMessage
implements HttpMessage {
    private final HttpHeaders headers = new HttpHeaders();
    private HttpVersion version;
    private ByteBuf content = Unpooled.EMPTY_BUFFER;
    private HttpTransferEncoding te = HttpTransferEncoding.SINGLE;

    protected DefaultHttpMessage(HttpVersion version) {
        this.setProtocolVersion(version);
    }

    @Override
    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.setHeader(name, value);
    }

    @Override
    public void setHeader(String name, Iterable<?> values) {
        this.headers.setHeader(name, values);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.removeHeader(name);
    }

    @Override
    public HttpTransferEncoding getTransferEncoding() {
        return this.te;
    }

    @Override
    public void setTransferEncoding(HttpTransferEncoding te) {
        if (te == null) {
            throw new NullPointerException("te (transferEncoding)");
        }
        this.te = te;
        switch (te) {
            case SINGLE: {
                HttpCodecUtil.removeTransferEncodingChunked(this);
                break;
            }
            case STREAMED: {
                HttpCodecUtil.removeTransferEncodingChunked(this);
                this.setContent(Unpooled.EMPTY_BUFFER);
                break;
            }
            case CHUNKED: {
                if (!HttpCodecUtil.isTransferEncodingChunked(this)) {
                    this.addHeader("Transfer-Encoding", "chunked");
                }
                this.removeHeader("Content-Length");
                this.setContent(Unpooled.EMPTY_BUFFER);
            }
        }
    }

    @Override
    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    @Override
    public void setContent(ByteBuf content) {
        if (content == null) {
            content = Unpooled.EMPTY_BUFFER;
        }
        if (!this.getTransferEncoding().isSingle() && content.readable()) {
            throw new IllegalArgumentException("non-empty content disallowed if this.transferEncoding != SINGLE");
        }
        this.content = content;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    @Override
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setProtocolVersion(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    @Override
    public ByteBuf getContent() {
        if (this.getTransferEncoding() == HttpTransferEncoding.SINGLE) {
            return this.content;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(", keepAlive: ");
        buf.append(HttpHeaders.isKeepAlive(this));
        buf.append(", transferEncoding: ");
        buf.append((Object)this.getTransferEncoding());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.getHeaders()) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

