/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.DefaultSpdyHeaderBlock;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyHeadersFrame
extends DefaultSpdyHeaderBlock
implements SpdyHeadersFrame {
    private int streamId;
    private boolean last;

    public DefaultSpdyHeadersFrame(int streamId) {
        this.setStreamId(streamId);
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public void setStreamId(int streamId) {
        if (streamId <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamId);
        }
        this.streamId = streamId;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamId);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }
}

