/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public class ContinuationWebSocketFrame
extends WebSocketFrame {
    private String aggregatedText;

    public ContinuationWebSocketFrame() {
        this.setBinaryData(Unpooled.EMPTY_BUFFER);
    }

    public ContinuationWebSocketFrame(ByteBuf binaryData) {
        this.setBinaryData(binaryData);
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData, String aggregatedText) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
        this.aggregatedText = aggregatedText;
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, String text) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setText(text);
    }

    public String getText() {
        if (this.getBinaryData() == null) {
            return null;
        }
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.setBinaryData(Unpooled.EMPTY_BUFFER);
        } else {
            this.setBinaryData(Unpooled.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(data: " + this.getBinaryData() + ')';
    }

    public String getAggregatedText() {
        return this.aggregatedText;
    }

    public void setAggregatedText(String aggregatedText) {
        this.aggregatedText = aggregatedText;
    }
}

