/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import java.util.LinkedList;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<HttpRequest, HttpRequest, HttpResponse, HttpResponse> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new LinkedList<Integer>();

    public SpdyHttpResponseStreamIdHandler() {
        super(new Class[]{HttpRequest.class}, new Class[]{HttpResponse.class});
    }

    public HttpResponse encode(ChannelHandlerContext ctx, HttpResponse msg) throws Exception {
        boolean contains = msg.containsHeader("X-SPDY-Stream-ID");
        if (!contains) {
            this.ids.add(NO_ID);
        } else {
            this.ids.add(SpdyHttpHeaders.getStreamId(msg));
        }
        return msg;
    }

    public HttpRequest decode(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
        Integer id = this.ids.poll();
        if (id != null && id != NO_ID && !msg.containsHeader("X-SPDY-Stream-ID")) {
            SpdyHttpHeaders.setStreamId(msg, id);
        }
        return msg;
    }
}

