/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpTransferEncoding;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Map;

public class HttpChunkAggregator
extends MessageToMessageDecoder<HttpObject, HttpMessage> {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final ByteBuf CONTINUE = Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 100 Continue\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private final int maxContentLength;
    private HttpMessage currentMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;

    public HttpChunkAggregator(int maxContentLength) {
        super(new Class[]{HttpObject.class});
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    public HttpMessage decode(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        HttpMessage currentMessage = this.currentMessage;
        if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            if (HttpHeaders.is100ContinueExpected(m)) {
                ctx.write((Object)CONTINUE.duplicate());
            }
            if (!m.getDecoderResult().isSuccess()) {
                m.setTransferEncoding(HttpTransferEncoding.SINGLE);
                this.currentMessage = null;
                return m;
            }
            switch (m.getTransferEncoding()) {
                case SINGLE: {
                    this.currentMessage = null;
                    return m;
                }
                case STREAMED: 
                case CHUNKED: {
                    m.setTransferEncoding(HttpTransferEncoding.SINGLE);
                    m.setContent((ByteBuf)Unpooled.compositeBuffer((int)this.maxCumulationBufferComponents));
                    this.currentMessage = m;
                    return null;
                }
            }
            throw new Error();
        }
        if (msg instanceof HttpChunk) {
            boolean last;
            if (currentMessage == null) {
                throw new IllegalStateException("received " + HttpChunk.class.getSimpleName() + " without " + HttpMessage.class.getSimpleName() + " or last message's transfer encoding was 'SINGLE'");
            }
            HttpChunk chunk = (HttpChunk)msg;
            ByteBuf content = currentMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - chunk.getContent().readableBytes()) {
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            this.appendToCumulation(chunk.getContent());
            if (!chunk.getDecoderResult().isSuccess()) {
                currentMessage.setDecoderResult(DecoderResult.partialFailure((Throwable)chunk.getDecoderResult().cause()));
                last = true;
            } else {
                last = chunk.isLast();
            }
            if (last) {
                this.currentMessage = null;
                if (chunk instanceof HttpChunkTrailer) {
                    HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                    for (Map.Entry<String, String> header : trailer.getHeaders()) {
                        currentMessage.setHeader(header.getKey(), header.getValue());
                    }
                }
                currentMessage.setHeader("Content-Length", String.valueOf(content.readableBytes()));
                return currentMessage;
            }
            return null;
        }
        throw new IllegalStateException("Only " + HttpMessage.class.getSimpleName() + " and " + HttpChunk.class.getSimpleName() + " are accepted: " + msg.getClass().getName());
    }

    private void appendToCumulation(ByteBuf input) {
        CompositeByteBuf cumulation = (CompositeByteBuf)this.currentMessage.getContent();
        cumulation.addComponent(input);
        cumulation.writerIndex(cumulation.capacity());
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }
}

