/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpChunkTrailer
extends DefaultHttpObject
implements HttpChunkTrailer {
    private final HttpHeaders headers = new HttpHeaders(){

        @Override
        void validateHeaderName(String name) {
            super.validateHeaderName(name);
            if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer")) {
                throw new IllegalArgumentException("prohibited trailing header: " + name);
            }
        }
    };

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.setHeader(name, value);
    }

    @Override
    public void setHeader(String name, Iterable<?> values) {
        this.headers.setHeader(name, values);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.removeHeader(name);
    }

    @Override
    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    @Override
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public ByteBuf getContent() {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public void setContent(ByteBuf content) {
        throw new IllegalStateException("read-only");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        boolean last = this.isLast();
        buf.append("(last: ");
        buf.append(last);
        if (!last) {
            buf.append(", size: ");
            buf.append(this.getContent().readableBytes());
        }
        buf.append(", decodeResult: ");
        buf.append(this.getDecoderResult());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.getHeaders()) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

