/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedByteChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.DefaultHttpChunk;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<Object, Object> {
    private EmbeddedByteChannel decoder;

    protected HttpContentDecoder() {
        super(new Class[]{HttpObject.class});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object decode(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            return msg;
        }
        if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m = (HttpMessage)msg;
            this.cleanup();
            String contentEncoding = m.getHeader("Content-Encoding");
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
            boolean bl = hasContent = m.getTransferEncoding().isMultiple() || m.getContent().readable();
            if (!hasContent || (this.decoder = this.newContentDecoder(contentEncoding)) == null) return msg;
            m.setHeader("Content-Encoding", this.getTargetContentEncoding(contentEncoding));
            if (!m.getTransferEncoding().isSingle()) return msg;
            ByteBuf content = m.getContent();
            ByteBuf newContent = Unpooled.buffer();
            this.decode(content, newContent);
            this.finishDecode(newContent);
            m.setContent(newContent);
            if (!m.containsHeader("Content-Length")) return msg;
            m.setHeader("Content-Length", Integer.toString(newContent.readableBytes()));
            return msg;
        } else {
            if (!(msg instanceof HttpChunk)) return msg;
            HttpChunk c = (HttpChunk)msg;
            ByteBuf content = c.getContent();
            if (this.decoder == null) return msg;
            if (!c.isLast()) {
                ByteBuf newContent = Unpooled.buffer();
                this.decode(content, newContent);
                if (!newContent.readable()) return null;
                c.setContent(newContent);
                return msg;
            } else {
                ByteBuf lastProduct = Unpooled.buffer();
                this.finishDecode(lastProduct);
                if (!lastProduct.readable()) return msg;
                return new Object[]{new DefaultHttpChunk(lastProduct), c};
            }
        }
    }

    protected abstract EmbeddedByteChannel newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.afterRemove(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.finishDecode(Unpooled.buffer());
        }
    }

    private void decode(ByteBuf in, ByteBuf out) {
        this.decoder.writeInbound(in);
        this.fetchDecoderOutput(out);
    }

    private void finishDecode(ByteBuf out) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(out);
        }
        this.decoder = null;
    }

    private void fetchDecoderOutput(ByteBuf out) {
        ByteBuf buf;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            out.writeBytes(buf);
        }
    }
}

