/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketFrameAggregator
extends MessageToMessageDecoder<WebSocketFrame> {
    private final int maxFrameSize;
    private WebSocketFrame currentFrame;

    public WebSocketFrameAggregator(int maxFrameSize) {
        if (maxFrameSize < 1) {
            throw new IllegalArgumentException("maxFrameSize must be > 0");
        }
        this.maxFrameSize = maxFrameSize;
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, MessageBuf<Object> out) throws Exception {
        if (this.currentFrame == null) {
            if (msg.isFinalFragment()) {
                out.add((Object)msg.retain());
                return;
            }
            CompositeByteBuf buf = ctx.alloc().compositeBuffer().addComponent(msg.content().retain());
            buf.writerIndex(buf.writerIndex() + msg.content().readableBytes());
            if (msg instanceof TextWebSocketFrame) {
                this.currentFrame = new TextWebSocketFrame(true, msg.rsv(), (ByteBuf)buf);
            } else if (msg instanceof BinaryWebSocketFrame) {
                this.currentFrame = new BinaryWebSocketFrame(true, msg.rsv(), (ByteBuf)buf);
            } else {
                throw new IllegalStateException("WebSocket frame was not of type TextWebSocketFrame or BinaryWebSocketFrame");
            }
            return;
        }
        if (msg instanceof ContinuationWebSocketFrame) {
            CompositeByteBuf content = (CompositeByteBuf)this.currentFrame.content();
            if (content.readableBytes() > this.maxFrameSize - msg.content().readableBytes()) {
                throw new TooLongFrameException("WebSocketFrame length exceeded " + content + " bytes.");
            }
            content.addComponent(msg.content().retain());
            content.writerIndex(content.writerIndex() + msg.content().readableBytes());
            if (msg.isFinalFragment()) {
                WebSocketFrame currentFrame = this.currentFrame;
                this.currentFrame = null;
                out.add((Object)currentFrame);
                return;
            }
            return;
        }
        out.add((Object)msg.retain());
    }
}

