/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.List;

public abstract class HttpObjectDecoder
extends ReplayingDecoder<State> {
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    protected final boolean validateHeaders;
    private ByteBuf content;
    private HttpMessage message;
    private long chunkSize;
    private int headerSize;
    private int contentRead;
    private final StringBuilder sb = new StringBuilder(128);

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported) {
        this(maxInitialLineLength, maxHeaderSize, maxChunkSize, chunkedSupported, true);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported, boolean validateHeaders) {
        super((Object)State.SKIP_CONTROL_CHARS);
        if (maxInitialLineLength <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + maxInitialLineLength);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        if (maxChunkSize < 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
        this.maxChunkSize = maxChunkSize;
        this.chunkedSupported = chunkedSupported;
        this.validateHeaders = validateHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case SKIP_CONTROL_CHARS: {
                try {
                    HttpObjectDecoder.skipControlCharacters(buffer);
                    this.checkpoint((Object)State.READ_INITIAL);
                }
                finally {
                    this.checkpoint();
                }
            }
            case READ_INITIAL: {
                try {
                    String[] initialLine = HttpObjectDecoder.splitInitialLine(this.readLine(buffer, this.maxInitialLineLength));
                    if (initialLine.length < 3) {
                        this.checkpoint((Object)State.SKIP_CONTROL_CHARS);
                        return;
                    }
                    this.message = this.createMessage(initialLine);
                    this.checkpoint((Object)State.READ_HEADER);
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_HEADER: {
                try {
                    State nextState = this.readHeaders(buffer);
                    this.checkpoint((Object)nextState);
                    if (nextState == State.READ_CHUNK_SIZE) {
                        if (!this.chunkedSupported) {
                            throw new IllegalArgumentException("Chunked messages not supported");
                        }
                        out.add(this.message);
                        return;
                    }
                    if (nextState == State.SKIP_CONTROL_CHARS) {
                        this.reset(out);
                        return;
                    }
                    long contentLength = HttpHeaders.getContentLength(this.message, -1L);
                    if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                        this.content = Unpooled.EMPTY_BUFFER;
                        this.reset(out);
                        return;
                    }
                    switch (nextState) {
                        case READ_FIXED_LENGTH_CONTENT: {
                            if (contentLength <= (long)this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                            this.checkpoint((Object)State.READ_FIXED_LENGTH_CONTENT_AS_CHUNKS);
                            this.chunkSize = HttpHeaders.getContentLength(this.message, -1L);
                            out.add(this.message);
                            return;
                        }
                        case READ_VARIABLE_LENGTH_CONTENT: {
                            if (buffer.readableBytes() <= this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                            this.checkpoint((Object)State.READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS);
                            out.add(this.message);
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected state: " + (Object)((Object)nextState));
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                out.add(this.message);
                out.add(new DefaultHttpContent(ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)toRead)));
                return;
            }
            case READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                ByteBuf content = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)toRead);
                if (!buffer.isReadable()) {
                    this.reset();
                    out.add(new DefaultLastHttpContent(content, this.validateHeaders));
                    return;
                }
                out.add(new DefaultHttpContent(content));
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                this.readFixedLengthContent(ctx, buffer, out);
                return;
            }
            case READ_FIXED_LENGTH_CONTENT_AS_CHUNKS: {
                long chunkSize = this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return;
                }
                int toRead = readLimit;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if ((long)toRead > chunkSize) {
                    toRead = (int)chunkSize;
                }
                ByteBuf content = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)toRead);
                chunkSize = chunkSize > (long)toRead ? (chunkSize -= (long)toRead) : 0L;
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.reset();
                    out.add(new DefaultLastHttpContent(content, this.validateHeaders));
                    return;
                }
                out.add(new DefaultHttpContent(content));
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    StringBuilder line = this.readLine(buffer, this.maxInitialLineLength);
                    int chunkSize = HttpObjectDecoder.getChunkSize(line.toString());
                    this.chunkSize = chunkSize;
                    if (chunkSize == 0) {
                        this.checkpoint((Object)State.READ_CHUNK_FOOTER);
                        return;
                    }
                    if (chunkSize > this.maxChunkSize) {
                        this.checkpoint((Object)State.READ_CHUNKED_CONTENT_AS_CHUNKS);
                    } else {
                        this.checkpoint((Object)State.READ_CHUNKED_CONTENT);
                    }
                }
                catch (Exception e) {
                    out.add(this.invalidChunk(e));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                DefaultHttpContent chunk = new DefaultHttpContent(ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)((int)this.chunkSize)));
                this.checkpoint((Object)State.READ_CHUNK_DELIMITER);
                out.add(chunk);
                return;
            }
            case READ_CHUNKED_CONTENT_AS_CHUNKS: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int chunkSize = (int)this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return;
                }
                int toRead = chunkSize;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if (toRead > readLimit) {
                    toRead = readLimit;
                }
                DefaultHttpContent chunk = new DefaultHttpContent(ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)toRead));
                chunkSize = chunkSize > toRead ? (chunkSize -= toRead) : 0;
                this.chunkSize = chunkSize;
                if (chunkSize == 0) {
                    this.checkpoint((Object)State.READ_CHUNK_DELIMITER);
                }
                out.add(chunk);
                return;
            }
            case READ_CHUNK_DELIMITER: {
                while (true) {
                    byte next;
                    if ((next = buffer.readByte()) == 13) {
                        if (buffer.readByte() != 10) continue;
                        this.checkpoint((Object)State.READ_CHUNK_SIZE);
                        return;
                    }
                    if (next == 10) {
                        this.checkpoint((Object)State.READ_CHUNK_SIZE);
                        return;
                    }
                    this.checkpoint();
                }
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent trailer = this.readTrailingHeaders(buffer);
                    if (this.maxChunkSize == 0) {
                        this.reset(out);
                        return;
                    }
                    this.reset();
                    out.add(trailer);
                    return;
                }
                catch (Exception e) {
                    out.add(this.invalidChunk(e));
                    return;
                }
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(this.actualReadableBytes());
                return;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
        if (this.message != null) {
            boolean prematureClosure;
            HttpMessage message = this.message;
            int actualContentLength = this.content != null ? this.content.readableBytes() : 0;
            if (this.isDecodingRequest()) {
                prematureClosure = true;
            } else {
                long expectedContentLength = HttpHeaders.getContentLength(message, -1L);
                boolean bl = prematureClosure = expectedContentLength >= 0L && (long)actualContentLength != expectedContentLength;
            }
            if (!prematureClosure) {
                if (actualContentLength == 0) {
                    out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                } else {
                    out.add(new DefaultLastHttpContent(this.content, this.validateHeaders));
                }
            }
        }
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.getStatus().code();
            if (code >= 100 && code < 200) {
                return code != 101 || res.headers().contains("Sec-WebSocket-Accept");
            }
            switch (code) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    private void reset() {
        this.reset(null);
    }

    private void reset(List<Object> out) {
        if (out != null) {
            HttpMessage message = this.message;
            ByteBuf content = this.content;
            LastHttpContent httpContent = content == null || !content.isReadable() ? LastHttpContent.EMPTY_LAST_CONTENT : new DefaultLastHttpContent(content, this.validateHeaders);
            out.add(message);
            out.add(httpContent);
        }
        this.content = null;
        this.message = null;
        this.checkpoint((Object)State.SKIP_CONTROL_CHARS);
    }

    private HttpMessage invalidMessage(Exception cause) {
        this.checkpoint((Object)State.BAD_MESSAGE);
        if (this.message != null) {
            this.message.setDecoderResult(DecoderResult.failure((Throwable)cause));
        } else {
            this.message = this.createInvalidMessage();
            this.message.setDecoderResult(DecoderResult.failure((Throwable)cause));
        }
        return this.message;
    }

    private HttpContent invalidChunk(Exception cause) {
        this.checkpoint((Object)State.BAD_MESSAGE);
        DefaultHttpContent chunk = new DefaultHttpContent(Unpooled.EMPTY_BUFFER);
        chunk.setDecoderResult(DecoderResult.failure((Throwable)cause));
        return chunk;
    }

    private static void skipControlCharacters(ByteBuf buffer) {
        char c;
        while (Character.isISOControl(c = (char)buffer.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    private void readFixedLengthContent(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        long length = HttpHeaders.getContentLength(this.message, -1L);
        assert (length <= Integer.MAX_VALUE);
        int toRead = (int)length - this.contentRead;
        if (toRead > this.actualReadableBytes()) {
            toRead = this.actualReadableBytes();
        }
        this.contentRead += toRead;
        if (length < (long)this.contentRead) {
            out.add(this.message);
            out.add(new DefaultHttpContent(ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)toRead)));
            return;
        }
        if (this.content == null) {
            this.content = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)((int)length));
        } else {
            this.content.writeBytes(buffer, (int)length);
        }
        this.reset(out);
    }

    private State readHeaders(ByteBuf buffer) {
        State nextState;
        this.headerSize = 0;
        HttpMessage message = this.message;
        HttpHeaders headers = message.headers();
        StringBuilder line = this.readHeader(buffer);
        String name = null;
        String value = null;
        if (line.length() > 0) {
            headers.clear();
            do {
                char firstChar = line.charAt(0);
                if (name != null && (firstChar == ' ' || firstChar == '\t')) {
                    value = value + ' ' + line.toString().trim();
                    continue;
                }
                if (name != null) {
                    headers.add(name, value);
                }
                String[] header = HttpObjectDecoder.splitHeader(line);
                name = header[0];
                value = header[1];
            } while ((line = this.readHeader(buffer)).length() > 0);
            if (name != null) {
                headers.add(name, (Object)value);
            }
        }
        if (this.isContentAlwaysEmpty(message)) {
            HttpHeaders.removeTransferEncodingChunked(message);
            nextState = State.SKIP_CONTROL_CHARS;
        } else {
            nextState = HttpHeaders.isTransferEncodingChunked(message) ? State.READ_CHUNK_SIZE : (HttpHeaders.getContentLength(message, -1L) >= 0L ? State.READ_FIXED_LENGTH_CONTENT : State.READ_VARIABLE_LENGTH_CONTENT);
        }
        return nextState;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf buffer) {
        this.headerSize = 0;
        StringBuilder line = this.readHeader(buffer);
        String lastHeader = null;
        if (line.length() > 0) {
            DefaultLastHttpContent trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List<String> current = trailer.trailingHeaders().getAll(lastHeader);
                    if (current.isEmpty()) continue;
                    int lastPos = current.size() - 1;
                    String newString = current.get(lastPos) + line.toString().trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = HttpObjectDecoder.splitHeader(line);
                String name = header[0];
                if (!(HttpHeaders.equalsIgnoreCase(name, "Content-Length") || HttpHeaders.equalsIgnoreCase(name, "Transfer-Encoding") || HttpHeaders.equalsIgnoreCase(name, "Trailer"))) {
                    trailer.trailingHeaders().add(name, (Object)header[1]);
                }
                lastHeader = name;
            } while ((line = this.readHeader(buffer)).length() > 0);
            return trailer;
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringBuilder readHeader(ByteBuf buffer) {
        StringBuilder sb = this.sb;
        sb.setLength(0);
        int headerSize = this.headerSize;
        block4: while (true) {
            char nextByte = (char)buffer.readByte();
            ++headerSize;
            switch (nextByte) {
                case '\r': {
                    nextByte = (char)buffer.readByte();
                    ++headerSize;
                    if (nextByte != '\n') break;
                    break block4;
                }
                case '\n': {
                    break block4;
                }
            }
            if (headerSize >= this.maxHeaderSize) {
                throw new TooLongFrameException("HTTP header is larger than " + this.maxHeaderSize + " bytes.");
            }
            sb.append(nextByte);
        }
        this.headerSize = headerSize;
        return sb;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    private StringBuilder readLine(ByteBuf buffer, int maxLineLength) {
        StringBuilder sb = this.sb;
        sb.setLength(0);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return sb;
            }
            if (nextByte == 10) {
                return sb;
            }
            if (lineLength >= maxLineLength) {
                throw new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }

    private static String[] splitInitialLine(StringBuilder sb) {
        int aStart = HttpObjectDecoder.findNonWhitespace(sb, 0);
        int aEnd = HttpObjectDecoder.findWhitespace(sb, aStart);
        int bStart = HttpObjectDecoder.findNonWhitespace(sb, aEnd);
        int bEnd = HttpObjectDecoder.findWhitespace(sb, bStart);
        int cStart = HttpObjectDecoder.findNonWhitespace(sb, bEnd);
        int cEnd = HttpObjectDecoder.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), cStart < cEnd ? sb.substring(cStart, cEnd) : ""};
    }

    private static String[] splitHeader(StringBuilder sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpObjectDecoder.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = HttpObjectDecoder.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = HttpObjectDecoder.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }

    private static int findNonWhitespace(CharSequence sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findWhitespace(CharSequence sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findEndOfString(CharSequence sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS,
        READ_FIXED_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT_AS_CHUNKS,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNKED_CONTENT_AS_CHUNKS,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE;

    }
}

